/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.concurrent.EzyEventLoopGroup;
import com.tvd12.ezyfoxserver.client.config.EzySocketClientConfig;
import com.tvd12.ezyfoxserver.client.socket.EzySocketClient;
import com.tvd12.ezyfoxserver.client.socket.EzyTcpSslSocketReader;
import com.tvd12.ezyfoxserver.client.socket.EzyTcpSslSocketWriter;
import com.tvd12.ezyfoxserver.client.ssl.EzySslContextFactory;
import java.io.InputStream;
import java.io.OutputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class EzyTcpSslSocketClient
extends EzySocketClient {
    private SSLSocket sslSocket;
    private SSLContext sslContext;
    private InputStream inputStream;
    private OutputStream outputStream;

    public EzyTcpSslSocketClient(EzySocketClientConfig config) {
        super(config);
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    protected boolean connectNow() {
        try {
            if (this.sslContext == null) {
                this.sslContext = EzySslContextFactory.getInstance().newSslContext();
            }
            SSLSocketFactory clientFactory = this.sslContext.getSocketFactory();
            this.sslSocket = (SSLSocket)clientFactory.createSocket(this.host, this.port);
            this.inputStream = this.sslSocket.getInputStream();
            this.outputStream = this.sslSocket.getOutputStream();
            this.sslSocket.startHandshake();
            return true;
        }
        catch (Throwable e) {
            this.processConnectionException(e);
            return false;
        }
    }

    @Override
    protected void resetSocket() {
        this.sslSocket = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    @Override
    protected void closeSocket() {
        try {
            if (this.sslSocket != null) {
                this.sslSocket.close();
            }
        }
        catch (Throwable e) {
            this.logger.info("close socket error");
        }
    }

    @Override
    protected void createAdapters() {
        this.socketReader = new EzyTcpSslSocketReader();
        this.socketWriter = new EzyTcpSslSocketWriter();
    }

    @Override
    protected void startAdapters() {
        EzyTcpSslSocketReader sslSocketReader = (EzyTcpSslSocketReader)this.socketReader;
        sslSocketReader.setInputStream(this.inputStream);
        EzyTcpSslSocketWriter sslSocketWriter = (EzyTcpSslSocketWriter)this.socketWriter;
        sslSocketWriter.setOutputStream(this.outputStream);
        sslSocketReader.start();
        sslSocketWriter.start();
    }

    @Override
    public void setEventLoopGroup(EzyEventLoopGroup eventLoopGroup) {
    }
}

