/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.codec.EzyMessageReaders;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfoxserver.client.concurrent.EzySynchronizedQueue;
import com.tvd12.ezyfoxserver.client.socket.EzySocketAdapter;
import com.tvd12.ezyfoxserver.client.socket.EzySocketDataDecoder;
import com.tvd12.ezyfoxserver.client.util.EzyQueue;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.List;
import lombok.Generated;

public class EzyUdpSocketReader
extends EzySocketAdapter {
    protected final ByteBuffer buffer;
    protected final int readBufferSize;
    protected final EzyQueue<EzyArray> dataQueue = new EzySynchronizedQueue<EzyArray>();
    protected byte[] decryptionKey;
    protected EzySocketDataDecoder decoder;
    protected DatagramChannel datagramChannel;

    public EzyUdpSocketReader() {
        this.readBufferSize = 8192;
        this.buffer = ByteBuffer.allocateDirect(this.readBufferSize);
    }

    @Override
    protected void update() {
        try {
            while (true) {
                if (!this.active) {
                    return;
                }
                this.buffer.clear();
                int bytesToRead = this.readSocketData();
                if (bytesToRead <= 0) {
                    return;
                }
                this.buffer.flip();
                byte[] binary = new byte[this.buffer.limit()];
                this.buffer.get(binary);
                this.handleReceivedBytes(binary);
            }
        }
        catch (InterruptedException e) {
            this.logger.debug("socket reader interrupted", (Throwable)e);
            return;
        }
        catch (Throwable e) {
            this.logger.info("I/O error at socket-reader", e);
            return;
        }
    }

    @Override
    public boolean call() {
        try {
            if (!this.active) {
                return false;
            }
            this.buffer.clear();
            Integer bytesToRead = this.nonBlockingReadSocketData();
            if (bytesToRead == null) {
                return true;
            }
            if (bytesToRead <= 0) {
                return false;
            }
            this.buffer.flip();
            byte[] binary = new byte[this.buffer.limit()];
            this.buffer.get(binary);
            this.handleReceivedBytes(binary);
        }
        catch (Throwable e) {
            this.logger.info("I/O error at socket-reader event loop", e);
            return false;
        }
        return true;
    }

    protected int readSocketData() throws Exception {
        try {
            this.datagramChannel.receive(this.buffer);
            return this.buffer.position();
        }
        catch (Throwable e) {
            this.handleSocketReaderException(e);
            return -1;
        }
    }

    protected Integer nonBlockingReadSocketData() {
        try {
            SocketAddress serverAddress = this.datagramChannel.receive(this.buffer);
            if (serverAddress == null) {
                return null;
            }
            return this.buffer.position();
        }
        catch (Throwable e) {
            this.handleSocketReaderException(e);
            return -1;
        }
    }

    protected void handleReceivedBytes(byte[] bytes) {
        EzyMessage message = EzyMessageReaders.bytesToMessage((byte[])bytes);
        if (message == null) {
            return;
        }
        this.onMessageReceived(message);
    }

    @Override
    protected void clear() {
        if (this.dataQueue != null) {
            this.dataQueue.clear();
        }
    }

    public void popMessages(List<EzyArray> buffer) {
        this.dataQueue.pollAll(buffer);
    }

    private void onMessageReceived(EzyMessage message) {
        try {
            Object data = this.decoder.decode(message, this.decryptionKey);
            this.dataQueue.add((EzyArray)data);
        }
        catch (Throwable e) {
            this.logger.info("decode error at socket-reader", e);
        }
    }

    @Override
    protected String getThreadName() {
        return "udp-socket-reader";
    }

    @Generated
    public void setDecryptionKey(byte[] decryptionKey) {
        this.decryptionKey = decryptionKey;
    }

    @Generated
    public void setDecoder(EzySocketDataDecoder decoder) {
        this.decoder = decoder;
    }

    @Generated
    public void setDatagramChannel(DatagramChannel datagramChannel) {
        this.datagramChannel = datagramChannel;
    }
}

