/*
 * Decompiled with CFR 0.152.
 */
package com.twikey;

import com.twikey.TwikeyClient;
import com.twikey.callback.InvoiceCallback;
import com.twikey.modal.Customer;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDate;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class InvoiceGateway {
    private final TwikeyClient twikeyClient;

    protected InvoiceGateway(TwikeyClient twikeyClient) {
        this.twikeyClient = twikeyClient;
    }

    public JSONObject create(long ct, Customer customer, Map<String, String> invoiceDetails) throws IOException, TwikeyClient.UserException {
        JSONObject customerAsJson = new JSONObject().put("customerNumber", (Object)customer.getNumber()).put("email", (Object)customer.getEmail()).put("firstname", (Object)customer.getFirstname()).put("lastname", (Object)customer.getLastname()).put("l", (Object)customer.getLang()).put("address", (Object)customer.getStreet()).put("city", (Object)customer.getCity()).put("zip", (Object)customer.getZip()).put("country", (Object)customer.getCountry()).put("mobile", (Object)customer.getMobile());
        if (customer.getCompanyName() != null) {
            customerAsJson.put("companyName", (Object)customer.getCompanyName()).put("coc", (Object)customer.getCoc());
        }
        JSONObject invoice = new JSONObject().put("customer", (Object)customerAsJson).put("date", (Object)invoiceDetails.getOrDefault("date", LocalDate.now().toString())).put("duedate", (Object)invoiceDetails.getOrDefault("date", LocalDate.now().plusMonths(1L).toString())).put("ct", ct);
        for (Map.Entry<String, String> entry : invoiceDetails.entrySet()) {
            invoice.put(entry.getKey(), (Object)entry.getValue());
        }
        URL myurl = this.twikeyClient.getUrl("/invoice");
        HttpURLConnection con = (HttpURLConnection)myurl.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("User-Agent", this.twikeyClient.getUserAgent());
        con.setRequestProperty("Authorization", this.twikeyClient.getSessionToken());
        con.setDoOutput(true);
        con.setDoInput(true);
        try (DataOutputStream output = new DataOutputStream(con.getOutputStream());){
            output.writeBytes(invoice.toString());
            output.flush();
        }
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)br));
                return jSONObject;
            }
        }
        String apiError = con.getHeaderField("ApiError");
        throw new TwikeyClient.UserException(apiError);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void feed(InvoiceCallback invoiceCallback) throws IOException, TwikeyClient.UserException {
        boolean isEmpty;
        URL myurl = this.twikeyClient.getUrl("/invoice");
        do {
            HttpURLConnection con = (HttpURLConnection)myurl.openConnection();
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("User-Agent", this.twikeyClient.getUserAgent());
            con.setRequestProperty("Authorization", this.twikeyClient.getSessionToken());
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                String apiError = con.getHeaderField("ApiError");
                throw new TwikeyClient.UserException(apiError);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                JSONObject json = new JSONObject(new JSONTokener((Reader)br));
                JSONArray invoicesArr = json.getJSONArray("Invoices");
                isEmpty = invoicesArr.isEmpty();
                if (invoicesArr.isEmpty()) continue;
                for (int i = 0; i < invoicesArr.length(); ++i) {
                    JSONObject obj = invoicesArr.getJSONObject(i);
                    invoiceCallback.invoice(obj);
                }
            }
        } while (!isEmpty);
    }
}

