/*
 * Decompiled with CFR 0.152.
 */
package com.twikey;

import com.twikey.TwikeyClient;
import com.twikey.callback.PaylinkCallback;
import com.twikey.modal.Customer;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class PaylinkGateway {
    private final TwikeyClient twikeyClient;

    protected PaylinkGateway(TwikeyClient twikeyClient) {
        this.twikeyClient = twikeyClient;
    }

    public JSONObject create(long ct, Customer customer, Map<String, String> linkDetails) throws IOException, TwikeyClient.UserException {
        HashMap<String, String> params = new HashMap<String, String>(linkDetails);
        params.put("ct", String.valueOf(ct));
        if (customer != null) {
            params.put("customerNumber", customer.getNumber());
            params.put("email", customer.getEmail());
            params.put("firstname", customer.getFirstname());
            params.put("lastname", customer.getLastname());
            params.put("l", customer.getLang());
            params.put("address", customer.getStreet());
            params.put("city", customer.getCity());
            params.put("zip", customer.getZip());
            params.put("country", customer.getCountry());
            params.put("mobile", customer.getMobile());
            if (customer.getCompanyName() != null) {
                params.put("companyName", customer.getCompanyName());
                params.put("coc", customer.getCoc());
            }
        }
        URL myurl = this.twikeyClient.getUrl("/payment/link");
        HttpURLConnection con = (HttpURLConnection)myurl.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setRequestProperty("User-Agent", this.twikeyClient.getUserAgent());
        con.setRequestProperty("Authorization", this.twikeyClient.getSessionToken());
        con.setDoOutput(true);
        con.setDoInput(true);
        try (DataOutputStream output = new DataOutputStream(con.getOutputStream());){
            output.writeBytes(TwikeyClient.getPostDataString(params));
            output.flush();
        }
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)br));
                return jSONObject;
            }
        }
        String apiError = con.getHeaderField("ApiError");
        throw new TwikeyClient.UserException(apiError);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void feed(PaylinkCallback callback) throws IOException, TwikeyClient.UserException {
        boolean isEmpty;
        URL myurl = this.twikeyClient.getUrl("/payment/link/feed");
        do {
            HttpURLConnection con = (HttpURLConnection)myurl.openConnection();
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("User-Agent", this.twikeyClient.getUserAgent());
            con.setRequestProperty("Authorization", this.twikeyClient.getSessionToken());
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                String apiError = con.getHeaderField("ApiError");
                throw new TwikeyClient.UserException(apiError);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                JSONObject json = new JSONObject(new JSONTokener((Reader)br));
                JSONArray messagesArr = json.getJSONArray("Messages");
                isEmpty = messagesArr.isEmpty();
                if (isEmpty) continue;
                for (int i = 0; i < messagesArr.length(); ++i) {
                    JSONObject obj = messagesArr.getJSONObject(i);
                    callback.paylink(obj);
                }
            }
        } while (!isEmpty);
    }
}

