/*
 * Decompiled with CFR 0.152.
 */
package com.twikey;

import com.twikey.TwikeyClient;
import com.twikey.callback.TransactionCallback;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TransactionGateway {
    private final TwikeyClient twikeyClient;

    protected TransactionGateway(TwikeyClient twikeyClient) {
        this.twikeyClient = twikeyClient;
    }

    public JSONObject create(String mandateNumber, Map<String, String> transactionDetails) throws IOException, TwikeyClient.UserException {
        HashMap<String, String> params = new HashMap<String, String>(transactionDetails);
        params.put("mndtId", mandateNumber);
        URL myurl = this.twikeyClient.getUrl("/transaction");
        HttpURLConnection con = (HttpURLConnection)myurl.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setRequestProperty("User-Agent", this.twikeyClient.getUserAgent());
        con.setRequestProperty("Authorization", this.twikeyClient.getSessionToken());
        con.setDoOutput(true);
        con.setDoInput(true);
        try (DataOutputStream output = new DataOutputStream(con.getOutputStream());){
            output.writeBytes(TwikeyClient.getPostDataString(params));
            output.flush();
        }
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)br)).getJSONArray("Entries").optJSONObject(0);
                return jSONObject;
            }
        }
        String apiError = con.getHeaderField("ApiError");
        throw new TwikeyClient.UserException(apiError);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void feed(TransactionCallback callback) throws IOException, TwikeyClient.UserException {
        boolean isEmpty;
        URL myurl = this.twikeyClient.getUrl("/transaction");
        do {
            HttpURLConnection con = (HttpURLConnection)myurl.openConnection();
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("User-Agent", this.twikeyClient.getUserAgent());
            con.setRequestProperty("Authorization", this.twikeyClient.getSessionToken());
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                String apiError = con.getHeaderField("ApiError");
                throw new TwikeyClient.UserException(apiError);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                JSONObject json = new JSONObject(new JSONTokener((Reader)br));
                JSONArray messagesArr = json.getJSONArray("Entries");
                isEmpty = messagesArr.isEmpty();
                if (isEmpty) continue;
                for (int i = 0; i < messagesArr.length(); ++i) {
                    JSONObject obj = messagesArr.getJSONObject(i);
                    callback.transaction(obj);
                }
            }
        } while (!isEmpty);
    }
}

