/*
 * Decompiled with CFR 0.152.
 */
package com.twikey;

import com.twikey.DocumentGateway;
import com.twikey.InvoiceGateway;
import com.twikey.PaylinkGateway;
import com.twikey.TransactionGateway;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class TwikeyClient {
    private static final String UTF_8 = "UTF-8";
    private static final String DEFAULT_USER_HEADER = "twikey/java-v0.1.0";
    private static final String PROD_ENVIRONMENT = "https://api.twikey.com/creditor";
    private static final String TEST_ENVIRONMENT = "https://api.beta.twikey.com/creditor";
    private static final long MAX_SESSION_AGE = 4968000L;
    private static final String SALT_OWN = "own";
    private final String apiKey;
    private String privateKey;
    private final String endpoint;
    private long lastLogin;
    private String sessionToken;
    private String userAgent = "twikey/java-v0.1.0";
    private final DocumentGateway documentGateway;
    private final InvoiceGateway invoiceGateway;
    private final TransactionGateway transactionGateway;
    private final PaylinkGateway paylinkGateway;

    public TwikeyClient(String apikey, boolean test) {
        this.apiKey = apikey;
        this.endpoint = test ? TEST_ENVIRONMENT : PROD_ENVIRONMENT;
        this.documentGateway = new DocumentGateway(this);
        this.invoiceGateway = new InvoiceGateway(this);
        this.transactionGateway = new TransactionGateway(this);
        this.paylinkGateway = new PaylinkGateway(this);
    }

    public TwikeyClient withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public TwikeyClient withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public TwikeyClient(String apikey) {
        this(apikey, false);
    }

    protected String getSessionToken() throws IOException, UnauthenticatedException {
        if (System.currentTimeMillis() - this.lastLogin > 4968000L) {
            URL myurl = new URL(this.endpoint);
            HttpURLConnection con = (HttpURLConnection)myurl.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", this.userAgent);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setDoOutput(true);
            con.setDoInput(true);
            try (DataOutputStream output = new DataOutputStream(con.getOutputStream());){
                if (this.privateKey != null) {
                    long otp = TwikeyClient.generateOtp(SALT_OWN, this.privateKey);
                    output.writeBytes(String.format("apiToken=%s&otp=%d", this.apiKey, otp));
                } else {
                    output.writeBytes(String.format("apiToken=%s", this.apiKey));
                }
                output.flush();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.sessionToken = con.getHeaderField("Authorization");
            con.disconnect();
            if (this.sessionToken != null) {
                this.lastLogin = System.currentTimeMillis();
            } else {
                this.lastLogin = 0L;
                throw new UnauthenticatedException();
            }
        }
        return this.sessionToken;
    }

    protected static String getPostDataString(Map<String, String> params) {
        try {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(entry.getKey(), UTF_8));
                result.append("=");
                result.append(URLEncoder.encode(entry.getValue(), UTF_8));
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getUrl(String path) throws MalformedURLException {
        return new URL(String.format("%s%s", this.endpoint, path));
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public DocumentGateway document() {
        return this.documentGateway;
    }

    public InvoiceGateway invoice() {
        return this.invoiceGateway;
    }

    public TransactionGateway transaction() {
        return this.transactionGateway;
    }

    public PaylinkGateway paylink() {
        return this.paylinkGateway;
    }

    public boolean verifyWebHookSignature(String signatureHeader, String queryString) {
        byte[] providedSignature = DatatypeConverter.parseHexBinary((String)signatureHeader);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret = new SecretKeySpec(this.apiKey.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            mac.init(secret);
            byte[] calculated = mac.doFinal(queryString.getBytes(StandardCharsets.UTF_8));
            boolean equal = true;
            for (int i = 0; i < calculated.length; ++i) {
                equal = equal && providedSignature[i] == calculated[i];
            }
            return equal;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifyExiturlSignature(String websitekey, String document, String status, String token, String signature) {
        byte[] providedSignature = DatatypeConverter.parseHexBinary((String)signature);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret = new SecretKeySpec(websitekey.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            mac.init(secret);
            String payload = document + "/" + status;
            if (token != null) {
                payload = payload + "/" + token;
            }
            byte[] calculated = mac.doFinal(payload.getBytes(StandardCharsets.UTF_8));
            boolean equal = true;
            for (int i = 0; i < calculated.length; ++i) {
                equal = equal && providedSignature[i] == calculated[i];
            }
            return equal;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] decryptAccountInformation(String websitekey, String document, String encryptedAccount) {
        String key = document + websitekey;
        try {
            byte[] keyBytes = MessageDigest.getInstance("MD5").digest(key.getBytes(StandardCharsets.UTF_8));
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(keyBytes, "AES"), new IvParameterSpec(keyBytes));
            byte[] val = cipher.doFinal(DatatypeConverter.parseHexBinary((String)encryptedAccount));
            return new String(val, StandardCharsets.UTF_8).split("/");
        }
        catch (Exception e) {
            throw new RuntimeException("Exception decrypting : " + encryptedAccount, e);
        }
    }

    private static long generateOtp(String salt, String privateKey) throws GeneralSecurityException {
        if (privateKey == null) {
            throw new IllegalArgumentException("Invalid key");
        }
        long counter = (long)Math.floor(System.currentTimeMillis() / 30000L);
        byte[] key = DatatypeConverter.parseHexBinary((String)privateKey);
        if (salt != null) {
            byte[] saltBytes = salt.getBytes(StandardCharsets.UTF_8);
            byte[] key2 = new byte[saltBytes.length + key.length];
            System.arraycopy(saltBytes, 0, key2, 0, saltBytes.length);
            System.arraycopy(key, 0, key2, saltBytes.length, key.length);
            key = key2;
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(key, "SHA256"));
        byte[] counterAsBytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            counterAsBytes[i] = (byte)(counter & 0xFFL);
            counter >>= 8;
        }
        byte[] hash = mac.doFinal(counterAsBytes);
        int offset = hash[19] & 0xF;
        long v = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        return v % 100000000L;
    }

    public static class UnauthenticatedException
    extends UserException {
        public UnauthenticatedException() {
            super("Not authenticated");
        }
    }

    public static class UserException
    extends Throwable {
        public UserException(String apiError) {
            super(apiError);
        }
    }
}

