/*
 * Decompiled with CFR 0.152.
 */
package com.undefinedlabs.scope.rules.sql.provider;

import com.undefinedlabs.scope.rules.sql.provider.ConnectionInfoProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.NoopConnectionInfoProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.h2.H2JdbcConnectionInfoProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.mysql.MySqlConnectionImplInfoProvider;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

public enum ConnectionInfoProviderRegistry {
    INSTANCE;

    private static final ConnectionInfoProvider NOOP_PROVIDER;
    private static final Map<String, ConnectionInfoProvider> PROVIDERS;

    public ConnectionInfoProvider getProvider(Connection connection) {
        return connection != null ? this.getProvider(connection.getClass().getName()) : NOOP_PROVIDER;
    }

    ConnectionInfoProvider getProvider(String connectionClassName) {
        return PROVIDERS.get(connectionClassName) != null ? PROVIDERS.get(connectionClassName) : NOOP_PROVIDER;
    }

    static {
        NOOP_PROVIDER = new NoopConnectionInfoProvider();
        PROVIDERS = new HashMap<String, ConnectionInfoProvider>();
        PROVIDERS.put("org.h2.jdbc.JdbcConnection", new H2JdbcConnectionInfoProvider());
        PROVIDERS.put("com.mysql.cj.jdbc.ConnectionImpl", new MySqlConnectionImplInfoProvider());
    }
}

