/*
 * Decompiled with CFR 0.152.
 */
package com.undefinedlabs.scope.rules.sql.provider;

import com.undefinedlabs.scope.rules.sql.provider.PreparedStatementQueryProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.NoopPreparedStatementQueryProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.h2.H2JdbcPreparedStatementQueryProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.mysql.MySqlClientPreparedStatementQueryProvider;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;

public enum PreparedStatementQueryProviderRegistry {
    INSTANCE;

    private static final PreparedStatementQueryProvider NOOP_PROVIDER;
    private static final Map<String, PreparedStatementQueryProvider> PROVIDERS;

    public PreparedStatementQueryProvider getProvider(PreparedStatement preparedStatement) {
        return preparedStatement != null ? this.getProvider(preparedStatement.getClass().getName()) : NOOP_PROVIDER;
    }

    PreparedStatementQueryProvider getProvider(String preparedStatementClassName) {
        return PROVIDERS.get(preparedStatementClassName) != null ? PROVIDERS.get(preparedStatementClassName) : NOOP_PROVIDER;
    }

    static {
        NOOP_PROVIDER = new NoopPreparedStatementQueryProvider();
        PROVIDERS = new HashMap<String, PreparedStatementQueryProvider>();
        PROVIDERS.put("org.h2.jdbc.JdbcPreparedStatement", H2JdbcPreparedStatementQueryProvider.INSTANCE);
        PROVIDERS.put("com.mysql.cj.jdbc.ClientPreparedStatement", MySqlClientPreparedStatementQueryProvider.INSTANCE);
        PROVIDERS.put("com.mysql.cj.jdbc.ServerPreparedStatement", MySqlClientPreparedStatementQueryProvider.INSTANCE);
        PROVIDERS.put("com.mysql.cj.jdbc.CallableStatement", MySqlClientPreparedStatementQueryProvider.INSTANCE);
    }
}

