package com.undefinedlabs.scope.rules.sql.provider.internal.h2;

import com.undefinedlabs.scope.jdk.reflection.ReflectionContext;
import com.undefinedlabs.scope.rules.sql.model.PreparedStatementQuery;
import com.undefinedlabs.scope.rules.sql.model.PreparedStatementQueryParameter;
import com.undefinedlabs.scope.rules.sql.provider.PreparedStatementQueryProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.PreparedStatementQueryUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public enum H2JdbcPreparedStatementQueryProvider implements PreparedStatementQueryProvider {

    INSTANCE;

    public static final String JDBC_PREPARED_STATEMENT_CLASS_NAME = "org.h2.jdbc.JdbcPreparedStatement";

    @Override
    public PreparedStatementQuery create(final PreparedStatement preparedStatement) {
        if(preparedStatement == null || !(ReflectionContext.INSTANCE.getScopeClass(JDBC_PREPARED_STATEMENT_CLASS_NAME).isInstance(preparedStatement))) {
            return PreparedStatementQuery.EMPTY;
        }

        try {
            final ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            final String sqlPreparedStatement = (String) FieldUtils.readField(preparedStatement, "sqlStatement", true);
            final String sqlMethod = PreparedStatementQueryUtils.INSTANCE.extractSqlMethod(sqlPreparedStatement);
            final Object command = FieldUtils.readField(preparedStatement, "command", true);
            final List parametersList = (List) MethodUtils.invokeMethod(command, "getParameters");

            final Map<String, PreparedStatementQueryParameter> parametersMap = new LinkedHashMap<>();
            for(int i = 0; i < parametersList.size(); i++){
                final Object paramValue = MethodUtils.invokeMethod(parametersList.get(i), "getParamValue");
                final Object paramType = MethodUtils.invokeMethod(paramValue, "getType");

                final int paramIndex = i + 1;
                final String paramKey = PreparedStatementQueryUtils.INSTANCE.generateParamKey(paramIndex); //SQL params start by 1.
                final String paramTypeSQL = (paramType.getClass().getName().equalsIgnoreCase("org.h2.value.TypeInfo")) ? (MethodUtils.invokeMethod(paramType, "getSQL", new StringBuilder())).toString() : String.valueOf(paramType);
                final String paramValueSQL = (String) MethodUtils.invokeMethod(paramValue, "getSQL");
                final PreparedStatementQueryParameter param = new PreparedStatementQueryParameter(paramTypeSQL, parameterMetaData.getParameterClassName(paramIndex), paramValueSQL);
                parametersMap.put(paramKey, param);
            }

            final PreparedStatementQuery.Builder builder = PreparedStatementQuery.newBuilder();
            builder.withSqlStatement(PreparedStatementQueryUtils.INSTANCE.buildSql(sqlPreparedStatement, parametersMap));
            builder.withSqlMethod(sqlMethod);
            builder.withSqlPreparedStatement(parametersMap.isEmpty() ? null : sqlPreparedStatement);
            builder.withSqlParameterMap(parametersMap.isEmpty() ? null : parametersMap);
            return builder.build();

        } catch(Exception e){
            throw new RuntimeException(e);
        }
    }
}
