/*
 * Decompiled with CFR 0.152.
 */
package com.undefinedlabs.scope.rules.sql.provider.internal.h2;

import com.undefinedlabs.scope.jdk.reflection.ReflectionContext;
import com.undefinedlabs.scope.rules.sql.model.PreparedStatementQuery;
import com.undefinedlabs.scope.rules.sql.model.PreparedStatementQueryParameter;
import com.undefinedlabs.scope.rules.sql.provider.PreparedStatementQueryProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.PreparedStatementQueryUtils;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public enum H2JdbcPreparedStatementQueryProvider implements PreparedStatementQueryProvider
{
    INSTANCE;

    public static final String JDBC_PREPARED_STATEMENT_CLASS_NAME = "org.h2.jdbc.JdbcPreparedStatement";

    @Override
    public PreparedStatementQuery create(PreparedStatement preparedStatement) {
        if (preparedStatement == null || !ReflectionContext.INSTANCE.getScopeClass(JDBC_PREPARED_STATEMENT_CLASS_NAME, preparedStatement.getClass().getClassLoader()).isInstance(preparedStatement)) {
            return PreparedStatementQuery.EMPTY;
        }
        try {
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            String sqlPreparedStatement = (String)FieldUtils.readField((Object)preparedStatement, (String)"sqlStatement", (boolean)true);
            String sqlMethod = PreparedStatementQueryUtils.INSTANCE.extractSqlMethod(sqlPreparedStatement);
            Object command = FieldUtils.readField((Object)preparedStatement, (String)"command", (boolean)true);
            List parametersList = (List)MethodUtils.invokeMethod((Object)command, (String)"getParameters");
            LinkedHashMap<String, PreparedStatementQueryParameter> parametersMap = new LinkedHashMap<String, PreparedStatementQueryParameter>();
            for (int i = 0; i < parametersList.size(); ++i) {
                Object paramValue = MethodUtils.invokeMethod(parametersList.get(i), (String)"getParamValue");
                Object paramType = MethodUtils.invokeMethod((Object)paramValue, (String)"getType");
                int paramIndex = i + 1;
                String paramKey = PreparedStatementQueryUtils.INSTANCE.generateParamKey(paramIndex);
                String paramTypeSQL = paramType.getClass().getName().equalsIgnoreCase("org.h2.value.TypeInfo") ? MethodUtils.invokeMethod((Object)paramType, (String)"getSQL", (Object[])new Object[]{new StringBuilder()}).toString() : String.valueOf(paramType);
                String paramValueSQL = (String)MethodUtils.invokeMethod((Object)paramValue, (String)"getSQL");
                PreparedStatementQueryParameter param = new PreparedStatementQueryParameter(paramTypeSQL, parameterMetaData.getParameterClassName(paramIndex), paramValueSQL);
                parametersMap.put(paramKey, param);
            }
            PreparedStatementQuery.Builder builder = PreparedStatementQuery.newBuilder();
            builder.withSqlStatement(PreparedStatementQueryUtils.INSTANCE.buildSql(sqlPreparedStatement, parametersMap));
            builder.withSqlMethod(sqlMethod);
            builder.withSqlPreparedStatement(parametersMap.isEmpty() ? null : sqlPreparedStatement);
            builder.withSqlParameterMap(parametersMap.isEmpty() ? null : parametersMap);
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

