package com.undefinedlabs.scope.rules.sql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PreparedStatementQueryParameter {

    private final String type;
    private final String dbType;
    private final String value;

    @JsonCreator
    public PreparedStatementQueryParameter(
            @JsonProperty("dbType") final String dbType,
            @JsonProperty("type") final String type,
            @JsonProperty("value") final String value) {
        this.dbType = dbType;
        this.type = type;
        this.value = value;
    }

    @JsonGetter("dbType")
    public String getDbType() {
        return dbType;
    }

    @JsonGetter("type")
    public String getType() {
        return type;
    }

    @JsonGetter("value")
    public String getValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        PreparedStatementQueryParameter that = (PreparedStatementQueryParameter) o;

        return new EqualsBuilder()
                .append(dbType, that.dbType)
                .append(type, that.type)
                .append(value, that.value)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(dbType)
                .append(type)
                .append(value)
                .toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("dbType", dbType)
                .append("type", type)
                .append("value", value)
                .toString();
    }
}
