/*
 * Decompiled with CFR 0.152.
 */
package com.undefinedlabs.scope.rules;

import com.undefinedlabs.scope.ScopeGlobalTracer;
import com.undefinedlabs.scope.events.EventFieldsFactory;
import com.undefinedlabs.scope.events.exception.ThrowableEvent;
import com.undefinedlabs.scope.rules.AbstractScopeAgentRule;
import com.undefinedlabs.scope.rules.sql.model.ConnectionInfo;
import com.undefinedlabs.scope.rules.sql.model.PreparedStatementQuery;
import com.undefinedlabs.scope.rules.sql.provider.ConnectionInfoProviderRegistry;
import com.undefinedlabs.scope.rules.sql.provider.PreparedStatementQueryProviderRegistry;
import com.undefinedlabs.scope.rules.sql.provider.internal.PreparedStatementQueryUtils;
import com.undefinedlabs.scope.rules.transformer.ScopeAgentAdvicedTransformer;
import com.undefinedlabs.scope.settings.ScopeSettingsResolver;
import com.undefinedlabs.scope.utils.SpanUtils;
import com.undefinedlabs.scope.utils.StacktraceUtils;
import com.undefinedlabs.scope.utils.sourcecode.ExceptionSourceCodeFactory;
import com.undefinedlabs.scope.utils.sourcecode.ExceptionSourceCodeFrame;
import com.undefinedlabs.scope.utils.tag.TagKeys;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class StatementScopeAgentRule
extends AbstractScopeAgentRule {
    protected Iterable<? extends AgentBuilder> transformers() {
        Class instrumentedClass = this.lookUp("java.sql.Statement");
        return instrumentedClass != null ? Collections.singleton(this.newAgentBuilder().type((ElementMatcher)ElementMatchers.isSubTypeOf((Class)instrumentedClass)).transform((AgentBuilder.Transformer)new ScopeAgentAdvicedTransformer(StatementExecuteNativeAdvice.class, (ElementMatcher)ElementMatchers.named((String)"executeQuery").and((ElementMatcher)ElementMatchers.takesArgument((int)0, String.class)))).type((ElementMatcher)ElementMatchers.isSubTypeOf((Class)instrumentedClass)).transform((AgentBuilder.Transformer)new ScopeAgentAdvicedTransformer(StatementExecuteNativeAdvice.class, (ElementMatcher)ElementMatchers.named((String)"executeUpdate").and((ElementMatcher)ElementMatchers.takesArgument((int)0, String.class)))).type((ElementMatcher)ElementMatchers.isSubTypeOf((Class)instrumentedClass)).transform((AgentBuilder.Transformer)new ScopeAgentAdvicedTransformer(PreparedStatementExecuteAdvice.class, (ElementMatcher)ElementMatchers.named((String)"execute").and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).type((ElementMatcher)ElementMatchers.isSubTypeOf((Class)instrumentedClass)).transform((AgentBuilder.Transformer)new ScopeAgentAdvicedTransformer(PreparedStatementExecuteAdvice.class, (ElementMatcher)ElementMatchers.named((String)"executeQuery").and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).type((ElementMatcher)ElementMatchers.isSubTypeOf((Class)instrumentedClass)).transform((AgentBuilder.Transformer)new ScopeAgentAdvicedTransformer(PreparedStatementExecuteAdvice.class, (ElementMatcher)ElementMatchers.named((String)"executeUpdate").and((ElementMatcher)ElementMatchers.takesArguments((int)0))))) : this.emptyCollection();
    }

    public static class PreparedStatementExecuteAdvice {
        @Advice.OnMethodEnter
        public static Span enter(@Advice.This Object thiz) {
            if (!(thiz instanceof PreparedStatement)) {
                return null;
            }
            Tracer tracer = ScopeGlobalTracer.get();
            Span previousSpan = tracer.activeSpan();
            if (previousSpan == null) {
                return null;
            }
            try {
                PreparedStatement preparedStatement = (PreparedStatement)thiz;
                Connection connection = preparedStatement.getConnection();
                ConnectionInfo connectionInfo = ConnectionInfoProviderRegistry.INSTANCE.getProvider(connection).extractInfo(connection);
                PreparedStatementQuery preparedStatementQuery = PreparedStatementQueryProviderRegistry.INSTANCE.getProvider(preparedStatement).create(preparedStatement);
                if (preparedStatementQuery.equals(PreparedStatementQuery.EMPTY)) {
                    return null;
                }
                Span span = tracer.buildSpan(connectionInfo.getProductName() + ":" + preparedStatementQuery.getSqlMethod()).withTag(TagKeys.COMPONENT, "java-sql").withTag(TagKeys.SPAN_KIND, "client").withTag("db.conn", connectionInfo.getUrl()).withTag(TagKeys.DB.DB_TYPE, "sql").withTag(TagKeys.DB.DB_USER, connectionInfo.getUserName()).withTag(TagKeys.DB.DB_INSTANCE, connection.getCatalog()).withTag("db.prepared_statement", preparedStatementQuery.getSqlPreparedStatement()).withTag("db.product", connectionInfo.getProductName()).withTag("db.product_version", connectionInfo.getProductVersion()).withTag("db.driver", connectionInfo.getDriverName()).withTag("db.driver_version", connectionInfo.getDriverVersion()).withTag(TagKeys.Network.PEER_SERVICE, connectionInfo.getPeerService()).start();
                if (((Boolean)ScopeSettingsResolver.INSTANCE.get().getSetting("SCOPE_INSTRUMENTATION_DB_STACKTRACE")).booleanValue()) {
                    SpanUtils.INSTANCE.setTagObject(span, "stacktrace", (Object)StacktraceUtils.INSTANCE.createStackTraceFields(Thread.currentThread().getStackTrace()));
                }
                if (((Boolean)ScopeSettingsResolver.INSTANCE.get().getSetting("SCOPE_INSTRUMENTATION_DB_STATEMENT_VALUES")).booleanValue()) {
                    span.setTag(TagKeys.DB.DB_STATEMENT, preparedStatementQuery.getSqlStatement());
                    SpanUtils.INSTANCE.setTagObject(span, "db.params", preparedStatementQuery.getSqlParameterMap());
                } else {
                    span.setTag("db.statement.unavailable", "disabled");
                }
                return span;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Advice.OnMethodExit(onThrowable=SQLException.class)
        public static void exit(@Advice.This Object thiz, @Advice.Enter Object spanObj, @Advice.Thrown Throwable throwable) {
            if (!(thiz instanceof PreparedStatement) || spanObj == null) {
                return;
            }
            Span span = (Span)spanObj;
            if (throwable != null) {
                span.setTag("error", true);
                ExceptionSourceCodeFrame exceptionSourceCodeFrame = ExceptionSourceCodeFactory.INSTANCE.createFrame(throwable);
                ThrowableEvent.Builder throwableEventBuilder = ThrowableEvent.newBuilder();
                throwableEventBuilder.withEventType("error").withThrowable(exceptionSourceCodeFrame.getUserThrowable()).withSource(exceptionSourceCodeFrame.getSourceCodeFrame().getLinkPathWithMethodLine());
                span.log(EventFieldsFactory.INSTANCE.createFields(throwableEventBuilder.build()));
            }
            span.finish();
        }
    }

    public static class StatementExecuteNativeAdvice {
        @Advice.OnMethodEnter
        public static Span enter(@Advice.This Object thiz, @Advice.AllArguments Object[] args) {
            if (!(thiz instanceof Statement) && args.length == 0) {
                return null;
            }
            Tracer tracer = ScopeGlobalTracer.get();
            Span previousSpan = tracer.activeSpan();
            if (previousSpan == null) {
                return null;
            }
            try {
                String sql = (String)args[0];
                Statement statement = (Statement)thiz;
                Connection connection = statement.getConnection();
                ConnectionInfo connectionInfo = ConnectionInfoProviderRegistry.INSTANCE.getProvider(connection).extractInfo(connection);
                Span span = tracer.buildSpan(connectionInfo.getProductName() + ":" + PreparedStatementQueryUtils.INSTANCE.extractSqlMethod(sql)).withTag(TagKeys.COMPONENT, "java-sql").withTag(TagKeys.SPAN_KIND, "client").withTag("db.conn", connectionInfo.getUrl()).withTag(TagKeys.DB.DB_TYPE, "sql").withTag(TagKeys.DB.DB_USER, connectionInfo.getUserName()).withTag(TagKeys.DB.DB_INSTANCE, connection.getCatalog()).withTag("db.product", connectionInfo.getProductName()).withTag("db.product_version", connectionInfo.getProductVersion()).withTag("db.driver", connectionInfo.getDriverName()).withTag("db.driver_version", connectionInfo.getDriverVersion()).withTag(TagKeys.Network.PEER_SERVICE, connectionInfo.getPeerService()).start();
                if (((Boolean)ScopeSettingsResolver.INSTANCE.get().getSetting("SCOPE_INSTRUMENTATION_DB_STACKTRACE")).booleanValue()) {
                    SpanUtils.INSTANCE.setTagObject(span, "stacktrace", (Object)StacktraceUtils.INSTANCE.createStackTraceFields(Thread.currentThread().getStackTrace()));
                }
                if (((Boolean)ScopeSettingsResolver.INSTANCE.get().getSetting("SCOPE_INSTRUMENTATION_DB_STATEMENT_VALUES")).booleanValue()) {
                    span.setTag(TagKeys.DB.DB_STATEMENT, sql);
                    SpanUtils.INSTANCE.setTagObject(span, "db.params", Collections.unmodifiableMap(new HashMap()));
                } else {
                    span.setTag("db.statement.unavailable", "disabled");
                }
                return span;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Advice.OnMethodExit(onThrowable=SQLException.class)
        public static void exit(@Advice.This Object thiz, @Advice.Enter Object spanObj, @Advice.Thrown Throwable throwable) {
            if (!(thiz instanceof Statement) || spanObj == null) {
                return;
            }
            Span span = (Span)spanObj;
            if (throwable != null) {
                span.setTag("error", true);
                ExceptionSourceCodeFrame exceptionSourceCodeFrame = ExceptionSourceCodeFactory.INSTANCE.createFrame(throwable);
                ThrowableEvent.Builder throwableEventBuilder = ThrowableEvent.newBuilder();
                throwableEventBuilder.withEventType("error").withThrowable(exceptionSourceCodeFrame.getUserThrowable()).withSource(exceptionSourceCodeFrame.getSourceCodeFrame().getLinkPathWithMethodLine());
                span.log(EventFieldsFactory.INSTANCE.createFields(throwableEventBuilder.build()));
            }
            span.finish();
        }
    }
}

