/*
 * Decompiled with CFR 0.152.
 */
package unquietcode.utils;

public class Conditionals {
    public static boolean any(Boolean ... booleans) {
        if (booleans == null) {
            return false;
        }
        for (Boolean bool : booleans) {
            if (bool == null || !bool.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean none(Boolean ... booleans) {
        return !Conditionals.any(booleans);
    }

    public static boolean all(Boolean ... booleans) {
        if (booleans == null) {
            return false;
        }
        for (Boolean bool : booleans) {
            if (bool != null && bool.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> boolean equalsAll(T value, T ... tests) {
        if (value == null) {
            for (T test : tests) {
                if (test == null) continue;
                return false;
            }
        } else {
            for (T test : tests) {
                if (value.equals(test)) continue;
                return false;
            }
        }
        return true;
    }

    @SafeVarargs
    public static <T> boolean equalsAny(T value, T ... tests) {
        if (value == null) {
            for (T test : tests) {
                if (test != null) continue;
                return true;
            }
        } else {
            for (T test : tests) {
                if (!value.equals(test)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean equalsNone(T value, T ... tests) {
        return !Conditionals.equalsAny(value, tests);
    }

    public static boolean isInstanceOf(Object obj, Class<?> clazz) {
        return obj != null && clazz.isAssignableFrom(obj.getClass());
    }

    public static <T> boolean notEquals(T o1, T o2) {
        return !Conditionals.equals(o1, o2);
    }

    public static <T> boolean equals(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null ^ o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean not(Boolean test) {
        return test == null || test == false;
    }
}

