/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.query;

import com.ursful.framework.orm.support.Column;
import com.ursful.framework.orm.support.Condition;
import com.ursful.framework.orm.support.ConditionObject;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.MultiOrder;
import com.ursful.framework.orm.support.Order;
import com.ursful.framework.orm.utils.ORMUtils;
import java.util.List;
import java.util.Locale;

public class QueryUtils {
    public static void setMultiOrderAlias(MultiOrder multiOrder, String alias) {
        if (multiOrder != null && !ORMUtils.isEmpty(alias)) {
            QueryUtils.setOrdersAlias(multiOrder.getOrders(), alias);
        }
    }

    public static void setOrdersAlias(List<Order> orders, String alias) {
        if (orders != null && !ORMUtils.isEmpty(alias)) {
            for (Order order : orders) {
                QueryUtils.setColumnAlias(order.getColumn(), alias);
            }
        }
    }

    public static void setConditionsAlias(List<Condition> conditions, String alias) {
        if (conditions != null && !ORMUtils.isEmpty(alias)) {
            for (Condition condition : conditions) {
                QueryUtils.setConditionAlias(condition, alias);
            }
        }
    }

    public static void setConditionAlias(Condition condition, String alias) {
        if (condition != null && !ORMUtils.isEmpty(alias)) {
            List<ConditionObject> exts = condition.getConditions();
            for (ConditionObject ext : exts) {
                if (ext == null) continue;
                Object extObject = ext.getObject();
                switch (ext.getType()) {
                    case AND: 
                    case OR: {
                        if (extObject instanceof Expression) {
                            QueryUtils.setExpressionAlias((Expression)extObject, alias);
                            break;
                        }
                        if (!(extObject instanceof Condition)) break;
                        QueryUtils.setConditionAlias((Condition)extObject, alias);
                        break;
                    }
                    case AND_OR: 
                    case OR_OR: 
                    case OR_AND: {
                        Expression[] list = (Expression[])extObject;
                        QueryUtils.setExpressionsAlias(list, alias);
                    }
                }
            }
        }
    }

    public static void setExpressionsAlias(Expression[] expressions, String alias) {
        if (expressions != null && !ORMUtils.isEmpty(alias)) {
            for (Expression expression : expressions) {
                QueryUtils.setExpressionAlias(expression, alias);
            }
        }
    }

    public static void setExpressionAlias(Expression expression, String alias) {
        if (expression != null && !ORMUtils.isEmpty(alias)) {
            QueryUtils.setColumnAlias(expression.getLeft(), alias);
            if (expression.getValue() instanceof Column) {
                QueryUtils.setColumnAlias((Column)expression.getValue(), alias);
            }
        }
    }

    public static void setColumnsAlias(List<Column> columns, String alias) {
        if (columns != null && !ORMUtils.isEmpty(alias)) {
            for (Column column : columns) {
                QueryUtils.setColumnAlias(column, alias);
            }
        }
    }

    public static void setColumnAlias(Column column, String alias) {
        if (column != null && !ORMUtils.isEmpty(alias)) {
            if (ORMUtils.isEmpty(column.getAlias())) {
                column.setAlias(alias);
            }
            if (column.getValue() instanceof Column) {
                QueryUtils.setColumnAlias((Column)column.getValue(), alias);
            }
        }
    }

    public static boolean isUpperOrLowerCase(String columnName) {
        if (ORMUtils.isEmpty(columnName)) {
            return false;
        }
        boolean isUpper = false;
        boolean isLower = false;
        for (int i = 0; i < columnName.length(); ++i) {
            char c = columnName.charAt(i);
            if (!isUpper && Character.isUpperCase(c)) {
                isUpper = true;
            }
            if (!isLower && Character.isLowerCase(c)) {
                isLower = true;
            }
            if (isUpper && isLower) break;
        }
        return isUpper && isLower;
    }

    public static String displayNameOrAsName(String displayName, String columnName) {
        if (displayName.toUpperCase(Locale.ROOT).equals(columnName.toUpperCase(Locale.ROOT))) {
            String[] names = columnName.split("_");
            if (names.length == 1 && QueryUtils.isUpperOrLowerCase(columnName)) {
                return columnName;
            }
            StringBuffer sb = new StringBuffer(names[0].toLowerCase(Locale.ROOT));
            for (int i = 1; i < names.length; ++i) {
                String n = names[i];
                sb.append(n.substring(0, 1).toUpperCase(Locale.ROOT));
                sb.append(n.substring(1).toLowerCase(Locale.ROOT));
            }
            return sb.toString();
        }
        if (displayName.contains("_")) {
            String[] names = displayName.split("_");
            StringBuffer sb = new StringBuffer(names[0].toLowerCase(Locale.ROOT));
            for (int i = 1; i < names.length; ++i) {
                String n = names[i];
                sb.append(n.substring(0, 1).toUpperCase(Locale.ROOT));
                sb.append(n.substring(1).toLowerCase(Locale.ROOT));
            }
            return sb.toString();
        }
        return displayName;
    }

    public static String displayName(String columnName) {
        String[] names = columnName.split("_");
        if (names.length == 1 && QueryUtils.isUpperOrLowerCase(columnName)) {
            return columnName;
        }
        StringBuffer sb = new StringBuffer(names[0].toLowerCase(Locale.ROOT));
        for (int i = 1; i < names.length; ++i) {
            String n = names[i];
            sb.append(n.substring(0, 1).toUpperCase(Locale.ROOT));
            sb.append(n.substring(1).toLowerCase(Locale.ROOT));
        }
        return sb.toString();
    }
}

