/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.query;

import com.ursful.framework.orm.IBaseQuery;
import com.ursful.framework.orm.annotation.RdTable;
import com.ursful.framework.orm.support.Column;
import com.ursful.framework.orm.support.Condition;
import com.ursful.framework.orm.support.Express;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.ExpressionType;
import com.ursful.framework.orm.support.Options;
import com.ursful.framework.orm.support.Order;
import com.ursful.framework.orm.support.Pageable;
import com.ursful.framework.orm.support.QueryInfo;
import com.ursful.framework.orm.support.Terms;
import com.ursful.framework.orm.utils.ORMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;

public class BaseQueryImpl
implements IBaseQuery {
    private String id;
    private Class<?> table;
    private Class<?> returnClass;
    private List<Column> returnColumns = new ArrayList<Column>();
    private List<Condition> conditions = new ArrayList<Condition>();
    private List<Condition> havings = new ArrayList<Condition>();
    private List<Column> groups = new ArrayList<Column>();
    private List<Column> groupCountsSelectColumns = new ArrayList<Column>();
    private List<Order> orders = new ArrayList<Order>();
    private boolean distinct = false;
    private Pageable pageable;
    private Options options;

    @Override
    public IBaseQuery orderDesc(String name) {
        this.orders.add(new Order(new Column(name), "DESC"));
        return this;
    }

    @Override
    public IBaseQuery whereIsNull(String name) {
        this.conditions.add(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_NULL)));
        return this;
    }

    @Override
    public IBaseQuery whereIsNotNull(String name) {
        this.conditions.add(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_NOT_NULL)));
        return this;
    }

    @Override
    public IBaseQuery whereIsEmpty(String name) {
        this.conditions.add(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_EMPTY)));
        return this;
    }

    @Override
    public IBaseQuery whereIsNotEmpty(String name) {
        this.conditions.add(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_NOT_EMPTY)));
        return this;
    }

    @Override
    public IBaseQuery where(String name, ExpressionType type) {
        if (ExpressionType.CDT_IS_NULL == type || ExpressionType.CDT_IS_NOT_NULL == type || ExpressionType.CDT_IS_EMPTY == type || ExpressionType.CDT_IS_NOT_EMPTY == type) {
            this.conditions.add(new Condition().and(new Expression(new Column(name), type)));
        }
        return this;
    }

    @Override
    public IBaseQuery whereEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_EQUAL);
    }

    @Override
    public IBaseQuery whereNotEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_NOT_EQUAL);
    }

    @Override
    public IBaseQuery whereLike(String name, String value) {
        return this.where(name, value, ExpressionType.CDT_LIKE);
    }

    @Override
    public IBaseQuery whereNotLike(String name, String value) {
        return this.where(name, value, ExpressionType.CDT_NOT_LIKE);
    }

    @Override
    public IBaseQuery whereStartWith(String name, String value) {
        return this.where(name, value, ExpressionType.CDT_START_WITH);
    }

    @Override
    public IBaseQuery whereEndWith(String name, String value) {
        return this.where(name, value, ExpressionType.CDT_END_WITH);
    }

    @Override
    public IBaseQuery whereNotStartWith(String name, String value) {
        return this.where(name, value, ExpressionType.CDT_NOT_START_WITH);
    }

    @Override
    public IBaseQuery whereNotEndWith(String name, String value) {
        return this.where(name, value, ExpressionType.CDT_NOT_END_WITH);
    }

    @Override
    public IBaseQuery whereLess(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_LESS);
    }

    @Override
    public IBaseQuery whereLessEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_LESS_EQUAL);
    }

    @Override
    public IBaseQuery whereMore(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_MORE);
    }

    @Override
    public IBaseQuery whereMoreEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_MORE_EQUAL);
    }

    @Override
    public IBaseQuery whereIn(String name, Collection value) {
        return this.where(name, value, ExpressionType.CDT_IN);
    }

    @Override
    public IBaseQuery whereNotIn(String name, Collection value) {
        return this.where(name, value, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public IBaseQuery whereInValues(String name, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(name, temp, ExpressionType.CDT_IN);
    }

    @Override
    public IBaseQuery whereNotInValues(String name, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(name, temp, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public IBaseQuery where(String name, Object value, ExpressionType type) {
        this.conditions.add(new Condition().and(new Expression(new Column(name), value, type)));
        return this;
    }

    @Override
    public IBaseQuery where(Terms terms) {
        if (terms != null) {
            this.conditions.add(terms.getCondition());
        }
        return this;
    }

    @Override
    public IBaseQuery where(Express ... expresses) {
        if (expresses != null) {
            for (Express express : expresses) {
                if (express == null) continue;
                this.conditions.add(new Condition().and(express.getExpression()));
            }
        }
        return this;
    }

    @Override
    public IBaseQuery whereBetween(String name, Object value, Object andValue) {
        if (!ORMUtils.isEmpty(value) && !ORMUtils.isEmpty(andValue)) {
            Expression expression = new Expression(new Column(name), value, ExpressionType.CDT_BETWEEN);
            expression.setAndValue(andValue);
            this.conditions.add(new Condition().and(expression));
        }
        return this;
    }

    @Override
    public IBaseQuery where(Expression ... expressions) {
        this.conditions.add(new Condition().and(expressions));
        return this;
    }

    @Override
    public IBaseQuery group(String name) {
        this.groups.add(new Column(name));
        return this;
    }

    @Override
    public List<Column> getGroupCountSelectColumns() {
        return this.groupCountsSelectColumns;
    }

    @Override
    public IBaseQuery groupCountSelectColumn(String name) {
        this.groupCountsSelectColumns.add(new Column(name));
        return this;
    }

    @Override
    public IBaseQuery having(String name, Object value, ExpressionType type) {
        if (value == null) {
            return this;
        }
        if ("".equals(value)) {
            return this;
        }
        this.havings.add(new Condition().or(new Expression(new Column(name), value, type)));
        return this;
    }

    @Override
    public IBaseQuery having(Terms terms) {
        this.conditions.add(terms.getCondition());
        return this;
    }

    @Override
    public IBaseQuery orderAsc(String name) {
        this.orders.add(new Order(new Column(name), "ASC"));
        return this;
    }

    @Override
    public IBaseQuery orders(List<Order> os) {
        if (os != null) {
            for (Order order : os) {
                this.orders.add(order);
            }
        }
        return this;
    }

    @Override
    public IBaseQuery createQuery(Class<?> clazz, String ... names) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        if (names != null) {
            for (String name : names) {
                this.returnColumns.add(new Column(name));
            }
        }
        return this;
    }

    @Override
    public IBaseQuery createQuery(Class<?> clazz, Column ... columns) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public IBaseQuery addReturnColumn(Column column) {
        if (column != null) {
            this.returnColumns.add(column);
        }
        return this;
    }

    @Override
    public IBaseQuery addReturnColumn(String column) {
        if (ORMUtils.isEmpty(column)) {
            this.returnColumns.add(new Column(column));
        }
        return this;
    }

    @Override
    public IBaseQuery clearReturnColumns() {
        this.returnColumns.clear();
        return this;
    }

    @Override
    public IBaseQuery createQuery(String ... names) {
        this.returnClass = this.table;
        this.returnColumns.clear();
        if (names != null) {
            for (String name : names) {
                this.returnColumns.add(new Column(name));
            }
        }
        return this;
    }

    public IBaseQuery createQuery(Column ... columns) {
        this.returnClass = this.table;
        this.returnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public IBaseQuery distinct() {
        this.distinct = true;
        return this;
    }

    @Override
    public IBaseQuery table(Class<?> clazz) {
        RdTable rdTable;
        if (clazz != null && (rdTable = (RdTable)AnnotationUtils.findAnnotation(clazz, RdTable.class)) != null) {
            this.table = clazz;
            this.returnClass = clazz;
        }
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Class<?> getTable() {
        return this.table;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<Condition> getHavings() {
        return this.havings;
    }

    @Override
    public List<Column> getGroups() {
        return this.groups;
    }

    @Override
    public List<Order> getOrders() {
        return this.orders;
    }

    @Override
    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public List<Column> getReturnColumns() {
        if (this.returnColumns.isEmpty()) {
            this.returnColumns.add(new Column("*"));
        }
        return this.returnColumns;
    }

    @Override
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    @Override
    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public QueryInfo doQuery() {
        return this.options.doQuery(this, this.getPageable());
    }

    @Override
    public QueryInfo doQueryCount() {
        return this.options.doQueryCount(this);
    }
}

