/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.option;

import com.ursful.framework.orm.IMultiQuery;
import com.ursful.framework.orm.IQuery;
import com.ursful.framework.orm.annotation.RdColumn;
import com.ursful.framework.orm.annotation.RdForeignKey;
import com.ursful.framework.orm.annotation.RdId;
import com.ursful.framework.orm.annotation.RdTable;
import com.ursful.framework.orm.annotation.RdUniqueKey;
import com.ursful.framework.orm.exception.ORMException;
import com.ursful.framework.orm.helper.SQLHelper;
import com.ursful.framework.orm.option.AbstractOptions;
import com.ursful.framework.orm.support.ColumnInfo;
import com.ursful.framework.orm.support.ColumnType;
import com.ursful.framework.orm.support.MultiOrder;
import com.ursful.framework.orm.support.OperatorType;
import com.ursful.framework.orm.support.Pageable;
import com.ursful.framework.orm.support.Pair;
import com.ursful.framework.orm.support.QueryInfo;
import com.ursful.framework.orm.support.Table;
import com.ursful.framework.orm.support.TableColumn;
import com.ursful.framework.orm.support.Terms;
import com.ursful.framework.orm.support.TextTransformType;
import com.ursful.framework.orm.utils.ORMUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class MySQLOptions
extends AbstractOptions {
    private AtomicInteger count = new AtomicInteger(0);

    @Override
    public boolean preSetParameter(PreparedStatement ps, Connection connection, String databaseType, int i, Pair pair) throws SQLException {
        return false;
    }

    @Override
    public String keyword() {
        return "mysql";
    }

    @Override
    public String getColumnWithOperator(OperatorType operatorType, String name, String value) {
        String result = null;
        switch (operatorType) {
            case NOT: {
                result = "(" + operatorType.getOperator() + name + ")";
            }
        }
        return result;
    }

    @Override
    public String getColumnWithOperatorAndFunction(String function, boolean inFunction, OperatorType operatorType, String name, String value) {
        String result = null;
        switch (operatorType) {
            case NOT: {
                result = inFunction ? function + "(" + operatorType.getOperator() + name + ")" : "(" + operatorType.getOperator() + function + "(" + name + "))";
            }
        }
        if (result == null) {
            result = inFunction ? function + "(" + name + operatorType.getOperator() + value + ")" : "(" + function + "(" + name + ")" + operatorType.getOperator() + value + ")";
        }
        return result;
    }

    @Override
    public String databaseType() {
        return "MySQL";
    }

    @Override
    public String nanoTimeSQL() {
        return "SELECT NOW(3)";
    }

    @Override
    public QueryInfo doQuery(IQuery query, Pageable page) {
        QueryInfo info = new QueryInfo();
        ArrayList<Pair> values = new ArrayList<Pair>();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        HashMap<String, String> asNames = new HashMap<String, String>();
        sb.append(this.selectColumns(query, null, asNames));
        sb.append(" FROM ");
        sb.append(this.tables(query, values, null));
        if (query instanceof IMultiQuery) {
            sb.append(this.joins((IMultiQuery)query, values));
        }
        sb.append(this.wheres(query, values, null));
        sb.append(this.groups(query, null));
        sb.append(this.havings(query, values, null));
        sb.append(this.orders(query, null, asNames));
        if (page != null) {
            sb.append(" LIMIT ? OFFSET ? ");
            values.add(new Pair(new Integer(page.getSize())));
            values.add(new Pair(new Integer(page.getOffset())));
        }
        info.setClazz(query.getReturnClass());
        info.setSql(sb.toString());
        info.setValues(values);
        info.setColumns(query.getReturnColumns());
        if (TextTransformType.LOWER == query.textTransformType()) {
            info.setSql(info.getSql().toLowerCase(Locale.ROOT));
        } else if (TextTransformType.UPPER == query.textTransformType()) {
            info.setSql(info.getSql().toUpperCase(Locale.ROOT));
        }
        return info;
    }

    @Override
    public SQLHelper doQuery(Class<?> clazz, String[] names, Terms terms, MultiOrder multiOrder, Integer start, Integer size) {
        String orders;
        String conditions;
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("SELECT ");
        String nameStr = ORMUtils.join(names, ",");
        if (ORMUtils.isEmpty(nameStr)) {
            sql.append("*");
        } else {
            sql.append(nameStr);
        }
        sql.append(" FROM " + tableName);
        ArrayList<Pair> values = new ArrayList<Pair>();
        if (terms != null && !ORMUtils.isEmpty(conditions = this.getConditions(clazz, ORMUtils.newList(terms.getCondition()), values))) {
            sql.append(" WHERE " + conditions);
        }
        if (multiOrder != null && !ORMUtils.isEmpty(orders = this.getOrders(multiOrder.getOrders(), clazz))) {
            sql.append(" ORDER BY " + orders);
        }
        if (size != null && size > 0) {
            if (start == null) {
                start = 0;
            }
            sql.append(" LIMIT ? OFFSET ? ");
            values.add(new Pair(size));
            values.add(new Pair(start));
        }
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(values);
        return helper;
    }

    private List<String> tableConstraints(Connection connection) {
        Statement ps = null;
        ResultSet rs = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            String dbName = connection.getCatalog();
            String sql = "SELECT CONSTRAINT_NAME AS INDEX_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_SCHEMA = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, dbName);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null) continue;
                names.add(indexName.toUpperCase(Locale.ROOT));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return names;
    }

    @Override
    public boolean tableExists(Connection connection, String tableName) {
        Statement ps = null;
        ResultSet rs = null;
        try {
            String dbName = connection.getCatalog();
            String sql = "SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = ? AND TABLE_SCHEMA = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            ps.setString(2, dbName);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public String getCaseSensitive(String name, int sensitive) {
        if (name == null) {
            return name;
        }
        if (2 == sensitive) {
            return name.toLowerCase(Locale.ROOT);
        }
        if (1 == sensitive) {
            return name.toUpperCase(Locale.ROOT);
        }
        if (3 == sensitive) {
            return name;
        }
        return name;
    }

    @Override
    public List<Table> tables(Connection connection, String keyword) {
        ArrayList<Table> temp = new ArrayList<Table>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            String dbName = connection.getCatalog();
            String sql = "SELECT TABLE_NAME,TABLE_COMMENT FROM information_schema.TABLES WHERE TABLE_SCHEMA = ? ";
            if (!ORMUtils.isEmpty(keyword)) {
                sql = sql + "AND TABLE_NAME LIKE ? ";
            }
            ps = connection.prepareStatement(sql);
            ps.setString(1, dbName);
            if (!ORMUtils.isEmpty(keyword)) {
                ps.setString(2, "%" + keyword + "%");
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                temp.add(new Table(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return temp;
    }

    @Override
    public Table table(Connection connection, RdTable rdTable) throws ORMException {
        String tableName = this.getTableName(rdTable);
        return this.table(connection, tableName);
    }

    @Override
    public Table table(Connection connection, String tableName) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int type = -1;
            ps = connection.prepareStatement("show variables like 'lower_case_table_names'");
            rs = ps.executeQuery();
            if (rs.next()) {
                type = rs.getInt(2);
            }
            rs.close();
            ps.close();
            String dbName = connection.getCatalog();
            String sql = "SELECT TABLE_NAME,TABLE_COMMENT FROM information_schema.TABLES WHERE TABLE_NAME LIKE ? AND TABLE_SCHEMA = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            ps.setString(2, dbName);
            rs = ps.executeQuery();
            if (rs.next()) {
                String newTableName = rs.getString(1);
                if (type == 1) {
                    newTableName = tableName;
                }
                Table table = new Table(newTableName, rs.getString(2));
                return table;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    @Override
    public List<TableColumn> columns(Connection connection, RdTable rdTable) throws ORMException {
        String tableName = this.getTableName(rdTable);
        return this.columns(connection, tableName);
    }

    @Override
    public List<TableColumn> columns(Connection connection, String tableName) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            String dbName = connection.getCatalog();
            String sql = "SELECT * FROM information_schema.COLUMNS WHERE TABLE_NAME LIKE ? AND   TABLE_SCHEMA = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            ps.setString(2, dbName);
            rs = ps.executeQuery();
            while (rs.next()) {
                String cname = rs.getString("COLUMN_NAME");
                TableColumn column = new TableColumn(tableName, cname);
                column.setType(rs.getString("DATA_TYPE").toUpperCase(Locale.ROOT));
                column.setLength(rs.getInt("CHARACTER_MAXIMUM_LENGTH"));
                column.setNullable("YES".equalsIgnoreCase(rs.getString("IS_NULLABLE")));
                column.setPrecision(rs.getInt("NUMERIC_PRECISION"));
                column.setDefaultValue(rs.getString("COLUMN_DEFAULT"));
                column.setScale(rs.getInt("NUMERIC_SCALE"));
                column.setOrder(rs.getInt("ORDINAL_POSITION"));
                column.setComment(rs.getString("COLUMN_COMMENT"));
                column.setIsPrimaryKey("PRI".equalsIgnoreCase(rs.getString("COLUMN_KEY")));
                columns.add(column);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return columns;
    }

    @Override
    public List<String> createOrUpdateSqls(Connection connection, RdTable table, List<ColumnInfo> infos, boolean tableExisted, List<TableColumn> tableColumns) {
        String tableName = this.getCaseSensitive(table.name(), table.sensitive());
        List<String> constraints = this.tableConstraints(connection);
        ArrayList<String> sqls = new ArrayList<String>();
        if (table.dropped()) {
            if (tableExisted) {
                if (table.sensitive() == 0) {
                    sqls.add(String.format("DROP TABLE %s", tableName));
                } else {
                    sqls.add(String.format("DROP TABLE `%s`", tableName));
                }
            }
        } else if (tableExisted) {
            HashMap<String, TableColumn> columnMap = new HashMap<String, TableColumn>();
            int sensitive = -1;
            for (TableColumn column : tableColumns) {
                columnMap.put(column.getColumn(), column);
                if (sensitive != -1) continue;
            }
            for (ColumnInfo info : infos) {
                String foreignSQL;
                String uniqueSQL;
                String columnName = this.getCaseSensitive(info.getColumnName(), table.sensitive());
                TableColumn tableColumn = null;
                tableColumn = sensitive == 1 ? (TableColumn)columnMap.get(columnName.toLowerCase(Locale.ROOT)) : (TableColumn)columnMap.get(columnName);
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                if (tableColumn != null) {
                    if (rdColumn.dropped()) {
                        if (table.sensitive() == 0) {
                            sqls.add(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName));
                        } else {
                            sqls.add(String.format("ALTER TABLE `%s` DROP COLUMN `%s`", tableName, columnName));
                        }
                    } else {
                        boolean needUpdate = false;
                        if ("VARCHAR".equalsIgnoreCase(tableColumn.getType()) || "CHAR".equalsIgnoreCase(tableColumn.getType())) {
                            if (tableColumn.getLength() == null) continue;
                            if (tableColumn.getLength().intValue() != rdColumn.length()) {
                                needUpdate = true;
                            }
                        } else if ("DECIMAL".equalsIgnoreCase(tableColumn.getType())) {
                            if (tableColumn.getPrecision() == null || tableColumn.getScale() == null) continue;
                            if ("Date".equalsIgnoreCase(info.getType())) {
                                if (tableColumn.getPrecision().intValue() != rdColumn.datePrecision() || tableColumn.getScale() != 0) {
                                    needUpdate = true;
                                }
                            } else if (tableColumn.getPrecision().intValue() != rdColumn.precision() || tableColumn.getScale().intValue() != rdColumn.scale()) {
                                needUpdate = true;
                            }
                        } else {
                            String type = this.getColumnType(info, rdColumn).toUpperCase(Locale.ROOT);
                            if (!type.startsWith(tableColumn.getType().toUpperCase(Locale.ROOT))) {
                                needUpdate = true;
                            }
                        }
                        if (!(needUpdate || ORMUtils.isEmpty(tableColumn.getDefaultValue()) || tableColumn.getDefaultValue().equals(rdColumn.defaultValue()))) {
                            needUpdate = true;
                        }
                        RdId rdId = info.getField().getAnnotation(RdId.class);
                        if (!needUpdate && tableColumn.isNullable() != rdColumn.nullable() && !tableColumn.isPrimaryKey() && rdId == null) {
                            needUpdate = true;
                        }
                        if (needUpdate) {
                            String temp = this.columnString(info, table.sensitive(), rdColumn, false);
                            String comment = this.columnComment(rdColumn);
                            if (!ORMUtils.isEmpty(comment)) {
                                temp = temp + " COMMENT '" + comment + "'";
                            }
                            if (table.sensitive() == 0) {
                                sqls.add(String.format("ALTER TABLE %s MODIFY COLUMN %s", tableName, temp));
                            } else {
                                sqls.add(String.format("ALTER TABLE `%s` MODIFY COLUMN %s", tableName, temp));
                            }
                        }
                    }
                } else if (!rdColumn.dropped()) {
                    String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                    String comment = this.columnComment(rdColumn);
                    if (!ORMUtils.isEmpty(comment)) {
                        temp = temp + " COMMENT'" + comment + "'";
                    }
                    if (table.sensitive() == 0) {
                        sqls.add(String.format("ALTER TABLE %s ADD COLUMN %s", tableName, temp));
                    } else {
                        sqls.add(String.format("ALTER TABLE `%s` ADD COLUMN %s", tableName, temp));
                    }
                }
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    sqls.add("ALTER TABLE `" + tableName + "` ADD " + uniqueSQL);
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                sqls.add("ALTER TABLE `" + tableName + "` ADD " + foreignSQL);
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE " + tableName + "(");
            ArrayList<String> columnSQL = new ArrayList<String>();
            for (int i = 0; i < infos.size(); ++i) {
                String foreignSQL;
                String uniqueSQL;
                ColumnInfo info = infos.get(i);
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                String comment = this.columnComment(rdColumn);
                if (!ORMUtils.isEmpty(comment)) {
                    temp = temp + " COMMENT '" + comment + "'";
                }
                columnSQL.add(temp.toString());
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    columnSQL.add(uniqueSQL);
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                columnSQL.add(foreignSQL);
            }
            sql.append(ORMUtils.join(columnSQL, ","));
            sql.append(")");
            String comment = table.comment();
            if (ORMUtils.isEmpty(comment)) {
                comment = table.title();
            }
            if (!ORMUtils.isEmpty(comment)) {
                sql.append(" COMMENT='" + comment + "' ");
            }
            if (!ORMUtils.isEmpty(table.collate())) {
                sql.append(" COLLATE='" + table.collate() + "'");
            }
            if (!ORMUtils.isEmpty(table.engine())) {
                sql.append(" ENGINE='" + table.engine() + "'");
            }
            sql.append(";");
            sqls.add(sql.toString());
        }
        return sqls;
    }

    protected String columnString(ColumnInfo info, int sensitive, RdColumn rdColumn, boolean addKey) {
        RdId rdId;
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(info.getColumnName(), sensitive);
        if (sensitive == 0) {
            temp.append(cname);
        } else {
            temp.append(String.format("`%s`", cname));
        }
        String type = " " + this.getColumnType(info, rdColumn);
        if (!ORMUtils.isEmpty(rdColumn.defaultValue())) {
            type = type + " DEFAULT '" + rdColumn.defaultValue() + "'";
        }
        if (!rdColumn.nullable()) {
            type = type + " NOT NULL";
        }
        temp.append(type);
        if (info.getPrimaryKey().booleanValue() && addKey) {
            temp.append(" PRIMARY KEY");
        }
        if ((rdId = info.getField().getAnnotation(RdId.class)) != null && rdId.autoIncrement()) {
            temp.append(" AUTO_INCREMENT");
        }
        return temp.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getColumnType(ColumnInfo info, RdColumn rdColumn) {
        String type = "";
        String infoType = info.getField().getType().getName();
        if (String.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.TEXT) {
                return "TEXT";
            }
            if (info.getColumnType() == ColumnType.BLOB) {
                return "BLOB";
            }
            if (info.getColumnType() == ColumnType.CLOB) {
                return "TEXT";
            }
            if (info.getColumnType() == ColumnType.BINARY) {
                return "VARBINARY(" + rdColumn.length() + ")";
            }
            if (info.getColumnType() != ColumnType.CHAR) return "VARCHAR(" + rdColumn.length() + ")";
            return "CHAR(" + rdColumn.length() + ")";
        }
        if (Integer.class.getName().equals(infoType)) {
            return "INT(" + rdColumn.precision() + ")";
        }
        if (Date.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.LONG) {
                return "DECIMAL(" + rdColumn.datePrecision() + ", 0)";
            }
            if (info.getColumnType() == ColumnType.TIMESTAMP) {
                return "TIMESTAMP";
            }
            if (info.getColumnType() != ColumnType.DATETIME) throw new RuntimeException("Not support type : " + infoType + "," + info.getColumnType().name());
            return "DATETIME";
        }
        if (Long.class.getName().equals(infoType)) {
            return "BIGINT(" + rdColumn.precision() + ")";
        }
        if (Double.class.getName().equals(infoType)) {
            return "DOUBLE";
        }
        if (Float.class.getName().equals(infoType)) {
            if (info.getColumnType() != ColumnType.REAL) return "FLOAT";
            return "REAL";
        }
        if (BigDecimal.class.getName().equals(infoType)) {
            return "DECIMAL(" + rdColumn.precision() + "," + rdColumn.scale() + ")";
        }
        if (!byte[].class.getName().equals(infoType)) throw new RuntimeException("Not support type : " + infoType + "," + info.getColumnType().name());
        return "VARBINARY(" + rdColumn.length() + ")";
    }
}

