/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.support;

import com.ursful.framework.orm.support.OperatorType;
import java.io.Serializable;
import java.util.Locale;

public class Column
implements Serializable {
    private String name;
    private String function;
    private String alias;
    private String asName;
    private Object value;
    private OperatorType type;
    private String format;
    private Boolean operatorInFunction = true;

    public Boolean getOperatorInFunction() {
        return this.operatorInFunction;
    }

    public void setOperatorInFunction(Boolean operatorInFunction) {
        this.operatorInFunction = operatorInFunction;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public OperatorType getType() {
        return this.type;
    }

    public void setType(OperatorType type) {
        this.type = type;
    }

    public String getAsName() {
        return this.asName;
    }

    public void setAsName(String asName) {
        if (asName != null) {
            this.asName = this.getReplace(asName.toUpperCase(Locale.ROOT));
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        if (function != null) {
            this.function = this.getReplace(function);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getReplace(String value) {
        if (value != null) {
            value = value.replace(" ", "");
        }
        return value;
    }

    public void setName(String name) {
        this.name = this.getReplace(name);
    }

    public Column() {
    }

    public Column(String name) {
        this.setName(name);
    }

    public Column(String alias, String name) {
        this.setName(name);
        this.alias = alias;
    }

    public Column(String alias, String name, String asName) {
        this.alias = alias;
        this.setName(name);
        this.setAsName(asName);
    }

    public Column(String function, String alias, String name, String asName) {
        this.alias = alias;
        this.setFunction(function);
        this.setName(name);
        this.setAsName(asName);
    }

    public Column function(String function) {
        this.setFunction(function);
        return this;
    }

    public Column alias(String alias) {
        this.alias = alias;
        return this;
    }

    public Column name(String name) {
        this.setName(name);
        return this;
    }

    public Column as(String asName) {
        this.setAsName(asName);
        return this;
    }

    public Column value(Object value) {
        this.value = value;
        return this;
    }

    public Column operator(OperatorType type) {
        this.type = type;
        return this;
    }

    public Column format(String format) {
        this.format = format;
        return this;
    }

    public Column formatValues(Object ... values) {
        this.value = values;
        return this;
    }

    public Column field(String field) {
        if (field == null || field.length() == 0) {
            return this;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < field.length(); ++i) {
            char c = field.charAt(i);
            if ('A' <= c && c <= 'Z') {
                sb.append("_");
                sb.append((c + "").toLowerCase(Locale.ROOT));
                continue;
            }
            sb.append(c);
        }
        this.name = sb.toString();
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Column operatorInFunction(Boolean operatorInFunction) {
        this.operatorInFunction = operatorInFunction;
        return this;
    }

    public static void main(String[] args) {
    }
}

