/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.support;

import com.ursful.framework.orm.support.Column;
import com.ursful.framework.orm.utils.ORMUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Columns
implements Serializable {
    private List<Column> columns = new ArrayList<Column>();
    private String alias;
    private String[] names;
    private String[] asNames;

    public Columns() {
    }

    public Columns(String alias) {
        this.alias = alias;
    }

    public Columns(String alias, String ... names) {
        this.alias = alias;
        this.names = names;
    }

    public Columns names(String ... names) {
        this.names = names;
        return this;
    }

    public Columns asNames(String ... asNames) {
        this.asNames = asNames;
        return this;
    }

    public Columns c(Column column) {
        if (column != null) {
            if (ORMUtils.isEmpty(column.getAlias()) && !ORMUtils.isEmpty(this.alias)) {
                column.setAlias(this.alias);
            }
            this.columns.add(column);
        }
        return this;
    }

    public List<Column> getColumnList() {
        ArrayList<Column> columnList = new ArrayList<Column>();
        if (this.names != null && this.alias != null) {
            if (this.asNames == null) {
                for (String name : this.names) {
                    columnList.add(new Column(this.alias, name));
                }
            } else if (this.names.length == this.asNames.length) {
                for (int i = 0; i < this.names.length; ++i) {
                    columnList.add(new Column(this.alias, this.names[i], this.asNames[i]));
                }
            } else {
                throw new RuntimeException("TABLE_QUERY_NAMES_AS_NOT_EQUAL, names length: " + this.names.length + ", asNames length : " + this.asNames.length);
            }
        }
        columnList.addAll(this.columns);
        return columnList;
    }
}

