/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.support;

import com.ursful.framework.orm.IMultiQuery;
import com.ursful.framework.orm.support.Column;
import com.ursful.framework.orm.support.ExpressionType;
import java.io.Serializable;
import java.util.Collection;

public class Expression
implements Serializable {
    public static final String EXPRESSION_ALL = "*";
    public static final String EXPRESSION_SUM = "SUM";
    public static final String EXPRESSION_MAX = "MAX";
    public static final String EXPRESSION_MIN = "MIN";
    public static final String EXPRESSION_AVG = "AVG";
    public static final String EXPRESSION_COUNT = "COUNT";
    private Column left;
    private ExpressionType type;
    private Object value;
    private Object andValue;

    public Expression andValue(Object andValue) {
        this.andValue = andValue;
        return this;
    }

    public Object getAndValue() {
        return this.andValue;
    }

    public void setAndValue(Object andValue) {
        this.andValue = andValue;
    }

    public Expression(ExpressionType type, IMultiQuery value) {
        this.type = type;
        this.value = value;
    }

    public Expression(Column left, Column value) {
        this.left = left;
        this.type = ExpressionType.CDT_EQUAL;
        this.value = value;
    }

    public Expression(Column left, ExpressionType type) {
        this.left = left;
        this.type = type;
    }

    public Expression(Column left, Object value, ExpressionType type) {
        this.left = left;
        this.type = type;
        this.value = value;
    }

    public Expression(String left, Object value, ExpressionType type) {
        this.left = new Column(left);
        this.type = type;
        this.value = value;
    }

    public Expression(String function, String left, Object value, ExpressionType type) {
        this.left = new Column(function, null, left, null);
        this.type = type;
        this.value = value;
    }

    public Expression(String left, ExpressionType type) {
        this.left = new Column(left);
        this.type = type;
    }

    public Expression(String left, Object value) {
        this.left = new Column(left);
        if (value instanceof ExpressionType) {
            this.type = (ExpressionType)((Object)value);
        } else {
            this.type = ExpressionType.CDT_EQUAL;
            this.value = value;
        }
    }

    public Column getLeft() {
        return this.left;
    }

    public void setLeft(Column left) {
        this.left = left;
    }

    public ExpressionType getType() {
        return this.type;
    }

    public void setType(ExpressionType type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static void main(String[] args) {
    }

    public static Expression equal(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_EQUAL);
    }

    public static Expression notEqual(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_NOT_EQUAL);
    }

    public static Expression like(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_LIKE);
    }

    public static Expression notLike(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_NOT_LIKE);
    }

    public static Expression startWith(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_START_WITH);
    }

    public static Expression notStartWith(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_NOT_START_WITH);
    }

    public static Expression endWith(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_END_WITH);
    }

    public static Expression notEndWith(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_NOT_END_WITH);
    }

    public static Expression less(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_LESS);
    }

    public static Expression lessEqual(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_LESS_EQUAL);
    }

    public static Expression more(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_MORE);
    }

    public static Expression moreEqual(String column, Object val) {
        return new Expression(new Column(column), val, ExpressionType.CDT_MORE_EQUAL);
    }

    public static Expression in(String column, Collection val) {
        return new Expression(new Column(column), (Object)val, ExpressionType.CDT_IN);
    }

    public static Expression notIn(String column, Collection val) {
        return new Expression(new Column(column), (Object)val, ExpressionType.CDT_NOT_IN);
    }

    public static Expression isNull(String column) {
        return new Expression(new Column(column), null, ExpressionType.CDT_IS_NULL);
    }

    public static Expression isNotNull(String column) {
        return new Expression(new Column(column), null, ExpressionType.CDT_IS_NOT_NULL);
    }

    public static Expression isEmpty(String column) {
        return new Expression(new Column(column), null, ExpressionType.CDT_IS_EMPTY);
    }

    public static Expression isNotEmpty(String column) {
        return new Expression(new Column(column), null, ExpressionType.CDT_IS_NOT_EMPTY);
    }

    public static Expression between(String column, Object value1, Object value2) {
        Expression ex = new Expression(new Column(column), value1, ExpressionType.CDT_BETWEEN);
        ex.andValue(value2);
        return ex;
    }
}

