/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.transaction;

import com.ursful.framework.orm.support.ChangeHolder;
import java.util.UUID;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class MultiTransactionManager
extends JtaTransactionManager {
    protected void doBegin(Object transaction, TransactionDefinition definition) {
        String key = "jta-transaction-" + UUID.randomUUID().toString();
        this.logger.debug((Object)("jta begin...." + key));
        ChangeHolder.set(key);
        super.doBegin(transaction, definition);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        this.logger.debug((Object)("jta commit...." + ChangeHolder.get()));
        super.doCommit(status);
        ChangeHolder.change();
    }

    protected void doRollback(DefaultTransactionStatus status) {
        this.logger.debug((Object)("jta rollback...." + ChangeHolder.get()));
        ChangeHolder.remove();
        super.doRollback(status);
    }
}

