/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm;

import com.ursful.framework.orm.DataSourceManager;
import com.ursful.framework.orm.DynamicDataSource;
import com.ursful.framework.orm.ISQLService;
import com.ursful.framework.orm.annotation.RdId;
import com.ursful.framework.orm.annotation.RdTable;
import com.ursful.framework.orm.exception.ORMBatchException;
import com.ursful.framework.orm.exception.ORMError;
import com.ursful.framework.orm.exception.ORMException;
import com.ursful.framework.orm.handler.DefaultResultSetHandler;
import com.ursful.framework.orm.handler.IResultSetHandler;
import com.ursful.framework.orm.handler.ResultSetFunction;
import com.ursful.framework.orm.helper.SQLHelper;
import com.ursful.framework.orm.helper.SQLHelperCreator;
import com.ursful.framework.orm.support.ColumnClass;
import com.ursful.framework.orm.support.ColumnInfo;
import com.ursful.framework.orm.support.DatabaseTypeHolder;
import com.ursful.framework.orm.support.IRealConnection;
import com.ursful.framework.orm.support.KV;
import com.ursful.framework.orm.support.Options;
import com.ursful.framework.orm.support.Pair;
import com.ursful.framework.orm.support.Table;
import com.ursful.framework.orm.support.TableColumn;
import com.ursful.framework.orm.utils.ORMUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLServiceImpl
implements ISQLService {
    private Logger logger = Logger.getLogger(SQLServiceImpl.class);
    @Autowired(required=false)
    public DataSourceManager dataSourceManager;
    protected Class<?> thisClass;
    protected Class<?> serviceClass;
    protected IResultSetHandler resultSetHandler = new DefaultResultSetHandler();

    public SQLServiceImpl() {
    }

    public SQLServiceImpl(DataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    public IResultSetHandler getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setResultSetHandler(IResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    @Override
    public DataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    @Override
    public Options getOptions() {
        if (this.dataSourceManager == null) {
            return null;
        }
        return this.dataSourceManager.getOptions(this.thisClass, this.serviceClass);
    }

    @Override
    public String currentDatabaseName() {
        if (this.dataSourceManager == null) {
            return null;
        }
        return this.dataSourceManager.getProductName(this.thisClass, this.serviceClass);
    }

    @Override
    public String currentDatabaseType() {
        Options options = this.getOptions();
        if (options != null) {
            return this.getOptions().databaseType();
        }
        return null;
    }

    @Override
    public DataSource getDataSource() {
        if (this.dataSourceManager == null) {
            return null;
        }
        return this.dataSourceManager.getDataSource(this.thisClass, this.serviceClass);
    }

    @Override
    public void changeDataSource(String alias) {
        DynamicDataSource.setDataSource(alias);
    }

    @Override
    public void setDataSourceManager(DataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    @Override
    public boolean execute(String sql, Object ... params) {
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            boolean bl = ps.execute();
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(null, ps, conn);
        }
    }

    private void setParams(PreparedStatement ps, Object[] params, Connection connection) throws SQLException {
        if (params != null && params.length > 0) {
            ArrayList<Pair> pairList = new ArrayList<Pair>();
            for (Object object : params) {
                pairList.add(new Pair(object));
            }
            SQLHelperCreator.setParameter(this.getOptions(), ps, pairList, connection);
        }
    }

    @Override
    public boolean executeBatch(String sql, Object[] ... params) {
        return this.executeBatch(sql, false, true, params);
    }

    @Override
    public void query(String sql, Object[] params, ResultSetFunction function) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            if (params != null) {
                ArrayList<Pair> pairList = new ArrayList<Pair>();
                for (Object param : params) {
                    pairList.add(new Pair(param));
                }
                SQLHelperCreator.setParameter(this.getOptions(), ps, pairList, conn);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                function.process(rs);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + sql), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, OBJECT: " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
    }

    @Override
    public boolean executeBatch(String sql, boolean autoCommit, boolean rollback, Object[] ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        boolean result = false;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            if (!autoCommit) {
                conn.setAutoCommit(false);
            }
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    this.setParams(ps, params[i], conn);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
            if (!autoCommit) {
                conn.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (!autoCommit && rollback) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new ORMBatchException(e, params.length, 0);
        }
        finally {
            if (conn != null && !autoCommit) {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
            }
            this.closeConnection(rs, ps, conn);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T queryObject(Class<T> clazz, String sql, Object ... params) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        T temp = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            if (params != null) {
                ArrayList<Pair> pairList = new ArrayList<Pair>();
                for (Object param : params) {
                    pairList.add(new Pair(param));
                }
                SQLHelperCreator.setParameter(this.getOptions(), ps, pairList, conn);
            }
            if ((rs = ps.executeQuery()).next()) {
                temp = SQLHelperCreator.newClass(clazz, rs, this.resultSetHandler);
            }
            this.closeConnection(rs, ps, conn);
            return temp;
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + sql), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, OBJECT: " + e.getMessage());
                catch (IllegalAccessException e2) {
                    this.logger.error((Object)("SQL : " + sql), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, OBJECT: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<T> queryObjectList(Class<T> clazz, String sql, Object ... params) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            if (params != null) {
                ArrayList<Pair> pairList = new ArrayList<Pair>();
                for (Object param : params) {
                    pairList.add(new Pair(param));
                }
                SQLHelperCreator.setParameter(this.getOptions(), ps, pairList, conn);
            }
            rs = ps.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.closeConnection(rs, ps, conn);
                    return temp;
                }
                Object tmp = SQLHelperCreator.newClass(clazz, rs, this.resultSetHandler);
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + sql), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, OBJECT LIST: " + e.getMessage());
                catch (IllegalAccessException e2) {
                    this.logger.error((Object)("SQL : " + sql), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, OBJECT LIST: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
    }

    @Override
    public Map<String, Object> queryMap(String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        HashMap<String, Object> tempMap = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                ResultSetMetaData metaMap = rs.getMetaData();
                tempMap = new HashMap<String, Object>();
                for (int i = 1; i <= metaMap.getColumnCount(); ++i) {
                    Object obj = rs.getObject(i);
                    KV kv = this.resultSetHandler.parse(metaMap, i, obj, rs);
                    if (kv == null) continue;
                    tempMap.put(kv.getKey(), kv.getValue());
                }
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        return tempMap;
    }

    @Override
    public List<Map<String, Object>> queryMapList(String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        ArrayList<Map<String, Object>> temp = new ArrayList<Map<String, Object>>();
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                ResultSetMetaData metaMap = rs.getMetaData();
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                for (int i = 1; i <= metaMap.getColumnCount(); ++i) {
                    Object obj = rs.getObject(i);
                    KV kv = this.resultSetHandler.parse(metaMap, i, obj, rs);
                    if (kv == null) continue;
                    tempMap.put(kv.getKey(), kv.getValue());
                }
                temp.add(tempMap);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        return temp;
    }

    @Override
    public int queryCount(String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        int temp = 0;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                temp = rs.getInt(1);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        return temp;
    }

    @Override
    public Object queryResult(String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        Object temp = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                temp = rs.getObject(1);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        return temp;
    }

    public void closeConnection(ResultSet rs, Statement stmt, Connection conn) {
        if (this.dataSourceManager == null) {
            return;
        }
        this.dataSourceManager.close(this.thisClass, this.serviceClass, rs, stmt, conn);
    }

    @Override
    public Connection getConnection() {
        if (this.dataSourceManager == null) {
            return null;
        }
        return this.dataSourceManager.getConnection(this.thisClass, this.serviceClass);
    }

    @Override
    public Date getDatabaseDateTime() {
        Double longTime = this.getDatabaseNanoTime();
        if (longTime != null) {
            return new Date(longTime.longValue());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Double getDatabaseNanoTime() {
        if (this.dataSourceManager == null) {
            return null;
        }
        ResultSet rs = null;
        Statement ps = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            String type = DatabaseTypeHolder.get();
            if (type == null) {
                Double d = null;
                return d;
            }
            Options options = this.dataSourceManager.getOptions(type);
            if (options == null) {
                Double d = null;
                return d;
            }
            String sql = options.nanoTimeSQL();
            if (sql == null) {
                Double d = null;
                this.closeConnection(rs, ps, conn);
                return d;
            }
            ps = conn.createStatement();
            rs = ps.executeQuery(sql);
            if (rs.next()) {
                Object object = rs.getObject(1);
                if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    Double d = (double)timestamp.getTime() + (double)timestamp.getNanos() / 1.0E9;
                    this.closeConnection(rs, ps, conn);
                    return d;
                }
                if (object instanceof LocalDateTime) {
                    LocalDateTime ldt = (LocalDateTime)object;
                    int hour = TimeZone.getDefault().getRawOffset() / 1000 / 3600;
                    Double d = (double)ldt.toInstant(ZoneOffset.ofHours(hour)).toEpochMilli() * 1.0;
                    this.closeConnection(rs, ps, conn);
                    return d;
                }
                Timestamp timestamp = this.getOracleTimestamp(object, conn);
                ORMUtils.whenEmpty(timestamp, "Error get timestamp from oracle.");
                Double d = (double)timestamp.getTime() + (double)timestamp.getNanos() / 1.0E9;
                this.closeConnection(rs, ps, conn);
                return d;
            }
            this.closeConnection(rs, ps, conn);
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(rs, ps, conn);
        }
    }

    private Timestamp getOracleTimestamp(Object value, Connection connection) {
        try {
            ORMUtils.whenEmpty(connection, "Oracle connection should not be nullable.");
            Connection conn = this.getRealConnection(connection);
            Class<?> clz = value.getClass();
            Method m = clz.getMethod("timestampValue", Connection.class);
            return (Timestamp)m.invoke(value, conn);
        }
        catch (Exception e) {
            this.logger.error((Object)("oracle get timestamp : " + value), (Throwable)e);
            return null;
        }
    }

    private Connection getRealConnection(Connection connection) {
        Connection conn = null;
        List<IRealConnection> realConnections = this.getDataSourceManager().getRealConnection();
        if (!realConnections.isEmpty()) {
            for (IRealConnection realConnection : realConnections) {
                Connection temp = realConnection.getConnection(connection);
                if (temp == null) continue;
                conn = temp;
                break;
            }
        }
        if (conn == null && connection.getClass().getName().endsWith("DruidPooledConnection")) {
            Class<?> clazz = null;
            try {
                clazz = connection.getClass().getClassLoader().loadClass("com.alibaba.druid.pool.DruidPooledConnection");
                Method method = clazz.getMethod("getConnection", new Class[0]);
                conn = (Connection)method.invoke((Object)connection, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.getTargetException();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (conn == null) {
            conn = connection;
        }
        return conn;
    }

    @Override
    public <S> List<S> batchSaves(List<S> ts, int batchCount) {
        return this.batchSaves(ts, batchCount, true, false);
    }

    @Override
    public <S> List<S> batchSaves(List<S> ts, int batchCount, boolean autoCommit) {
        return this.batchSaves(ts, batchCount, autoCommit, false);
    }

    @Override
    public <S> List<S> batchSaves(List<S> ts, boolean rollback) {
        return this.batchSaves(ts, ts.size(), !rollback, rollback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <S> List<S> batchSaves(List<S> ts, int batchCount, boolean autoCommit, boolean rollback) {
        Connection conn;
        PreparedStatement ps;
        ResultSet rs;
        block23: {
            if (ts == null) return ts;
            if (ts.isEmpty()) {
                return ts;
            }
            rs = null;
            ps = null;
            conn = null;
            int index = 0;
            try {
                List<SQLHelper> helpers2332;
                conn = this.getConnection();
                if (!autoCommit) {
                    conn.setAutoCommit(false);
                }
                if ((helpers2332 = SQLHelperCreator.inserts(ts, this.getOptions())).isEmpty()) {
                    ArrayList arrayList = new ArrayList();
                    return arrayList;
                }
                SQLHelper helper = helpers2332.get(0);
                RdId rdId = null;
                if (helper.getIdValue() == null && helper.getIdField() != null) {
                    rdId = helper.getIdField().getAnnotation(RdId.class);
                }
                ps = rdId != null && rdId.autoIncrement() ? conn.prepareStatement(helper.getSql(), 1) : conn.prepareStatement(helper.getSql());
                for (int i = 0; i < helpers2332.size(); i += batchCount) {
                    index = i;
                    int lastIndex = Math.min(i + batchCount, helpers2332.size()) - 1;
                    if (i > lastIndex) continue;
                    for (int j = i; j <= lastIndex; ++j) {
                        SQLHelper sqlHelper = helpers2332.get(j);
                        SQLHelperCreator.setParameter(this.getOptions(), ps, sqlHelper.getParameters(), conn);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                    if (rdId == null || !rdId.autoIncrement()) continue;
                    ResultSet seqRs = ps.getGeneratedKeys();
                    int j = i;
                    while (seqRs.next()) {
                        Object key = seqRs.getObject(1);
                        S s = ts.get(j);
                        helper.setId(s, key);
                        ++j;
                    }
                    seqRs.close();
                }
                if (!autoCommit) {
                    conn.commit();
                }
                if (conn == null || autoCommit) break block23;
            }
            catch (SQLException e) {
                if (autoCommit) throw new ORMBatchException(e, ts.size(), index);
                if (!rollback) throw new ORMBatchException(e, ts.size(), index);
                try {
                    conn.rollback();
                    throw new ORMBatchException(e, ts.size(), index);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new ORMBatchException(e, ts.size(), index);
            }
            try {
                conn.setAutoCommit(true);
            }
            catch (SQLException helpers2332) {
                // empty catch block
            }
        }
        this.closeConnection(rs, ps, conn);
        return ts;
        finally {
            if (conn != null && !autoCommit) {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
            }
            this.closeConnection(rs, ps, conn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean batchUpdates(List ts, String[] columns, int batchCount, boolean autoCommit, boolean rollback) {
        Connection conn;
        PreparedStatement ps;
        ResultSet rs;
        boolean result;
        block21: {
            result = false;
            if (ts == null) return result;
            if (ts.isEmpty()) {
                return result;
            }
            rs = null;
            ps = null;
            conn = null;
            int index = 0;
            try {
                List<SQLHelper> helpers2332;
                conn = this.getConnection();
                if (!autoCommit) {
                    conn.setAutoCommit(false);
                }
                if ((helpers2332 = SQLHelperCreator.updates(ts, columns == null ? null : Arrays.asList(columns))).isEmpty()) {
                    boolean bl = result;
                    return bl;
                }
                SQLHelper helper = helpers2332.get(0);
                ps = conn.prepareStatement(helper.getSql());
                for (int i = 0; i < helpers2332.size(); i += batchCount) {
                    index = i;
                    int lastIndex = Math.min(i + batchCount, helpers2332.size()) - 1;
                    if (i > lastIndex) continue;
                    for (int j = i; j <= lastIndex; ++j) {
                        SQLHelper sqlHelper = helpers2332.get(j);
                        SQLHelperCreator.setParameter(this.getOptions(), ps, sqlHelper.getParameters(), conn);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                if (!autoCommit) {
                    conn.commit();
                }
                result = true;
                if (conn == null || autoCommit) break block21;
            }
            catch (SQLException e) {
                if (autoCommit) throw new ORMBatchException(e, ts.size(), index);
                if (!rollback) throw new ORMBatchException(e, ts.size(), index);
                try {
                    conn.rollback();
                    throw new ORMBatchException(e, ts.size(), index);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new ORMBatchException(e, ts.size(), index);
            }
            try {
                conn.setAutoCommit(true);
            }
            catch (SQLException helpers2332) {
                // empty catch block
            }
        }
        this.closeConnection(rs, ps, conn);
        return result;
        finally {
            if (conn != null && !autoCommit) {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
            }
            this.closeConnection(rs, ps, conn);
        }
    }

    @Override
    public boolean batchUpdates(List ts, String[] columns, boolean rollback) {
        return this.batchUpdates(ts, columns, ts.size(), !rollback, rollback);
    }

    @Override
    public boolean batchUpdates(List ts, int batchCount) {
        return this.batchUpdates(ts, null, ts.size(), true, false);
    }

    @Override
    public boolean batchUpdates(List ts, int batchCount, boolean autoCommit) {
        return this.batchUpdates(ts, null, batchCount, autoCommit, false);
    }

    @Override
    public boolean batchUpdates(List ts, int batchCount, boolean autoCommit, boolean rollback) {
        return this.batchUpdates(ts, null, batchCount, autoCommit, rollback);
    }

    @Override
    public boolean batchUpdates(List ts, boolean rollback) {
        return this.batchUpdates(ts, null, ts.size(), !rollback, rollback);
    }

    @Override
    public boolean batchUpdates(List ts, String[] columns, int batchCount) {
        return this.batchUpdates(ts, columns, batchCount, true, false);
    }

    @Override
    public boolean batchUpdates(List ts, String[] columns, int batchCount, boolean autoCommit) {
        return this.batchUpdates(ts, columns, batchCount, autoCommit, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOrUpdate(Class<?> table) throws ORMException {
        if (table == null) {
            return;
        }
        RdTable rdTable = ORMUtils.getRdTable(table);
        if (rdTable == null) {
            throw new ORMException(ORMError.CLASS_TABLE_ANNOTATION_NOT_FOUND, table.getName());
        }
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"Create Or update Not Support.");
            return;
        }
        Connection temp = this.getConnection();
        try {
            List<String> sqls;
            Connection connection = this.getRealConnection(temp);
            Table queryTable = options.table(connection, rdTable);
            List<ColumnInfo> columnInfoList = ORMUtils.getColumnInfo(table);
            if (queryTable == null && columnInfoList.isEmpty() && !rdTable.dropped()) {
                throw new ORMException(ORMError.CLASS_COLUMN_IS_EMPTY, table.getName(), rdTable.name());
            }
            List<TableColumn> columns = null;
            if (queryTable != null && !rdTable.dropped()) {
                columns = options.columns(connection, rdTable);
            }
            if ((sqls = options.createOrUpdateSqls(connection, rdTable, columnInfoList, queryTable != null, columns)) != null && !sqls.isEmpty()) {
                for (String sql : sqls) {
                    PreparedStatement ps = null;
                    try {
                        ps = temp.prepareStatement(sql);
                        ps.execute();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)("Execute SQL Error : " + sql));
                        throw new RuntimeException(e);
                    }
                    finally {
                        this.closeConnection(null, ps, null);
                    }
                }
            }
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(Table table) throws ORMException {
        block11: {
            if (table == null) {
                return;
            }
            Options options = this.getOptions();
            if (options == null) {
                this.logger.warn((Object)"Drop table Not Support.");
                return;
            }
            Connection temp = this.getConnection();
            try {
                Connection connection = this.getRealConnection(temp);
                Table queryTable = options.table(connection, table);
                if (queryTable != null) {
                    String sql = options.dropTable(table);
                    PreparedStatement ps = null;
                    try {
                        ps = temp.prepareStatement(sql);
                        ps.execute();
                        break block11;
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)("Execute SQL Error : " + sql));
                        throw new RuntimeException(e);
                    }
                    finally {
                        this.closeConnection(null, ps, null);
                    }
                }
                this.logger.info((Object)("Table not exist : " + table.getName()));
            }
            finally {
                this.closeConnection(null, null, temp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOrUpdate(Table table, List<TableColumn> tableColumns) throws ORMException {
        if (table == null) {
            return;
        }
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"Create Or update Table Not Support.");
            return;
        }
        Connection temp = this.getConnection();
        try {
            List<String> sqls;
            Connection connection = this.getRealConnection(temp);
            Table queryTable = options.table(connection, table);
            List<TableColumn> columns = null;
            if (queryTable != null) {
                columns = options.columns(connection, table.getName());
            }
            if ((sqls = options.createOrUpdateSqls(connection, table, tableColumns, columns, queryTable != null)) != null && !sqls.isEmpty()) {
                for (String sql : sqls) {
                    PreparedStatement ps = null;
                    try {
                        ps = temp.prepareStatement(sql);
                        ps.execute();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)("Execute SQL Error : " + sql));
                        throw new RuntimeException(e);
                    }
                    finally {
                        this.closeConnection(null, ps, null);
                    }
                }
            }
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public boolean tableExists(String table) {
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"SQL Not Support.");
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            boolean bl = options.tableExists(connection, table);
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public String getTableName(Class<?> clazz) throws ORMException {
        if (clazz == null) {
            return null;
        }
        RdTable rdTable = ORMUtils.getRdTable(clazz);
        if (rdTable == null) {
            throw new ORMException(ORMError.CLASS_TABLE_ANNOTATION_NOT_FOUND, clazz.getName());
        }
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"Query table Not Support.");
            return null;
        }
        return options.getTableName(rdTable);
    }

    @Override
    public Table table(Class<?> clazz) throws ORMException {
        if (clazz == null) {
            return null;
        }
        RdTable rdTable = ORMUtils.getRdTable(clazz);
        if (rdTable == null) {
            throw new ORMException(ORMError.CLASS_TABLE_ANNOTATION_NOT_FOUND, clazz.getName());
        }
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"Query table Not Support.");
            return null;
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            Table table = options.table(connection, rdTable);
            return table;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public Table table(String tableName) {
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"Query table Not Support.");
            return null;
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            Table table = options.table(connection, new Table(tableName));
            return table;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public List<TableColumn> columns(Class<?> clazz) throws ORMException {
        if (clazz == null) {
            return null;
        }
        RdTable rdTable = ORMUtils.getRdTable(clazz);
        if (rdTable == null) {
            throw new ORMException(ORMError.CLASS_TABLE_ANNOTATION_NOT_FOUND, clazz.getName());
        }
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"Create Or update Not Support.");
            return null;
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            Table queryTable = options.table(connection, rdTable);
            List<TableColumn> columns = null;
            if (queryTable != null && !rdTable.dropped()) {
                columns = options.columns(connection, rdTable);
            }
            List<TableColumn> list = columns;
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public List<Table> tables() {
        return this.tables(null);
    }

    @Override
    public List<Table> tables(String keyword) {
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"Query Tables Not Support.");
            return null;
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            List<Table> list = options.tables(connection, keyword);
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public List<TableColumn> tableColumns(String tableName) {
        List<TableColumn> columns = null;
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"Query Table Columns Not Support.");
            return null;
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            columns = options.columns(connection, tableName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
        if (columns != null && !columns.isEmpty()) {
            List<ColumnClass> columnClasses = this.tableColumnsClass(tableName);
            HashMap<String, String> columnClassMap = new HashMap<String, String>();
            for (ColumnClass columnClass : columnClasses) {
                columnClassMap.put(columnClass.getColumn(), columnClass.getColumnClass());
                columnClassMap.put(columnClass.getColumn().toUpperCase(Locale.ROOT), columnClass.getColumnClass());
                columnClassMap.put(columnClass.getColumn().toLowerCase(Locale.ROOT), columnClass.getColumnClass());
            }
            for (TableColumn tableColumn : columns) {
                tableColumn.setColumnClass((String)columnClassMap.get(tableColumn.getColumn()));
            }
        }
        return columns;
    }

    @Override
    public List<ColumnClass> tableColumnsClass(String tableName) {
        Options options = this.getOptions();
        if (options == null) {
            this.logger.warn((Object)"Query Table Columns Not Support.");
            return null;
        }
        Connection temp = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<ColumnClass> columnClasses = new ArrayList<ColumnClass>();
        try {
            String sql = String.format("SELECT * FROM %s WHERE 1 <> 1", tableName);
            stmt = temp.createStatement();
            rs = stmt.executeQuery(sql);
            ResultSetMetaData data = rs.getMetaData();
            int count = data.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String className = data.getColumnClassName(i);
                String columnName = data.getColumnName(i);
                int precision = data.getPrecision(i);
                int scale = data.getScale(i);
                ColumnClass columnClass = new ColumnClass(tableName, columnName, className);
                columnClass.setPrecision(precision);
                columnClass.setScale(scale);
                columnClasses.add(columnClass);
            }
            ArrayList<ColumnClass> arrayList = columnClasses;
            this.closeConnection(rs, stmt, temp);
            return arrayList;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, stmt, temp);
                throw throwable;
            }
        }
    }
}

