/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.query;

import com.ursful.framework.orm.IMultiQuery;
import com.ursful.framework.orm.IQuery;
import com.ursful.framework.orm.annotation.RdTable;
import com.ursful.framework.orm.query.QueryImpl;
import com.ursful.framework.orm.support.AliasTable;
import com.ursful.framework.orm.support.Column;
import com.ursful.framework.orm.support.Columns;
import com.ursful.framework.orm.support.Condition;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.ExpressionType;
import com.ursful.framework.orm.support.Join;
import com.ursful.framework.orm.support.JoinType;
import com.ursful.framework.orm.support.Options;
import com.ursful.framework.orm.support.Order;
import com.ursful.framework.orm.support.QueryInfo;
import com.ursful.framework.orm.utils.ORMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;

public class MultiQueryImpl
extends QueryImpl
implements IMultiQuery {
    private List<IMultiQuery> subQueries = new ArrayList<IMultiQuery>();
    private List<String> usedAlias = new ArrayList<String>();
    private IMultiQuery parentQuery;
    private List<String> aliasList = new ArrayList<String>();
    @Deprecated
    private List<String> aliasJoin = new ArrayList<String>();
    private Map<String, Object> aliasTable = new HashMap<String, Object>();
    private List<Column> groups = new ArrayList<Column>();
    private List<Column> groupCountsSelectColumns = new ArrayList<Column>();
    private List<Join> joins = new ArrayList<Join>();
    private Class<?> returnClass;
    private List<Column> returnColumns = new ArrayList<Column>();

    public MultiQueryImpl() {
    }

    public MultiQueryImpl(IMultiQuery query) {
        this.parentQuery = query;
    }

    @Override
    public IMultiQuery createQuery(Class<?> clazz, Column ... columns) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public IMultiQuery createQuery(Column ... columns) {
        this.returnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public IMultiQuery createQuery(Class<?> clazz, Columns ... columns) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        if (columns != null) {
            for (Columns column : columns) {
                if (column.getColumnList().isEmpty()) continue;
                this.returnColumns.addAll(column.getColumnList());
            }
        }
        return this;
    }

    @Override
    public IMultiQuery addReturnColumn(Column column) {
        if (column != null) {
            this.returnColumns.add(column);
        }
        return this;
    }

    @Override
    public IMultiQuery clearReturnColumns() {
        this.returnColumns.clear();
        return this;
    }

    private String generateUniqueAlias(Object object) {
        int i = 0;
        String prefixAlias = null;
        prefixAlias = object instanceof IQuery ? "q" : (object instanceof Class ? ((Class)object).getSimpleName().substring(0, 1).toLowerCase(Locale.ROOT) : object.toString().substring(0, 1).toLowerCase(Locale.ROOT));
        String alias = prefixAlias + i;
        while (this.containsAlias(alias)) {
            alias = prefixAlias + ++i;
        }
        return alias;
    }

    @Override
    public AliasTable join(IQuery query) {
        String alias = this.generateUniqueAlias(query);
        return this.join(query, alias);
    }

    @Override
    public AliasTable join(IQuery query, String alias) {
        AliasTable table = new AliasTable(query);
        table.setAlias(alias);
        this.aliasTable.put(alias, query);
        this.aliasJoin.add(alias);
        this.addUsedAlias(alias);
        return table;
    }

    @Override
    public AliasTable table(IQuery query, String alias) {
        AliasTable table = new AliasTable(query);
        table.setAlias(alias);
        this.aliasList.add(alias);
        this.addUsedAlias(alias);
        this.aliasTable.put(alias, query);
        return table;
    }

    @Override
    public AliasTable table(IQuery query) {
        String alias = this.generateUniqueAlias(query);
        return this.table(query, alias);
    }

    @Override
    public AliasTable join(Class<?> clazz, String alias) {
        ORMUtils.whenEmpty(clazz, "AliasTable join class should not be null.");
        RdTable rdTable = (RdTable)AnnotationUtils.findAnnotation(clazz, RdTable.class);
        ORMUtils.whenEmpty(rdTable, "Should annotate RdTable");
        AliasTable table = new AliasTable(clazz);
        table.setAlias(alias);
        this.aliasTable.put(alias, clazz);
        this.aliasJoin.add(alias);
        this.addUsedAlias(alias);
        return table;
    }

    @Override
    public AliasTable join(Class<?> clazz) {
        String alias = this.generateUniqueAlias(clazz);
        return this.join(clazz, alias);
    }

    @Override
    public IMultiQuery whereEqual(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_EQUAL);
    }

    @Override
    public IMultiQuery whereNotEqual(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_NOT_EQUAL);
    }

    @Override
    public IMultiQuery whereLike(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_LIKE);
    }

    @Override
    public IMultiQuery whereNotLike(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_NOT_LIKE);
    }

    @Override
    public IMultiQuery whereStartWith(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_START_WITH);
    }

    @Override
    public IMultiQuery whereEndWith(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_END_WITH);
    }

    @Override
    public IMultiQuery whereNotStartWith(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_NOT_START_WITH);
    }

    @Override
    public IMultiQuery whereNotEndWith(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_NOT_END_WITH);
    }

    @Override
    public IMultiQuery whereLess(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_LESS);
    }

    @Override
    public IMultiQuery whereLessEqual(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_LESS_EQUAL);
    }

    @Override
    public IMultiQuery whereMore(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_MORE);
    }

    @Override
    public IMultiQuery whereMoreEqual(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_MORE_EQUAL);
    }

    @Override
    public IMultiQuery whereIn(Column left, Collection value) {
        return this.where(left, value, ExpressionType.CDT_IN);
    }

    @Override
    public IMultiQuery whereInValues(Column left, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(left, temp, ExpressionType.CDT_IN);
    }

    @Override
    public IMultiQuery whereNotInValues(Column left, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(left, temp, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public IMultiQuery whereNotIn(Column left, Collection value) {
        return this.where(left, value, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public IMultiQuery whereNotInQuery(Column left, IMultiQuery query) {
        return this.where(left, query, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public IMultiQuery whereBetween(Column left, Object value, Object andValue) {
        if (!ORMUtils.isEmpty(value) && !ORMUtils.isEmpty(andValue)) {
            Expression expression = new Expression(left, value, ExpressionType.CDT_BETWEEN);
            expression.setAndValue(andValue);
            this.addCondition(new Condition().and(expression));
        }
        return this;
    }

    @Override
    public IMultiQuery whereInQuery(Column left, IMultiQuery query) {
        return this.where(left, query, ExpressionType.CDT_IN);
    }

    @Override
    public AliasTable table(Class<?> clazz) {
        String alias = this.generateUniqueAlias(clazz);
        return this.table(clazz, alias);
    }

    @Override
    public AliasTable table(String tableName, String alias) {
        AliasTable table = new AliasTable(tableName);
        table.setAlias(alias);
        this.aliasList.add(alias);
        this.aliasTable.put(alias, tableName);
        this.addUsedAlias(alias);
        return table;
    }

    @Override
    public AliasTable table(String tableName) {
        String alias = this.generateUniqueAlias(tableName);
        return this.table(tableName, alias);
    }

    @Override
    public AliasTable table(Class<?> clazz, String alias) {
        RdTable rdTable;
        if (this.returnClass == null) {
            this.returnClass = clazz;
        }
        AliasTable table = null;
        if (clazz != null && (rdTable = (RdTable)AnnotationUtils.findAnnotation(clazz, RdTable.class)) != null) {
            table = new AliasTable(clazz);
            table.setAlias(alias);
            this.aliasList.add(alias);
            this.addUsedAlias(alias);
            this.aliasTable.put(alias, clazz);
        }
        return table;
    }

    @Override
    public IMultiQuery whereIsNull(Column left) {
        this.addCondition(new Condition().and(new Expression(left, ExpressionType.CDT_IS_NULL)));
        return this;
    }

    @Override
    public IMultiQuery whereIsNotNull(Column left) {
        this.addCondition(new Condition().and(new Expression(left, ExpressionType.CDT_IS_NOT_NULL)));
        return this;
    }

    @Override
    public IMultiQuery whereIsEmpty(Column left) {
        this.addCondition(new Condition().and(new Expression(left, ExpressionType.CDT_IS_EMPTY)));
        return this;
    }

    @Override
    public IMultiQuery whereIsNotEmpty(Column left) {
        this.addCondition(new Condition().and(new Expression(left, ExpressionType.CDT_IS_NOT_EMPTY)));
        return this;
    }

    @Override
    public IMultiQuery where(Column left, Object value, ExpressionType type) {
        if (ORMUtils.isEmpty(value)) {
            if (type == ExpressionType.CDT_IS_NULL || type == ExpressionType.CDT_IS_NOT_NULL || type == ExpressionType.CDT_IS_EMPTY || type == ExpressionType.CDT_IS_NOT_EMPTY) {
                this.addCondition(new Condition().and(new Expression(left, type)));
            }
            return this;
        }
        this.addCondition(new Condition().and(new Expression(left, value, type)));
        return this;
    }

    @Override
    public IMultiQuery where(Column left, Column value) {
        this.addCondition(new Condition().and(new Expression(left, value)));
        return this;
    }

    @Override
    public IMultiQuery where(Condition condition) {
        if (condition != null) {
            this.addCondition(condition);
        }
        return this;
    }

    @Override
    public IMultiQuery where(Expression ... expressions) {
        this.addCondition(new Condition().and(expressions));
        return this;
    }

    @Override
    public IMultiQuery group(Column ... columns) {
        if (columns != null) {
            this.groups.addAll(Arrays.asList(columns));
        }
        return this;
    }

    @Override
    public List<Column> getGroupCountSelectColumns() {
        return this.groupCountsSelectColumns;
    }

    @Override
    public IMultiQuery groupCountSelectColumn(Column ... columns) {
        if (columns != null) {
            this.groupCountsSelectColumns.addAll(Arrays.asList(columns));
        }
        return this;
    }

    @Override
    public IMultiQuery group(Columns ... columns) {
        if (columns != null) {
            for (Columns column : columns) {
                this.groups.addAll(column.getColumnList());
            }
        }
        return this;
    }

    @Override
    public IMultiQuery having(Column left, Object value, ExpressionType type) {
        if (ORMUtils.isEmpty(value)) {
            return this;
        }
        this.addHaving(new Condition().or(new Expression(left, value, type)));
        return this;
    }

    @Override
    public IMultiQuery having(Column left, Column value) {
        this.addHaving(new Condition().and(new Expression(left, value)));
        return this;
    }

    @Override
    public IMultiQuery having(Condition condition) {
        if (condition != null) {
            this.addHaving(condition);
        }
        return this;
    }

    @Override
    public IMultiQuery orderDesc(Column column) {
        this.orders.add(new Order(column, "DESC"));
        return this;
    }

    @Override
    public IMultiQuery orderAsc(Column column) {
        this.orders.add(new Order(column, "ASC"));
        return this;
    }

    @Override
    public IMultiQuery orders(List<Order> orderList) {
        if (orderList != null) {
            for (Order order : orderList) {
                this.orders.add(order);
            }
        }
        return this;
    }

    @Override
    public IMultiQuery join(Join join) {
        this.joins.add(join);
        return this;
    }

    @Override
    public IMultiQuery join(AliasTable table, Column left, Column right) {
        return this.join(new Join(table).on(left, right));
    }

    @Override
    public IMultiQuery join(AliasTable table, JoinType joinType, Column left, Column right) {
        return this.join(new Join(table, joinType).on(left, right));
    }

    @Override
    public IMultiQuery distinct() {
        this.distinct = true;
        return this;
    }

    @Override
    public Class<?> getTable() {
        return null;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public List<String> getAliasList() {
        return this.aliasList;
    }

    @Override
    @Deprecated
    public List<String> getAliasJoinList() {
        return this.aliasJoin;
    }

    @Override
    public Map<String, Object> getAliasTable() {
        return this.aliasTable;
    }

    @Override
    public List<Join> getJoins() {
        return this.joins;
    }

    @Override
    public List<Column> getGroups() {
        return this.groups;
    }

    @Override
    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public List<Column> getReturnColumns() {
        if (this.returnColumns.isEmpty()) {
            for (String alias : this.aliasList) {
                this.returnColumns.add(new Column(alias, "*"));
            }
        }
        return this.returnColumns;
    }

    @Override
    public void addUsedAlias(String alias) {
        if (this.parentQuery == null) {
            this.usedAlias.add(alias);
        } else {
            for (IMultiQuery temp = this.parentQuery; temp != null; temp = temp.parentQuery()) {
                if (temp.parentQuery() != null) continue;
                temp.addUsedAlias(alias);
            }
        }
    }

    @Override
    public boolean containsAlias(String alias) {
        if (this.parentQuery == null) {
            return this.usedAlias.contains(alias);
        }
        boolean hasC = false;
        for (IMultiQuery temp = this.parentQuery; temp != null; temp = temp.parentQuery()) {
            if (temp.parentQuery() != null) continue;
            hasC = temp.containsAlias(alias);
            break;
        }
        return hasC;
    }

    @Override
    public IMultiQuery createMultiQuery() {
        MultiQueryImpl query = new MultiQueryImpl(this);
        query.setTextTransformType(this.textTransformType());
        if (this.isLessDatePlus235959()) {
            query.enableLessDatePlus235959();
        }
        if (this.isLessEqualDatePlus235959()) {
            query.enableLessEqualDatePlus235959();
        }
        this.subQueries.add(query);
        return query;
    }

    @Override
    public IMultiQuery parentQuery() {
        return this.parentQuery;
    }

    @Override
    public void setOptions(Options options) {
        this.options = options;
        for (IMultiQuery query : this.subQueries) {
            query.setOptions(options);
        }
    }

    @Override
    public QueryInfo doQuery() {
        if (this.parentQuery != null) {
            return this.parentQuery.getOptions().doQuery(this, this.getPageable());
        }
        return this.options.doQuery(this, this.getPageable());
    }

    @Override
    public QueryInfo doQueryCount() {
        if (this.parentQuery != null) {
            return this.parentQuery.getOptions().doQueryCount(this);
        }
        return this.options.doQueryCount(this);
    }

    @Override
    public IMultiQuery whereExists(IMultiQuery query) {
        this.addCondition(new Condition().and(new Expression(ExpressionType.CDT_EXISTS, query)));
        return this;
    }

    @Override
    public IMultiQuery whereNotExists(IMultiQuery query) {
        this.addCondition(new Condition().and(new Expression(ExpressionType.CDT_NOT_EXISTS, query)));
        return this;
    }
}

