/*
 * Copyright 2017 @ursful.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ursful.framework.orm.support;

import java.util.LinkedHashMap;
import java.util.Map;

public class CaseColumn extends Column {

    private Map<Condition, Object> conditions = new LinkedHashMap<Condition, Object>();
    private Object elseValue;

    public CaseColumn whenThen(Condition condition, Object value){
        conditions.put(condition, value);
        return this;
    }

    public CaseColumn elseEnd(Object value){
        this.elseValue = value;
        return this;
    }

    public Object getElseValue() {
        return elseValue;
    }

    public void setElseValue(Object elseValue) {
        this.elseValue = elseValue;
    }

    public Map<Condition, Object> getConditions() {
        return conditions;
    }

    public void setConditions(Map<Condition, Object> conditions) {
        this.conditions = conditions;
    }
}