/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.support;

import com.ursful.framework.orm.IMultiQuery;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.ExpressionType;
import com.ursful.framework.orm.support.OperatorType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;

public class Column
implements Serializable {
    private String name;
    private String function;
    private String alias;
    private String asName;
    private String fieldName;
    private Object value;
    private OperatorType type;
    private String format;
    private Boolean operatorInFunction = true;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Boolean getOperatorInFunction() {
        return this.operatorInFunction;
    }

    public void setOperatorInFunction(Boolean operatorInFunction) {
        this.operatorInFunction = operatorInFunction;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public OperatorType getType() {
        return this.type;
    }

    public void setType(OperatorType type) {
        this.type = type;
    }

    public String getAsName() {
        return this.asName;
    }

    public void setAsName(String asName) {
        if (asName != null) {
            this.asName = this.getReplace(asName.toUpperCase(Locale.ROOT));
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        if (function != null) {
            this.function = this.getReplace(function);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getReplace(String value) {
        if (value != null) {
            value = value.replace(" ", "");
        }
        return value;
    }

    public void setName(String name) {
        this.name = this.getReplace(name);
    }

    public Column() {
    }

    public Column(String name) {
        this.setName(name);
    }

    public Column(String alias, String name) {
        this.setName(name);
        this.alias = alias;
    }

    public Column(String alias, String name, String asName) {
        this.alias = alias;
        this.setName(name);
        this.setAsName(asName);
    }

    public Column(String function, String alias, String name, String asName) {
        this.alias = alias;
        this.setFunction(function);
        this.setName(name);
        this.setAsName(asName);
    }

    public Column all() {
        this.setFunction("*");
        return this;
    }

    public Column sum() {
        this.setFunction("SUM");
        return this;
    }

    public Column max() {
        this.setFunction("MAX");
        return this;
    }

    public Column min() {
        this.setFunction("MIN");
        return this;
    }

    public Column avg() {
        this.setFunction("AVG");
        return this;
    }

    public Column count() {
        this.setFunction("COUNT");
        return this;
    }

    public Column function(String function) {
        this.setFunction(function);
        return this;
    }

    public Column alias(String alias) {
        this.alias = alias;
        return this;
    }

    public Column name(String name) {
        this.setName(name);
        return this;
    }

    public Column as(String asName) {
        this.setAsName(asName);
        return this;
    }

    public Column value(Object value) {
        this.value = value;
        return this;
    }

    public Column operator(OperatorType type) {
        this.type = type;
        return this;
    }

    public Column format(String format) {
        this.format = format;
        return this;
    }

    public Column formatValues(Object ... values) {
        this.value = values;
        return this;
    }

    public Column field(String field) {
        if (field == null || field.length() == 0) {
            return this;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < field.length(); ++i) {
            char c = field.charAt(i);
            if ('A' <= c && c <= 'Z') {
                sb.append("_");
                sb.append((c + "").toLowerCase(Locale.ROOT));
                continue;
            }
            sb.append(c);
        }
        this.name = sb.toString();
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Column operatorInFunction(Boolean operatorInFunction) {
        this.operatorInFunction = operatorInFunction;
        return this;
    }

    public Column fieldName(String fieldName) {
        this.setFieldName(fieldName);
        return this;
    }

    public Expression equal(Object val) {
        return new Expression(this, val, ExpressionType.CDT_EQUAL);
    }

    public Expression notEqual(Object val) {
        return new Expression(this, val, ExpressionType.CDT_NOT_EQUAL);
    }

    public Expression like(Object val) {
        return new Expression(this, val, ExpressionType.CDT_LIKE);
    }

    public Expression notLike(Object val) {
        return new Expression(this, val, ExpressionType.CDT_NOT_LIKE);
    }

    public Expression startWith(Object val) {
        return new Expression(this, val, ExpressionType.CDT_START_WITH);
    }

    public Expression notStartWith(Object val) {
        return new Expression(this, val, ExpressionType.CDT_NOT_START_WITH);
    }

    public Expression endWith(Object val) {
        return new Expression(this, val, ExpressionType.CDT_END_WITH);
    }

    public Expression notEndWith(Object val) {
        return new Expression(this, val, ExpressionType.CDT_NOT_END_WITH);
    }

    public Expression less(Object val) {
        return new Expression(this, val, ExpressionType.CDT_LESS);
    }

    public Expression lessEqual(Object val) {
        return new Expression(this, val, ExpressionType.CDT_LESS_EQUAL);
    }

    public Expression more(Object val) {
        return new Expression(this, val, ExpressionType.CDT_MORE);
    }

    public Expression moreEqual(Object val) {
        return new Expression(this, val, ExpressionType.CDT_MORE_EQUAL);
    }

    public Expression in(Collection val) {
        return new Expression(this, (Object)val, ExpressionType.CDT_IN);
    }

    public Expression notIn(Collection val) {
        return new Expression(this, (Object)val, ExpressionType.CDT_NOT_IN);
    }

    public Expression isNull() {
        return new Expression(this, null, ExpressionType.CDT_IS_NULL);
    }

    public Expression isNotNull() {
        return new Expression(this, null, ExpressionType.CDT_IS_NOT_NULL);
    }

    public Expression isEmpty() {
        return new Expression(this, null, ExpressionType.CDT_IS_EMPTY);
    }

    public Expression isNotEmpty() {
        return new Expression(this, null, ExpressionType.CDT_IS_NOT_EMPTY);
    }

    public Expression exists(IMultiQuery val) {
        return new Expression(this, (Object)val, ExpressionType.CDT_EXISTS);
    }

    public Expression notExists(IMultiQuery val) {
        return new Expression(this, (Object)val, ExpressionType.CDT_NOT_EXISTS);
    }

    public Expression between(Object value1, Object value2) {
        Expression ex = new Expression(this, value1, ExpressionType.CDT_NOT_EXISTS);
        ex.andValue(value2);
        return ex;
    }

    public static void main(String[] args) {
        Column c = new Column().function("sum").alias("u").name("test").as("x");
    }
}

