/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm;

import com.ursful.framework.orm.IBaseService;
import com.ursful.framework.orm.IQuery;
import com.ursful.framework.orm.SQLServiceImpl;
import com.ursful.framework.orm.annotation.RdId;
import com.ursful.framework.orm.exception.ORMException;
import com.ursful.framework.orm.helper.SQLHelper;
import com.ursful.framework.orm.helper.SQLHelperCreator;
import com.ursful.framework.orm.listener.IChangeListener;
import com.ursful.framework.orm.listener.IChangedListener;
import com.ursful.framework.orm.listener.IDefaultListener;
import com.ursful.framework.orm.listener.IORMListener;
import com.ursful.framework.orm.listener.IQueryListener;
import com.ursful.framework.orm.support.ChangeHolder;
import com.ursful.framework.orm.support.Condition;
import com.ursful.framework.orm.support.Express;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.MultiOrder;
import com.ursful.framework.orm.support.Names;
import com.ursful.framework.orm.support.ORMType;
import com.ursful.framework.orm.support.Options;
import com.ursful.framework.orm.support.Pageable;
import com.ursful.framework.orm.support.PreChangeCache;
import com.ursful.framework.orm.support.QueryInfo;
import com.ursful.framework.orm.utils.ORMUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;

public abstract class BaseServiceImpl<T>
extends SQLServiceImpl
implements IBaseService<T>,
BeanFactoryAware {
    private Logger logger = Logger.getLogger(BaseServiceImpl.class);
    private List<IORMListener> listeners = new ArrayList<IORMListener>();
    private List<IDefaultListener> defaultListeners = new ArrayList<IDefaultListener>();
    private List<IChangeListener> changeListeners = new ArrayList<IChangeListener>();
    private List<IChangedListener> changedListeners = new ArrayList<IChangedListener>();
    private List<IQueryListener> queryListeners = new ArrayList<IQueryListener>();
    private ListableBeanFactory factory;

    protected BaseServiceImpl() {
        Type[] ts = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.thisClass = (Class)ts[0];
        this.serviceClass = this.getClass();
    }

    @Override
    public void addDefaultListener(IDefaultListener listener) {
        if (!this.defaultListeners.contains(listener)) {
            this.defaultListeners.add(listener);
        }
    }

    @Override
    public void removeDefaultListener(IDefaultListener listener) {
        if (this.defaultListeners.contains(listener)) {
            this.defaultListeners.remove(listener);
        }
    }

    @Override
    public void addChangeListener(IChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public void removeChangeListener(IChangeListener listener) {
        if (this.changeListeners.contains(listener)) {
            this.changeListeners.remove(listener);
        }
    }

    public void addChangedListener(IChangedListener listener) {
        if (!this.changedListeners.contains(listener)) {
            this.changedListeners.add(listener);
        }
    }

    public void removeChangedListener(IChangedListener listener) {
        if (this.changedListeners.contains(listener)) {
            this.changedListeners.remove(listener);
        }
    }

    @Override
    public void addORMListener(IORMListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeORMListener(IORMListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void addQueryListener(IQueryListener listener) {
        if (!this.queryListeners.contains(listener)) {
            this.queryListeners.add(listener);
        }
    }

    public void removeQueryListener(IQueryListener listener) {
        if (this.queryListeners.contains(listener)) {
            this.queryListeners.remove(listener);
        }
    }

    private <S> void sortAddListeners(List<S> result, Class<S> clazz) {
        Map listenerMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.factory, clazz);
        for (Object listener : listenerMap.values()) {
            if (IBaseService.class.isAssignableFrom(listener.getClass()) || !ORMUtils.isTheSameClass(this.thisClass, listener.getClass())) continue;
            result.add(listener);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.factory = (ListableBeanFactory)beanFactory;
        this.sortAddListeners(this.listeners, IORMListener.class);
        this.sortAddListeners(this.defaultListeners, IDefaultListener.class);
        this.sortAddListeners(this.changeListeners, IChangeListener.class);
        this.sortAddListeners(this.changedListeners, IChangedListener.class);
        this.sortAddListeners(this.queryListeners, IQueryListener.class);
    }

    private void triggerQueryListener(IQuery query) {
        for (IQueryListener listener : this.queryListeners) {
            listener.handle(this.thisClass, query);
        }
    }

    private void triggerDefaultListener(T t, ORMType type) {
        for (IDefaultListener listener : this.defaultListeners) {
            try {
                if (type == ORMType.INSERT) {
                    listener.insert(t);
                    continue;
                }
                if (type == ORMType.UPDATE) {
                    listener.update(t);
                    continue;
                }
                if (type == ORMType.DELETE) {
                    listener.delete(t);
                    continue;
                }
                this.logger.warn((Object)"Other type, not support.");
            }
            catch (Exception e) {
                this.logger.error((Object)"Default Listener Error", (Throwable)e);
                throw e;
            }
        }
    }

    private void triggerORMListener(T t, ORMType type) {
        for (IORMListener listener : this.listeners) {
            try {
                if (type == ORMType.INSERT) {
                    listener.insert(t);
                    continue;
                }
                if (type == ORMType.UPDATE) {
                    listener.update(t);
                    continue;
                }
                if (type == ORMType.DELETE) {
                    listener.delete(t);
                    continue;
                }
                this.logger.warn((Object)"Other type, not support.");
            }
            catch (Exception e) {
                this.logger.error((Object)"ORM Listener Error", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void changed(T original, T current) {
        for (IChangedListener listener : this.changedListeners) {
            try {
                listener.changed(original, current);
            }
            catch (Exception e) {
                this.logger.error((Object)"Changed Listener Error", (Throwable)e);
            }
        }
    }

    private void triggerChangeListener(T original, T t, Connection connection) {
        boolean autoCommit = true;
        try {
            autoCommit = connection.getAutoCommit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (IChangeListener listener : this.changeListeners) {
            try {
                listener.change(original, t);
            }
            catch (Exception e) {
                this.logger.error((Object)"Change Listener Error", (Throwable)e);
                if (autoCommit && !(e instanceof RuntimeException)) continue;
                throw e;
            }
        }
        if (autoCommit) {
            this.changed(original, t);
            return;
        }
        if (!this.changedListeners.isEmpty()) {
            ChangeHolder.cache(new PreChangeCache(this, original, t));
        }
    }

    @Override
    public boolean save(T t) {
        return this.save(t, true);
    }

    @Override
    public boolean saveWithoutListener(T t) {
        return this.save(t, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save(T t, boolean enableListener) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            if (enableListener) {
                this.triggerDefaultListener(t, ORMType.INSERT);
            }
            Options options = this.getOptions();
            helper = SQLHelperCreator.insert(t, options);
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("SAVE : " + helper));
            }
            this.logger.debug((Object)("connection :" + conn));
            RdId rdId = null;
            if (helper.getIdValue() == null && helper.getIdField() != null) {
                rdId = helper.getIdField().getAnnotation(RdId.class);
            }
            ps = rdId != null && rdId.autoIncrement() ? conn.prepareStatement(helper.getSql(), 1) : conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(options, ps, helper.getParameters(), conn);
            boolean flag = ps.executeUpdate() > 0;
            try {
                if (rdId != null && rdId.autoIncrement()) {
                    ResultSet seqRs = ps.getGeneratedKeys();
                    if (seqRs.next()) {
                        Object key = seqRs.getObject(1);
                        helper.setId(t, key);
                    }
                    seqRs.close();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"not support.", (Throwable)e);
            }
            if (flag && enableListener) {
                this.triggerORMListener(t, ORMType.INSERT);
                this.triggerChangeListener(null, t, conn);
            }
            bl = flag;
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, SAVE: " + e.getMessage());
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e3);
                    throw new RuntimeException("QUERY_SQL_ERROR, SAVE Listener : " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                this.logger.debug((Object)("close connection :" + conn));
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        this.logger.debug((Object)("close connection :" + conn));
        return bl;
    }

    @Override
    public boolean update(T t) {
        return this.update(t, false, true, null);
    }

    @Override
    public boolean updateWithoutListener(T t) {
        return this.update(t, false, false, null);
    }

    @Override
    public boolean updateWithoutListener(T t, boolean updateNull) {
        return this.update(t, updateNull, false, null);
    }

    @Override
    public boolean update(T t, boolean updateNull) {
        return this.update(t, updateNull, true, null);
    }

    @Override
    public boolean updateNull(T t, String ... forNullColumns) {
        return this.update(t, false, true, forNullColumns);
    }

    @Override
    public boolean updateNullWithoutListener(T t, String ... forNullColumns) {
        return this.update(t, false, false, forNullColumns);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean update(T t, boolean updateNull, boolean enableListener, String[] nullColumns) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            conn = this.getConnection();
            if (enableListener) {
                this.triggerDefaultListener(t, ORMType.UPDATE);
            }
            helper = SQLHelperCreator.update(this.getOptions(), t, null, updateNull, nullColumns);
            T original = null;
            if (!(helper.getPair() == null || this.changeListeners.isEmpty() && this.changedListeners.isEmpty())) {
                original = (T)this.get(helper.getPair().getValue());
            }
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("UPDATE : " + helper));
            }
            this.logger.debug((Object)("connection :" + conn));
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && enableListener) {
                this.triggerORMListener(t, ORMType.UPDATE);
                this.triggerChangeListener(original, t, conn);
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, UPDATE: " + e.getMessage());
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e3);
                    throw new RuntimeException("QUERY_SQL_ERROR, UPDATE Listener : " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                this.logger.debug((Object)("close connection :" + conn));
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        this.logger.debug((Object)("close connection :" + conn));
        return bl;
    }

    @Override
    public boolean updates(T t, Expression ... expressions) {
        return this.updates(t, expressions, false, true, null);
    }

    @Override
    public boolean updatesWithoutListener(T t, Expression ... expressions) {
        return this.updates(t, expressions, false, false, null);
    }

    @Override
    public boolean updatesNull(T t, Expression ... expressions) {
        return this.updates(t, expressions, true, true, null);
    }

    @Override
    public boolean updatesNullWithoutListener(T t, Expression ... expressions) {
        return this.updates(t, expressions, true, false, null);
    }

    @Override
    public boolean updatesNull(T t, String[] forNullColumns, Expression ... expressions) {
        return this.updates(t, expressions, false, true, forNullColumns);
    }

    @Override
    public boolean updatesNullWithoutListener(T t, String[] forNullColumns, Expression ... expressions) {
        return this.updates(t, expressions, false, false, forNullColumns);
    }

    private Expression[] fromExpress(Express ... expresses) {
        Expression[] expressions = null;
        if (expresses != null) {
            expressions = new Expression[expresses.length];
            for (int i = 0; i < expresses.length; ++i) {
                Express express = expresses[i];
                expressions[i] = express;
            }
        }
        return expresses;
    }

    @Override
    @Deprecated
    public boolean updates(T t, Express ... expresses) {
        return this.updates(t, this.fromExpress(expresses), false, true, null);
    }

    @Override
    @Deprecated
    public boolean updatesWithoutListener(T t, Express ... expresses) {
        return this.updates(t, this.fromExpress(expresses), false, false, null);
    }

    @Override
    @Deprecated
    public boolean updatesNull(T t, Express ... expresses) {
        return this.updates(t, this.fromExpress(expresses), true, true, null);
    }

    @Override
    @Deprecated
    public boolean updatesNullWithoutListener(T t, Express ... expresses) {
        return this.updates(t, this.fromExpress(expresses), true, false, null);
    }

    @Override
    @Deprecated
    public boolean updatesNull(T t, String[] forNullColumns, Express ... expresses) {
        return this.updates(t, this.fromExpress(expresses), false, true, forNullColumns);
    }

    @Override
    @Deprecated
    public boolean updatesNullWithoutListener(T t, String[] forNullColumns, Express ... expresses) {
        return this.updates(t, this.fromExpress(expresses), false, false, forNullColumns);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updates(T t, Expression[] expressions, boolean updateNull, boolean enableListener, String[] forNullColumns) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            conn = this.getConnection();
            helper = SQLHelperCreator.update(this.getOptions(), t, expressions, updateNull, forNullColumns);
            List<T> originals = null;
            if (!(helper.getIdValue() != null || helper.getIdField() == null || expressions == null || expressions.length <= 0 || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty())) {
                originals = this.list(expressions);
            }
            if (enableListener && originals != null) {
                for (Object row : originals) {
                    this.triggerDefaultListener(row, ORMType.UPDATE);
                }
            }
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("UPDATE : " + helper));
            }
            this.logger.debug((Object)("connection :" + conn));
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && enableListener && originals != null) {
                for (T original : originals) {
                    Object idValue = ORMUtils.getFieldValue(original, helper.getIdField());
                    ORMUtils.setFieldValue(t, helper.getIdField(), idValue);
                    this.triggerORMListener(t, ORMType.UPDATE);
                    this.triggerChangeListener(original, t, conn);
                }
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, UPDATE: " + e.getMessage());
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e3);
                    throw new RuntimeException("QUERY_SQL_ERROR, UPDATE Listener : " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                this.logger.debug((Object)("close connection :" + conn));
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        this.logger.debug((Object)("close connection :" + conn));
        return bl;
    }

    @Override
    public boolean updates(T t, Condition condition) {
        return this.updates(t, condition, false, true, null);
    }

    @Override
    public boolean updatesWithoutListener(T t, Condition condition) {
        return this.updates(t, condition, false, false, null);
    }

    @Override
    public boolean updatesNull(T t, Condition condition) {
        return this.updates(t, condition, true, true, null);
    }

    @Override
    public boolean updatesNullWithoutListener(T t, Condition condition) {
        return this.updates(t, condition, true, false, null);
    }

    @Override
    public boolean updatesNull(T t, String[] forNullColumns, Condition condition) {
        return this.updates(t, condition, false, true, forNullColumns);
    }

    @Override
    public boolean updatesNullWithoutListener(T t, String[] forNullColumns, Condition condition) {
        return this.updates(t, condition, false, false, forNullColumns);
    }

    @Override
    @Deprecated
    public boolean updatesWithoutListener(Express[] values, Express[] conditions) {
        return this.updatesWithoutListener(this.fromExpress(values), this.fromExpress(conditions));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updatesWithoutListener(Expression[] values, Expression[] conditions) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            conn = this.getConnection();
            helper = SQLHelperCreator.updateExpress(this.thisClass, this.getOptions(), values, conditions);
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("UPDATE : " + helper));
            }
            this.logger.debug((Object)("connection :" + conn));
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            bl = result = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("updatesWithoutListener, UPDATES: " + e.getMessage());
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e3);
                    throw new RuntimeException("updatesWithoutListener, UPDATES Listener : " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                this.logger.debug((Object)("close connection :" + conn));
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        this.logger.debug((Object)("close connection :" + conn));
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updates(T t, Condition condition, boolean updateNull, boolean enableListener, String[] forNullColumns) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            conn = this.getConnection();
            helper = SQLHelperCreator.updateTerms(this.getOptions(), t, condition, updateNull, forNullColumns);
            List<T> originals = null;
            if (!(helper.getIdValue() != null || helper.getIdField() == null || condition == null || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty())) {
                originals = this.list(condition);
            }
            if (enableListener && originals != null) {
                for (Object row : originals) {
                    this.triggerDefaultListener(row, ORMType.UPDATE);
                }
            }
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("UPDATE : " + helper));
            }
            this.logger.debug((Object)("connection :" + conn));
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && enableListener && originals != null) {
                for (T original : originals) {
                    Object idValue = ORMUtils.getFieldValue(original, helper.getIdField());
                    ORMUtils.setFieldValue(t, helper.getIdField(), idValue);
                    this.triggerORMListener(t, ORMType.UPDATE);
                    this.triggerChangeListener(original, t, conn);
                }
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, UPDATE: " + e.getMessage());
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e3);
                    throw new RuntimeException("QUERY_SQL_ERROR, UPDATE Listener : " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                this.logger.debug((Object)("close connection :" + conn));
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        this.logger.debug((Object)("close connection :" + conn));
        return bl;
    }

    @Override
    public boolean delete(Object t) {
        return this.delete(t, true);
    }

    @Override
    public boolean deleteWithoutListener(Object object) {
        return this.delete(object, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean delete(Object t, boolean enableListener) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            Object now = null;
            conn = this.getConnection();
            if (this.thisClass.isInstance(t)) {
                helper = SQLHelperCreator.delete(t);
                now = t;
            } else {
                helper = SQLHelperCreator.delete(this.thisClass, t);
                if (!(!enableListener || helper.getPair() == null || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty())) {
                    now = this.get(helper.getPair().getValue());
                }
            }
            if (enableListener) {
                this.triggerDefaultListener(now, ORMType.DELETE);
            }
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("DELETE : " + helper));
            }
            this.logger.debug((Object)("connection :" + conn));
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && enableListener) {
                this.triggerORMListener(now, ORMType.DELETE);
                this.triggerChangeListener(now, null, conn);
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, DELETE : " + e.getMessage());
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e3);
                    throw new RuntimeException("QUERY_SQL_ERROR, DELETE : " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                this.logger.debug((Object)("close connection :" + conn));
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        this.logger.debug((Object)("close connection :" + conn));
        return bl;
    }

    @Override
    public boolean deletes(Condition condition) {
        return this.deletes(true, condition);
    }

    @Override
    public boolean deletesWithoutListener(Condition condition) {
        return this.deletes(false, condition);
    }

    @Override
    public boolean deletes(Expression ... expressions) {
        return this.deletes(true, expressions);
    }

    @Override
    public boolean deletesWithoutListener(Expression ... expressions) {
        return this.deletes(false, expressions);
    }

    @Override
    @Deprecated
    public boolean deletes(Express ... expresses) {
        return this.deletes(true, this.fromExpress(expresses));
    }

    @Override
    @Deprecated
    public boolean deletesWithoutListener(Express ... expresses) {
        return this.deletes(false, this.fromExpress(expresses));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deletes(boolean enableListener, Condition condition) {
        boolean bl;
        if (condition == null) {
            throw new RuntimeException("TABLE_DELETE_WITHOUT_EXPRESS, DELETE(Conditions) : " + this.thisClass);
        }
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            List<T> nows = null;
            conn = this.getConnection();
            helper = SQLHelperCreator.deleteBy(this.thisClass, this.getOptions(), condition);
            if (!(!enableListener || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty() || (nows = this.list(condition)) == null)) {
                for (T t : nows) {
                    this.triggerDefaultListener(t, ORMType.DELETE);
                }
            }
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("DELETE(Express): " + helper));
            }
            this.logger.debug((Object)("connection :" + conn));
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && nows != null) {
                for (T t : nows) {
                    this.triggerORMListener(t, ORMType.DELETE);
                    this.triggerChangeListener(t, null, conn);
                }
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, DELETE(Terms) : " + e.getMessage());
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e3);
                    throw new RuntimeException("QUERY_SQL_ERROR, DELETE(Terms) : " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                this.logger.debug((Object)("close connection :" + conn));
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        this.logger.debug((Object)("close connection :" + conn));
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deletes(boolean enableListener, Expression ... expressions) {
        boolean bl;
        if (expressions == null || expressions.length == 0) {
            throw new RuntimeException("TABLE_DELETE_WITHOUT_EXPRESS, DELETE(Expressions) : " + this.thisClass);
        }
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            List<T> nows = null;
            conn = this.getConnection();
            helper = SQLHelperCreator.deleteBy(this.thisClass, this.getOptions(), expressions);
            if (!(!enableListener || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty() || (nows = this.list(expressions)) == null)) {
                for (T t : nows) {
                    this.triggerDefaultListener(t, ORMType.DELETE);
                }
            }
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("DELETE(Express): " + helper));
            }
            this.logger.debug((Object)("connection :" + conn));
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && nows != null) {
                for (T t : nows) {
                    this.triggerORMListener(t, ORMType.DELETE);
                    this.triggerChangeListener(t, null, conn);
                }
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, DELETE(Express) : " + e.getMessage());
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e3);
                    throw new RuntimeException("QUERY_SQL_ERROR, DELETE(Express) : " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                this.logger.debug((Object)("close connection :" + conn));
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        this.logger.debug((Object)("close connection :" + conn));
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> list() {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.getOptions().doQuery(this.thisClass, null, null, null, null, null);
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("list() : " + helper));
            }
            ps = conn.prepareStatement(helper.getSql());
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, LIST: " + e.getMessage());
                catch (IllegalAccessException e2) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, LIST: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> listNames(String ... names) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.getOptions().doQuery(this.thisClass, names, null, null, null, null);
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("list() : " + helper));
            }
            ps = conn.prepareStatement(helper.getSql());
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, LIST: " + e.getMessage());
                catch (IllegalAccessException e2) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, LIST: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> list(int start, int size) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.getOptions().doQuery(this.thisClass, null, null, null, start, size);
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("list(start,size) : " + helper));
            }
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, LIST(Start,Size): " + e.getMessage());
                catch (IllegalAccessException e2) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, List(Start,Size): " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    @Override
    @Deprecated
    public List<T> list(Express ... expresses) {
        return this.list(this.fromExpress(expresses));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> list(Expression ... expressions) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = SQLHelperCreator.query(this.getOptions(), this.thisClass, expressions);
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("list(expresses) : " + helper));
            }
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, ListExpress: " + e.getMessage());
                catch (IllegalAccessException e2) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, ListExpress: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    @Override
    public List<T> list(Condition condition) {
        return this.list(null, condition, null, null);
    }

    @Override
    public List<T> list(Condition condition, MultiOrder multiOrder) {
        return this.list(null, condition, multiOrder, null);
    }

    @Override
    public List<T> list(Condition condition, MultiOrder multiOrder, Integer limit) {
        return this.list(null, condition, multiOrder, limit);
    }

    @Override
    public List<T> list(Names names, Condition condition) {
        return this.list(names, condition, null, null);
    }

    @Override
    public List<T> list(Names names, Condition condition, MultiOrder multiOrder) {
        return this.list(names, condition, multiOrder, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> list(Names names, Condition condition, MultiOrder multiOrder, Integer limit) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.getOptions().doQuery(this.thisClass, names != null ? names.names() : null, condition, multiOrder, null, limit);
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("list(names, terms, multiOrder, limit) : " + helper));
            }
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, ListTerm: " + e.getMessage());
                catch (IllegalAccessException e2) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, ListTerm: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    @Override
    public boolean exists(Condition condition) {
        Connection conn;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            boolean bl;
            ps = null;
            rs = null;
            conn = null;
            SQLHelper helper = null;
            try {
                Object tmp;
                conn = this.getConnection();
                helper = SQLHelperCreator.queryCount(this.getOptions(), this.thisClass, condition);
                if (ORMUtils.getDebug()) {
                    this.logger.info((Object)("exists : " + helper));
                }
                ps = conn.prepareStatement(helper.getSql());
                SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
                rs = ps.executeQuery();
                if (!rs.next() || (tmp = rs.getObject(1)) == null) break block5;
                bl = Integer.parseInt(tmp.toString()) > 0;
            }
            catch (SQLException e) {
                try {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                    throw new RuntimeException("QUERY_SQL_ERROR, Exists: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    this.closeConnection(rs, ps, conn);
                    throw throwable;
                }
            }
            this.closeConnection(rs, ps, conn);
            return bl;
        }
        this.closeConnection(rs, ps, conn);
        return false;
    }

    @Override
    @Deprecated
    public boolean exists(Express ... expresses) {
        return this.exists(this.fromExpress(expresses));
    }

    @Override
    public boolean exists(Expression ... expressions) {
        Connection conn;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            boolean bl;
            ps = null;
            rs = null;
            conn = null;
            SQLHelper helper = null;
            try {
                Object tmp;
                conn = this.getConnection();
                helper = SQLHelperCreator.queryCountExpress(this.getOptions(), this.thisClass, expressions);
                if (ORMUtils.getDebug()) {
                    this.logger.info((Object)("exists : " + helper));
                }
                ps = conn.prepareStatement(helper.getSql());
                SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
                rs = ps.executeQuery();
                if (!rs.next() || (tmp = rs.getObject(1)) == null) break block5;
                bl = Integer.parseInt(tmp.toString()) > 0;
            }
            catch (SQLException e) {
                try {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                    throw new RuntimeException("QUERY_SQL_ERROR, Exists: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    this.closeConnection(rs, ps, conn);
                    throw throwable;
                }
            }
            this.closeConnection(rs, ps, conn);
            return bl;
        }
        this.closeConnection(rs, ps, conn);
        return false;
    }

    @Override
    @Deprecated
    public int count(Express ... expresses) {
        return this.count(this.fromExpress(expresses));
    }

    @Override
    public int count(Expression ... expressions) {
        Connection conn;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            int n;
            ps = null;
            rs = null;
            conn = null;
            SQLHelper helper = null;
            try {
                Object tmp;
                conn = this.getConnection();
                helper = SQLHelperCreator.queryCountExpress(this.getOptions(), this.thisClass, expressions);
                if (ORMUtils.getDebug()) {
                    this.logger.info((Object)("Count : " + helper));
                }
                ps = conn.prepareStatement(helper.getSql());
                SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
                rs = ps.executeQuery();
                if (!rs.next() || (tmp = rs.getObject(1)) == null) break block5;
                n = Integer.parseInt(tmp.toString());
            }
            catch (SQLException e) {
                try {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                    throw new RuntimeException("QUERY_SQL_ERROR, COUNT : " + e.getMessage());
                }
                catch (Throwable throwable) {
                    this.closeConnection(rs, ps, conn);
                    throw throwable;
                }
            }
            this.closeConnection(rs, ps, conn);
            return n;
        }
        this.closeConnection(rs, ps, conn);
        return 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <S> S getQuery(IQuery query) {
        S s = null;
        Connection conn = this.getConnection();
        query.setOptions(this.getOptions());
        this.triggerQueryListener(query);
        if (!query.dataPermission()) {
            this.closeConnection(null, null, conn);
            return null;
        }
        QueryInfo qinfo = this.getOptions().doQuery(query, null);
        if (ORMUtils.getDebug()) {
            this.logger.info((Object)("list:" + qinfo));
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(qinfo.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                s = (S)SQLHelperCreator.newClass(qinfo.getClazz(), rs, this.getResultSetHandler());
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.logger.error((Object)("SQL : " + qinfo), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, SQL[" + qinfo.getSql() + "]" + e.getMessage());
                catch (SecurityException e2) {
                    this.logger.error((Object)("SQL : " + qinfo), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_SECURITY, SQL[" + qinfo.getSql() + "]" + e2.getMessage());
                }
                catch (IllegalAccessException e3) {
                    this.logger.error((Object)("SQL : " + qinfo), (Throwable)e3);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, SQL[" + qinfo.getSql() + "]" + e3.getMessage());
                }
                catch (IllegalArgumentException e4) {
                    this.logger.error((Object)("SQL : " + qinfo), (Throwable)e4);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ARGUMENT, SQL[" + qinfo.getSql() + "]" + e4.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return s;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <S> S get(Object t) {
        if (t == null) {
            return null;
        }
        if (IQuery.class.isAssignableFrom(t.getClass())) {
            return this.getQuery((IQuery)t);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        S temp = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.thisClass.isInstance(t) ? SQLHelperCreator.get(t, new String[0]) : SQLHelperCreator.get(this.thisClass, t);
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("GET : " + helper));
            }
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                temp = (S)SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + helper), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, GET: " + e.getMessage());
                catch (IllegalAccessException e2) {
                    this.logger.error((Object)("SQL : " + helper), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, GET: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    @Override
    public <S> List<S> query(IQuery q) {
        return this.innerQuery(q);
    }

    @Override
    public <S> List<S> query(IQuery q, int size) {
        Pageable page = new Pageable();
        page.setPage(1);
        page.setSize(size);
        q.setPageable(page);
        return this.innerQuery(q);
    }

    @Override
    public <S> List<S> query(IQuery q, int offset, int size) {
        Pageable page = new Pageable();
        page.setSize(size);
        page.setOffset(offset);
        q.setPageable(page);
        return this.innerQuery(q);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <S> List<S> innerQuery(IQuery q) {
        ArrayList temp = new ArrayList();
        Connection conn = this.getConnection();
        q.setOptions(this.getOptions());
        this.triggerQueryListener(q);
        if (!q.dataPermission()) {
            this.closeConnection(null, null, conn);
            return temp;
        }
        QueryInfo qinfo = q.doQuery();
        if (ORMUtils.getDebug()) {
            this.logger.info((Object)("list:" + qinfo));
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(qinfo.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object t = SQLHelperCreator.newClass(qinfo.getClazz(), rs, this.getResultSetHandler());
                temp.add(t);
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("SQL : " + qinfo), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, SQL[" + qinfo.getSql() + "]" + e.getMessage());
                catch (SecurityException e2) {
                    this.logger.error((Object)("SQL : " + qinfo), (Throwable)e2);
                    throw new RuntimeException("QUERY_SQL_SECURITY, SQL[" + qinfo.getSql() + "]" + e2.getMessage());
                }
                catch (IllegalAccessException e3) {
                    this.logger.error((Object)("SQL : " + qinfo), (Throwable)e3);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, SQL[" + qinfo.getSql() + "]" + e3.getMessage());
                }
                catch (IllegalArgumentException e4) {
                    this.logger.error((Object)("SQL : " + qinfo), (Throwable)e4);
                    throw new RuntimeException("QUERY_SQL_ILLEGAL_ARGUMENT, SQL[" + qinfo.getSql() + "]" + e4.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    @Override
    public int queryCount(IQuery q) {
        int count = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        QueryInfo qinfo = null;
        try {
            conn = this.getConnection();
            q.setOptions(this.getOptions());
            this.triggerQueryListener(q);
            if (!q.dataPermission()) {
                this.closeConnection(null, null, conn);
                int n = count;
                return n;
            }
            qinfo = q.doQueryCount();
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("list:" + qinfo));
            }
            String query = qinfo.getSql();
            ps = conn.prepareStatement(query);
            SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            this.logger.error((Object)("SQL : " + qinfo), (Throwable)e);
            throw new RuntimeException("QUERY_SQL_ERROR, SQL[" + qinfo.getSql() + "]" + e.getMessage());
        }
        catch (SecurityException e) {
            this.logger.error((Object)("SQL : " + qinfo), (Throwable)e);
            throw new RuntimeException("QUERY_SQL_SECURITY, SQL[" + qinfo.getSql() + "]" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Object)("SQL : " + qinfo), (Throwable)e);
            throw new RuntimeException("QUERY_SQL_ILLEGAL_ARGUMENT, SQL[" + qinfo.getSql() + "]" + e.getMessage());
        }
        finally {
            this.closeConnection(rs, ps, conn);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <S> Pageable<S> queryPage(IQuery query, Pageable page) {
        int total;
        ArrayList temp;
        block23: {
            if (page == null) {
                page = new Pageable();
            }
            query.setPageable(page);
            temp = new ArrayList();
            Connection conn = this.getConnection();
            query.setOptions(this.getOptions());
            this.triggerQueryListener(query);
            if (!query.dataPermission()) {
                page.setRows(temp);
                page.setTotal(temp.size());
                this.closeConnection(null, null, conn);
                return page;
            }
            QueryInfo qinfo = query.doQuery();
            if (ORMUtils.getDebug()) {
                this.logger.info((Object)("list:" + qinfo));
            }
            PreparedStatement ps = null;
            ResultSet rs = null;
            total = 0;
            try {
                ps = conn.prepareStatement(qinfo.getSql());
                SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
                rs = ps.executeQuery();
                while (rs.next()) {
                    Object t = SQLHelperCreator.newClass(qinfo.getClazz(), rs, this.getResultSetHandler());
                    temp.add(t);
                }
            }
            finally {
                this.closeConnection(null, null, conn);
            }
            this.closeConnection(rs, ps, null);
            try {
                qinfo = query.doQueryCount();
                if (ORMUtils.getDebug()) {
                    this.logger.info((Object)("list:" + qinfo));
                }
                String countSQL = qinfo.getSql();
                ps = conn.prepareStatement(countSQL);
                SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
                rs = ps.executeQuery();
                if (rs.next()) {
                    total = rs.getInt(1);
                }
                break block23;
            }
            catch (SQLException e) {
                this.logger.error((Object)("SQL : " + qinfo), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ERROR, SQL[" + qinfo.getSql() + "]" + e.getMessage());
            }
            catch (SecurityException e) {
                this.logger.error((Object)("SQL : " + qinfo), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_SECURITY, SQL[" + qinfo.getSql() + "]" + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("SQL : " + qinfo), (Throwable)e);
                throw new RuntimeException("QUERY_SQL_ILLEGAL_ARGUMENT, SQL[" + qinfo.getSql() + "]" + e.getMessage());
            }
            catch (SQLException e) {
                try {
                    this.logger.error((Object)("SQL : " + qinfo), (Throwable)e);
                    throw new RuntimeException("QUERY_SQL_ERROR, SQL[" + qinfo.getSql() + "]" + e.getMessage());
                    catch (SecurityException e2) {
                        this.logger.error((Object)("SQL : " + qinfo), (Throwable)e2);
                        throw new RuntimeException("QUERY_SQL_SECURITY, SQL[" + qinfo.getSql() + "]" + e2.getMessage());
                    }
                    catch (IllegalAccessException e3) {
                        this.logger.error((Object)("SQL : " + qinfo), (Throwable)e3);
                        throw new RuntimeException("QUERY_SQL_ILLEGAL_ACCESS, SQL[" + qinfo.getSql() + "]" + e3.getMessage());
                    }
                    catch (IllegalArgumentException e4) {
                        this.logger.error((Object)("SQL : " + qinfo), (Throwable)e4);
                        throw new RuntimeException("QUERY_SQL_ILLEGAL_ARGUMENT, SQL[" + qinfo.getSql() + "]" + e4.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    this.closeConnection(rs, ps, null);
                    throw throwable;
                }
            }
            finally {
                this.closeConnection(rs, ps, null);
            }
        }
        page.setRows(temp);
        page.setTotal(total);
        return page;
    }

    @Override
    public String tableName() throws ORMException {
        return super.getTableName(this.thisClass);
    }

    @Override
    public void createOrUpdate() throws ORMException {
        super.createOrUpdate(this.thisClass);
    }
}

