/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.option;

import com.ursful.framework.orm.IMultiQuery;
import com.ursful.framework.orm.IQuery;
import com.ursful.framework.orm.annotation.RdColumn;
import com.ursful.framework.orm.annotation.RdForeignKey;
import com.ursful.framework.orm.annotation.RdId;
import com.ursful.framework.orm.annotation.RdTable;
import com.ursful.framework.orm.annotation.RdUniqueKey;
import com.ursful.framework.orm.exception.ORMException;
import com.ursful.framework.orm.helper.SQLHelper;
import com.ursful.framework.orm.option.AbstractOptions;
import com.ursful.framework.orm.query.QueryUtils;
import com.ursful.framework.orm.support.ColumnInfo;
import com.ursful.framework.orm.support.ColumnType;
import com.ursful.framework.orm.support.Condition;
import com.ursful.framework.orm.support.DataType;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.MultiOrder;
import com.ursful.framework.orm.support.OperatorType;
import com.ursful.framework.orm.support.Pageable;
import com.ursful.framework.orm.support.Pair;
import com.ursful.framework.orm.support.QueryInfo;
import com.ursful.framework.orm.support.SQLPair;
import com.ursful.framework.orm.support.Table;
import com.ursful.framework.orm.support.TableColumn;
import com.ursful.framework.orm.support.TextTransformType;
import com.ursful.framework.orm.utils.ORMUtils;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OracleOptions
extends AbstractOptions {
    @Override
    public String keyword() {
        return "oracle";
    }

    @Override
    public boolean preSetParameter(PreparedStatement ps, Connection connection, String databaseType, int i, Pair pair) throws SQLException {
        Object obj = pair.getValue();
        ColumnType columnType = pair.getColumnType();
        DataType type = DataType.getDataType(pair.getType());
        boolean hasSet = false;
        switch (type) {
            case STRING: {
                if (columnType == ColumnType.BLOB) {
                    if (obj != null) {
                        try {
                            ps.setBinaryStream(i + 1, new ByteArrayInputStream(obj.toString().getBytes(this.getCoding(pair))));
                            hasSet = true;
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    ps.setBinaryStream(i + 1, null);
                    break;
                }
                if (columnType != ColumnType.CLOB) break;
                try {
                    Clob oracleClob = (Clob)OracleOptions.createOracleLob(connection, "oracle.sql.CLOB");
                    ps.setClob(i + 1, OracleOptions.oracleStr2Clob(obj.toString(), oracleClob));
                    hasSet = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case DOUBLE: {
                ps.setDouble(i + 1, (Double)obj);
                hasSet = true;
                break;
            }
        }
        return hasSet;
    }

    public static Object createOracleLob(Connection conn, String lobClassName) throws Exception {
        Class<?> lobClass = conn.getClass().getClassLoader().loadClass(lobClassName);
        Integer DURATION_SESSION = lobClass.getField("DURATION_SESSION").getInt(null);
        Integer MODE_READWRITE = lobClass.getField("MODE_READWRITE").getInt(null);
        Method createTemporary = lobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
        Object lob = createTemporary.invoke(null, conn, false, DURATION_SESSION);
        Method open = lobClass.getMethod("open", Integer.TYPE);
        open.invoke(lob, MODE_READWRITE);
        return lob;
    }

    public static Clob oracleStr2Clob(String str, Clob lob) throws Exception {
        Method methodToInvoke = lob.getClass().getMethod("getCharacterOutputStream", null);
        Writer writer = (Writer)methodToInvoke.invoke((Object)lob, (Object[])null);
        writer.write(str);
        writer.close();
        return lob;
    }

    @Override
    public String getColumnWithOperator(OperatorType operatorType, String name, String value) {
        String result = null;
        switch (operatorType) {
            case AND: {
                result = "BITAND(" + name + "," + value + ")";
                break;
            }
            case OR: {
                result = "(" + name + "+" + value + " - BITAND(" + name + "," + value + "))";
                break;
            }
            case XOR: {
                result = "(" + name + "+" + value + " - 2*BITAND(" + name + "," + value + "))";
                break;
            }
            case NOT: {
                result = "(" + name + "-1 - 2*BITAND(" + name + ", -1))";
                break;
            }
            case LL: {
                result = "(" + name + "*POWER(2," + value + "))";
                break;
            }
            case RR: {
                result = "FLOOR(" + name + "/POWER(2," + value + ")";
                break;
            }
            case MOD: {
                result = "MOD(" + name + "," + value + ")";
            }
        }
        return result;
    }

    @Override
    public String getColumnWithOperatorAndFunction(String function, boolean inFunction, OperatorType operatorType, String name, String value) {
        String result = null;
        switch (operatorType) {
            case AND: {
                if (inFunction) {
                    result = function + "(BITAND(" + name + "," + value + "))";
                    break;
                }
                result = "BITAND(" + function + "(" + name + ")," + value + ")";
                break;
            }
            case OR: {
                if (inFunction) {
                    result = function + "(" + name + "+" + value + " - BITAND(" + name + "," + value + "))";
                    break;
                }
                result = "(" + function + "(" + name + ")+" + value + " - BITAND(" + function + "(" + name + ")," + value + "))";
                break;
            }
            case XOR: {
                if (inFunction) {
                    result = function + "(" + name + "+" + value + " - 2*BITAND(" + name + "," + value + "))";
                    break;
                }
                result = "(" + function + "(" + name + ")+" + value + " - 2*BITAND(" + function + "(" + name + ")," + value + "))";
                break;
            }
            case NOT: {
                if (inFunction) {
                    result = function + "(" + name + "-1 - 2*BITAND(" + name + ", -1))";
                    break;
                }
                result = "(" + function + "(" + name + ")-1 - 2*BITAND(" + function + "(" + name + "), -1))";
                break;
            }
            case LL: {
                if (inFunction) {
                    result = function + "(" + name + "*POWER(2," + value + "))";
                    break;
                }
                result = "(" + function + "(" + name + ")*POWER(2," + value + "))";
                break;
            }
            case RR: {
                if (inFunction) {
                    result = function + "(FLOOR(" + name + "/POWER(2," + value + "))";
                    break;
                }
                result = "FLOOR(" + function + "(" + name + ")/POWER(2," + value + ")";
                break;
            }
            case MOD: {
                result = inFunction ? function + "(MOD(" + name + "," + value + "))" : "MOD(" + function + "(" + name + ")," + value + ")";
            }
        }
        if (result == null) {
            result = inFunction ? function + "(" + name + operatorType.getOperator() + value + ")" : "(" + function + "(" + name + ")" + operatorType.getOperator() + value + ")";
        }
        return result;
    }

    @Override
    public String databaseType() {
        return "Oracle";
    }

    @Override
    public String nanoTimeSQL() {
        return "SELECT SYSTIMESTAMP FROM DUAL";
    }

    private List<String> tableConstraints(Connection connection) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            String sql = "SELECT CONSTRAINT_NAME AS INDEX_NAME FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'R'  OR CONSTRAINT_TYPE = 'U' OR CONSTRAINT_TYPE = 'P'";
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null) continue;
                names.add(indexName.toUpperCase(Locale.ROOT));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return names;
    }

    @Override
    public QueryInfo doQuery(IQuery query, Pageable page) {
        boolean hasOrder;
        QueryInfo info = new QueryInfo();
        ArrayList<Pair> values = new ArrayList<Pair>();
        StringBuffer sb = new StringBuffer();
        String alias = "ora_";
        sb.append("SELECT ");
        HashMap<String, String> asNames = new HashMap<String, String>();
        String group = this.groups(query, null);
        if (!ORMUtils.isEmpty(group)) {
            alias = null;
        }
        sb.append(this.selectColumns(query, alias, asNames));
        String order = this.orders(query, alias, asNames);
        boolean bl = hasOrder = !ORMUtils.isEmpty(order);
        if (page != null && !hasOrder && ORMUtils.isEmpty(group)) {
            sb.append(",ROWNUM rn_ ");
        }
        sb.append(" FROM ");
        sb.append(this.tables(query, values, alias));
        if (query instanceof IMultiQuery) {
            sb.append(this.joins((IMultiQuery)query, values));
        }
        int now = sb.length();
        sb.append(this.wheres(query, values, null));
        int then = sb.length();
        boolean hasCondition = then > now;
        sb.append(group);
        sb.append(this.havings(query, values, null));
        sb.append(order);
        if (page != null) {
            sb = hasOrder || !ORMUtils.isEmpty(group) ? new StringBuffer("SELECT ora_a_.* FROM (SELECT ora_b_.*,ROWNUM rn_  FROM (" + sb.toString() + ") ora_b_ WHERE ROWNUM <= ?) ora_a_ WHERE ora_a_.rn_ > ? ") : new StringBuffer("SELECT ora_a_.* FROM (" + sb.toString() + (hasCondition ? " AND " : " WHERE ") + "ROWNUM <= ? ) ora_a_ WHERE ora_a_.rn_ > ? ");
            values.add(new Pair(new Integer(page.getSize() + page.getOffset())));
            values.add(new Pair(new Integer(page.getOffset())));
        }
        info.setClazz(query.getReturnClass());
        info.setSql(sb.toString());
        info.setValues(values);
        info.setColumns(query.getReturnColumns());
        if (TextTransformType.LOWER == query.textTransformType()) {
            info.setSql(info.getSql().toLowerCase(Locale.ROOT));
        } else if (TextTransformType.UPPER == query.textTransformType()) {
            info.setSql(info.getSql().toUpperCase(Locale.ROOT));
        }
        return info;
    }

    @Override
    public SQLHelper doQuery(Class<?> clazz, String[] names, Condition condition, MultiOrder multiOrder, Integer start, Integer size) {
        String alias = "ora_";
        if (names != null) {
            String[] tempNames = new String[names.length];
            for (int i = 0; i < tempNames.length; ++i) {
                tempNames[i] = alias + "." + names[i];
            }
            names = tempNames;
        }
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("SELECT ");
        String nameStr = ORMUtils.join(names, ",");
        if (ORMUtils.isEmpty(nameStr)) {
            sql.append(alias + "." + "*");
        } else {
            sql.append(nameStr);
        }
        boolean hasOrder = false;
        String order = "";
        if (multiOrder != null) {
            QueryUtils.setMultiOrderAlias(multiOrder, alias);
            String orders = this.getOrders(multiOrder.getOrders(), clazz);
            if (!ORMUtils.isEmpty(orders)) {
                hasOrder = true;
                order = " ORDER BY " + orders;
            }
        }
        if (start != null && size != null && !hasOrder) {
            sql.append(",ROWNUM rn_ ");
        }
        sql.append(" FROM " + tableName + " " + alias);
        ArrayList<Pair> values = new ArrayList<Pair>();
        boolean hasCondition = false;
        if (condition != null) {
            QueryUtils.setConditionAlias(condition, alias);
            String conditions = this.getConditions(clazz, ORMUtils.newList(condition), values);
            if (!ORMUtils.isEmpty(conditions)) {
                sql.append(" WHERE " + conditions);
                hasCondition = true;
            }
        }
        sql.append(order);
        if (size != null && size > 0) {
            if (start == null) {
                start = 0;
            }
            sql = hasOrder ? new StringBuffer("SELECT ora_a_.* FROM (SELECT ora_b_.*,ROWNUM rn_ FROM (" + sql.toString() + ") ora_b_ WHERE ROWNUM <= ?) ora_a_ WHERE ora_a_.rn_ > ? ") : new StringBuffer("SELECT ora_a_.* FROM (" + sql.toString() + (hasCondition ? " AND " : " WHERE ") + " ROWNUM <= ? ) ora_a_ WHERE ora_a_.rn_ > ? ");
            values.add(new Pair(Math.max(1, start) * size));
            values.add(new Pair((Math.max(1, start) - 1) * size));
        }
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(values);
        return helper;
    }

    @Override
    public boolean tableExists(Connection connection, String tableName) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT * FROM USER_TABLES WHERE  TABLE_NAME = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public String getCaseSensitive(String name, int sensitive) {
        if (name == null) {
            return name;
        }
        if (2 == sensitive) {
            return name.toLowerCase(Locale.ROOT);
        }
        if (1 == sensitive) {
            return name.toUpperCase(Locale.ROOT);
        }
        if (3 == sensitive) {
            return name;
        }
        return name.toUpperCase(Locale.ROOT);
    }

    @Override
    public List<Table> tables(Connection connection, String keyword) {
        String sql;
        ArrayList<Table> temp = new ArrayList<Table>();
        Statement ps = null;
        ResultSet rs = null;
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            sql = "SELECT TABLE_NAME,COMMENTS FROM USER_TAB_COMMENTS ";
            if (!ORMUtils.isEmpty(keyword)) {
                sql = sql + "WHERE TABLE_NAME LIKE ? ";
            }
            ps = connection.prepareStatement(sql);
            if (!ORMUtils.isEmpty(keyword)) {
                ps.setString(1, "%" + keyword + "%");
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                info.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            sql = "SELECT TABLE_NAME FROM USER_TABLES";
            if (!ORMUtils.isEmpty(keyword)) {
                sql = sql + "WHERE TABLE_NAME LIKE ? ";
            }
            ps = connection.prepareStatement(sql);
            if (!ORMUtils.isEmpty(keyword)) {
                ps.setString(1, "%" + keyword + "%");
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                temp.add(new Table(tableName, (String)info.get(tableName)));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return temp;
    }

    @Override
    public Table table(Connection connection, RdTable rdTable) throws ORMException {
        String tableName = this.getTableName(rdTable);
        return this.table(connection, tableName);
    }

    @Override
    public Table table(Connection connection, String tableName) {
        String sql;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Table table = null;
        try {
            sql = "SELECT TABLE_NAME FROM USER_TABLES WHERE  TABLE_NAME = ? ";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                table = new Table();
                table.setName(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (table != null) {
            try {
                sql = "SELECT COMMENTS FROM USER_TAB_COMMENTS WHERE  TABLE_NAME = ?";
                ps = connection.prepareStatement(sql);
                ps.setString(1, tableName);
                rs = ps.executeQuery();
                if (rs.next()) {
                    table.setComment(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return table;
    }

    @Override
    public List<TableColumn> columns(Connection connection, RdTable rdTable) throws ORMException {
        String cname;
        String sql;
        String tableName = this.getTableName(rdTable);
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, String> columnComment = new HashMap<String, String>();
        try {
            sql = "SELECT COLUMN_NAME,COMMENTS FROM USER_COL_COMMENTS WHERE TABLE_NAME = ? ";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            while (rs.next()) {
                cname = rs.getString(1);
                if (rdTable.sensitive() == 0 && cname != null) {
                    cname = cname.toUpperCase(Locale.ROOT);
                }
                columnComment.put(cname, rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            sql = " SELECT TABLE_NAME,COLUMN_NAME,DATA_TYPE,DATA_LENGTH,DATA_PRECISION,DATA_SCALE,NULLABLE,COLUMN_ID,DATA_DEFAULT FROM USER_TAB_COLUMNS WHERE TABLE_NAME = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            while (rs.next()) {
                cname = rs.getString(2);
                if (rdTable.sensitive() == 0 && cname != null) {
                    cname = cname.toUpperCase(Locale.ROOT);
                }
                TableColumn tableColumn = new TableColumn(tableName, cname);
                tableColumn.setType(rs.getString("DATA_TYPE"));
                tableColumn.setLength(rs.getLong("DATA_LENGTH"));
                tableColumn.setPrecision(rs.getInt("DATA_PRECISION"));
                tableColumn.setScale(rs.getInt("DATA_SCALE"));
                tableColumn.setNullable("Y".equalsIgnoreCase(rs.getString("NULLABLE")));
                tableColumn.setOrder(rs.getInt("COLUMN_ID"));
                tableColumn.setDefaultValue(rs.getString("DATA_DEFAULT"));
                tableColumn.setComment((String)columnComment.get(tableColumn.getColumn()));
                columns.add(tableColumn);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return columns;
    }

    @Override
    public List<TableColumn> columns(Connection connection, String tableName) {
        String sql;
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, String> columnComment = new HashMap<String, String>();
        try {
            String sql2 = "SELECT COLUMN_NAME,COMMENTS FROM USER_COL_COMMENTS WHERE TABLE_NAME = ? ";
            ps = connection.prepareStatement(sql2);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            while (rs.next()) {
                String cname = rs.getString(1);
                columnComment.put(cname, rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        String primaryKey = null;
        try {
            sql = "select col.column_name         from user_constraints con,  user_cons_columns col        where con.constraint_name = col.constraint_name        and con.constraint_type='P'        and col.table_name = ? ";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                primaryKey = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            sql = " SELECT TABLE_NAME,COLUMN_NAME,DATA_TYPE,DATA_LENGTH,DATA_PRECISION,DATA_SCALE,NULLABLE,COLUMN_ID,DATA_DEFAULT FROM USER_TAB_COLUMNS WHERE TABLE_NAME = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            while (rs.next()) {
                String cname = rs.getString(2);
                TableColumn tableColumn = new TableColumn(tableName, cname);
                tableColumn.setType(rs.getString("DATA_TYPE"));
                tableColumn.setLength(rs.getLong("DATA_LENGTH"));
                tableColumn.setPrecision(rs.getInt("DATA_PRECISION"));
                tableColumn.setScale(rs.getInt("DATA_SCALE"));
                tableColumn.setNullable("Y".equalsIgnoreCase(rs.getString("NULLABLE")));
                tableColumn.setOrder(rs.getInt("COLUMN_ID"));
                tableColumn.setDefaultValue(rs.getString("DATA_DEFAULT"));
                tableColumn.setComment((String)columnComment.get(tableColumn.getColumn()));
                tableColumn.setIsPrimaryKey(cname.equalsIgnoreCase(primaryKey));
                columns.add(tableColumn);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return columns;
    }

    @Override
    public List<String> createOrUpdateSqls(Connection connection, RdTable table, List<ColumnInfo> infos, boolean tableExisted, List<TableColumn> tableColumns) {
        ArrayList<String> sqls = new ArrayList<String>();
        String tableName = this.getCaseSensitive(table.name(), table.sensitive());
        List<String> constraints = this.tableConstraints(connection);
        if (table.dropped()) {
            if (tableExisted) {
                if (table.sensitive() == 0) {
                    sqls.add(String.format("DROP TABLE %s", tableName));
                } else {
                    sqls.add(String.format("DROP TABLE \"%s\"", tableName));
                }
            }
        } else if (tableExisted) {
            HashMap<String, TableColumn> columnMap = new HashMap<String, TableColumn>();
            for (TableColumn column : tableColumns) {
                columnMap.put(column.getColumn(), column);
            }
            for (ColumnInfo info : infos) {
                String foreignSQL;
                String uniqueSQL;
                String columnName = this.getCaseSensitive(info.getColumnName(), table.sensitive());
                TableColumn tableColumn = (TableColumn)columnMap.get(columnName);
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                String comment = this.columnComment(rdColumn);
                if (tableColumn != null) {
                    if (rdColumn.dropped()) {
                        if (table.sensitive() == 0) {
                            sqls.add(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName));
                        } else {
                            sqls.add(String.format("ALTER TABLE \"%s\" DROP COLUMN \"%s\"", tableName, columnName));
                        }
                    } else {
                        String temp;
                        boolean needUpdate = false;
                        if ("VARCHAR2".equalsIgnoreCase(tableColumn.getType()) || "CHAR".equalsIgnoreCase(tableColumn.getType())) {
                            if (tableColumn.getLength() == null) continue;
                            if (tableColumn.getLength().intValue() != rdColumn.length()) {
                                needUpdate = true;
                            }
                        } else if ("NUMBER".equalsIgnoreCase(tableColumn.getType())) {
                            if (tableColumn.getPrecision() == null || tableColumn.getScale() == null) continue;
                            if ("Date".equalsIgnoreCase(info.getType())) {
                                if (tableColumn.getPrecision().intValue() != rdColumn.datePrecision() || tableColumn.getScale() != 0) {
                                    needUpdate = true;
                                }
                            } else if (tableColumn.getPrecision().intValue() != rdColumn.precision() || tableColumn.getScale().intValue() != rdColumn.scale()) {
                                needUpdate = true;
                            }
                        } else {
                            String type = this.getColumnType(info, rdColumn).toUpperCase(Locale.ROOT);
                            String columnType = tableColumn.getType().toUpperCase(Locale.ROOT);
                            int index = columnType.indexOf("(");
                            if (index != -1) {
                                columnType = columnType.substring(0, index);
                            }
                            if (!type.startsWith(columnType)) {
                                needUpdate = true;
                            }
                        }
                        if (!needUpdate && !ORMUtils.isEmpty(tableColumn.getDefaultValue())) {
                            String defaultValue = tableColumn.getDefaultValue().trim();
                            if (defaultValue.startsWith("'") && defaultValue.startsWith("'")) {
                                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                            }
                            if (!defaultValue.equals(rdColumn.defaultValue())) {
                                needUpdate = true;
                            }
                        }
                        RdId rdId = info.getField().getAnnotation(RdId.class);
                        if (!needUpdate && tableColumn.isNullable() != rdColumn.nullable() && !tableColumn.isPrimaryKey() && rdId == null) {
                            temp = this.columnStringChangeNull(info, table.sensitive(), rdColumn.nullable());
                            sqls.add(String.format("ALTER TABLE %s MODIFY %s", tableName, temp));
                        }
                        if (needUpdate) {
                            temp = this.columnString(info, table.sensitive(), rdColumn, false);
                            if (table.sensitive() == 0) {
                                sqls.add(String.format("ALTER TABLE %s MODIFY %s", tableName, temp));
                            } else {
                                sqls.add(String.format("ALTER TABLE \"%s\" MODIFY %s", tableName, temp));
                            }
                            if (!ORMUtils.isEmpty(comment) && !comment.equals(tableColumn.getComment())) {
                                if (table.sensitive() == 0) {
                                    sqls.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                                } else {
                                    sqls.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                                }
                            }
                        }
                    }
                } else if (!rdColumn.dropped()) {
                    String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                    if (table.sensitive() == 0) {
                        sqls.add(String.format("ALTER TABLE %s ADD %s", tableName, temp));
                    } else {
                        sqls.add(String.format("ALTER TABLE \"%s\" ADD %s", tableName, temp));
                    }
                    if (!ORMUtils.isEmpty(comment)) {
                        if (table.sensitive() == 0) {
                            sqls.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                        } else {
                            sqls.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                        }
                    }
                }
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    if (table.sensitive() == 0) {
                        sqls.add("ALTER TABLE " + tableName + " ADD " + uniqueSQL);
                    } else {
                        sqls.add("ALTER TABLE \"" + tableName + "\" ADD " + uniqueSQL);
                    }
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                if (table.sensitive() == 0) {
                    sqls.add("ALTER TABLE " + tableName + " ADD " + foreignSQL);
                    continue;
                }
                sqls.add("ALTER TABLE \"" + tableName + "\" ADD " + foreignSQL);
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE ");
            if (table.sensitive() == 0) {
                sql.append(tableName);
            } else {
                sql.append(String.format("\"%s\" ", tableName));
            }
            sql.append(" (");
            ArrayList<String> columnSQL = new ArrayList<String>();
            ArrayList<String> comments = new ArrayList<String>();
            for (int i = 0; i < infos.size(); ++i) {
                String foreignSQL;
                String uniqueSQL;
                ColumnInfo info = infos.get(i);
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                RdId rdId = info.getField().getAnnotation(RdId.class);
                if (rdId != null && rdId.autoIncrement() && !ORMUtils.isEmpty(rdId.sequence())) {
                    String seqName = this.getCaseSensitive(rdId.sequence(), table.sensitive());
                    PreparedStatement ps = null;
                    ResultSet rs = null;
                    boolean seqExist = false;
                    try {
                        ps = connection.prepareStatement("SELECT * FROM USER_SEQUENCES WHERE SEQUENCE_NAME = ? ");
                        ps.setString(1, seqName);
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            seqExist = true;
                        }
                        rs.close();
                        ps.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    if (!seqExist) {
                        if (table.sensitive() == 0) {
                            sql.append(String.format("CREATE SEQUENCE %s INCREMENT BY 1 START WITH 1", seqName));
                        } else {
                            sql.append(String.format("CREATE SEQUENCE \"%s\" INCREMENT BY 1 START WITH 1", seqName));
                        }
                    }
                }
                String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                String comment = this.columnComment(rdColumn);
                String columnName = this.getCaseSensitive(rdColumn.name(), table.sensitive());
                if (!ORMUtils.isEmpty(comment)) {
                    if (table.sensitive() == 0) {
                        comments.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                    } else {
                        comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                    }
                }
                columnSQL.add(temp.toString());
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    columnSQL.add(uniqueSQL);
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                columnSQL.add(foreignSQL);
            }
            sql.append(ORMUtils.join(columnSQL, ","));
            sql.append(")");
            sqls.add(sql.toString());
            String comment = table.comment();
            if (ORMUtils.isEmpty(comment)) {
                comment = table.title();
            }
            if (!ORMUtils.isEmpty(comment)) {
                if (table.sensitive() == 0) {
                    sqls.add(String.format("COMMENT ON TABLE %s IS '%s'", tableName, comment));
                } else {
                    sqls.add(String.format("COMMENT ON TABLE \"%s\" IS '%s'", tableName, comment));
                }
            }
            sqls.addAll(comments);
        }
        return sqls;
    }

    protected String columnString(ColumnInfo info, int sensitive, RdColumn rdColumn, boolean addKey) {
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(info.getColumnName(), sensitive);
        if (sensitive == 0) {
            temp.append(cname);
        } else {
            temp.append(String.format("\"%s\"", cname));
        }
        temp.append(" ");
        String type = this.getColumnType(info, rdColumn);
        if (!ORMUtils.isEmpty(rdColumn.defaultValue())) {
            type = type + " DEFAULT '" + rdColumn.defaultValue() + "'";
        }
        if (!rdColumn.nullable() && addKey) {
            type = type + " NOT NULL";
        }
        temp.append(type);
        if (info.getPrimaryKey().booleanValue() && addKey) {
            temp.append(" ");
            temp.append("PRIMARY KEY");
        }
        return temp.toString();
    }

    protected String columnStringChangeNull(ColumnInfo info, int sensitive, boolean isNull) {
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(info.getColumnName(), sensitive);
        if (sensitive == 0) {
            temp.append(cname);
        } else {
            temp.append(String.format("\"%s\"", cname));
        }
        if (isNull) {
            temp.append(" NULL");
        } else {
            temp.append(" NOT NULL");
        }
        return temp.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getColumnType(ColumnInfo info, RdColumn rdColumn) {
        String type = "";
        String infoType = info.getField().getType().getName();
        if (String.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.TEXT) {
                return "CLOB";
            }
            if (info.getColumnType() == ColumnType.BLOB) {
                return "BLOB";
            }
            if (info.getColumnType() == ColumnType.CLOB) {
                return "CLOB";
            }
            if (info.getColumnType() == ColumnType.BINARY) {
                return "BLOB";
            }
            if (info.getColumnType() != ColumnType.CHAR) return "VARCHAR2(" + rdColumn.length() + ")";
            return "CHAR(" + rdColumn.length() + ")";
        }
        if (Integer.class.getName().equals(infoType)) {
            return "NUMBER(" + rdColumn.precision() + ")";
        }
        if (Date.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.LONG) {
                return "NUMBER(" + rdColumn.datePrecision() + ", 0)";
            }
            if (info.getColumnType() == ColumnType.TIMESTAMP) {
                return "TIMESTAMP";
            }
            if (info.getColumnType() != ColumnType.DATETIME) throw new RuntimeException("Not support type : " + infoType + "," + info.getColumnType().name());
            return "DATE";
        }
        if (Long.class.getName().equals(infoType)) {
            return "NUMBER(" + rdColumn.precision() + ")";
        }
        if (Double.class.getName().equals(infoType)) {
            return "NUMBER(" + rdColumn.precision() + "," + rdColumn.scale() + ")";
        }
        if (Float.class.getName().equals(infoType)) {
            return "FLOAT";
        }
        if (BigDecimal.class.getName().equals(infoType)) {
            return "NUMBER(" + rdColumn.precision() + "," + rdColumn.scale() + ")";
        }
        if (!byte[].class.getName().equals(infoType)) throw new RuntimeException("Not support type : " + infoType + "," + info.getColumnType().name());
        return "BLOB";
    }

    @Override
    public SQLPair parseExpression(Class clazz, Map<String, Object> clazzes, Expression expression) {
        SQLPair sqlPair = null;
        if (expression == null) {
            return sqlPair;
        }
        if (expression.getLeft() != null) {
            String conditionName = this.parseColumn(expression.getLeft());
            switch (expression.getType()) {
                case CDT_IS_NULL: 
                case CDT_IS_EMPTY: {
                    sqlPair = new SQLPair(" " + conditionName + " IS NULL ");
                    break;
                }
                case CDT_IS_NOT_NULL: 
                case CDT_IS_NOT_EMPTY: {
                    sqlPair = new SQLPair(" " + conditionName + " IS NOT NULL ");
                    break;
                }
            }
        }
        if (sqlPair == null) {
            return super.parseExpression(clazz, clazzes, expression);
        }
        return sqlPair;
    }
}

