/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.handler;

import com.ursful.framework.orm.annotation.RdColumn;
import com.ursful.framework.orm.handler.IResultSetHandler;
import com.ursful.framework.orm.query.QueryUtils;
import com.ursful.framework.orm.support.ColumnInfo;
import com.ursful.framework.orm.support.DataType;
import com.ursful.framework.orm.support.KV;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.TimeZone;
import org.springframework.validation.DataBinder;

public class DefaultResultSetHandler
implements IResultSetHandler {
    @Override
    public String decode(Class clazz, ColumnInfo info, Object value, ResultSet resultSet) {
        RdColumn column;
        if (info != null && info.getField() != null && (column = info.getField().getAnnotation(RdColumn.class)) != null) {
            return column.coding();
        }
        return "UTF-8";
    }

    @Override
    public KV parseMap(ResultSetMetaData metaData, int index, Object obj, ResultSet rs) throws SQLException {
        if (obj != null) {
            if (obj instanceof Timestamp) {
                obj = new java.util.Date(((Timestamp)obj).getTime());
            } else if (obj instanceof Date) {
                obj = new java.util.Date(((Date)obj).getTime());
            } else if (metaData.getPrecision(index) == 15 && metaData.getScale(index) == 0) {
                if (obj instanceof Long) {
                    obj = new java.util.Date((Long)obj);
                } else if (obj instanceof BigDecimal) {
                    obj = new java.util.Date(((BigDecimal)obj).longValue());
                }
            }
            if (obj instanceof Clob) {
                StringBuffer sb = new StringBuffer();
                Clob clob = (Clob)obj;
                if (clob != null) {
                    Reader reader = clob.getCharacterStream();
                    BufferedReader br = new BufferedReader(reader);
                    String s = null;
                    try {
                        while ((s = br.readLine()) != null) {
                            sb.append(s);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                obj = sb.toString();
            } else if (obj instanceof Blob) {
                Blob blob = (Blob)obj;
                InputStream stream = blob.getBinaryStream();
                try {
                    byte[] temp = new byte[(int)blob.length()];
                    stream.read(temp);
                    stream.close();
                    obj = new String(temp, this.decode(null, null, obj, rs));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (obj instanceof byte[]) {
                try {
                    obj = new String((byte[])obj, this.decode(null, null, obj, rs));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (obj instanceof BigDecimal) {
                obj = ((BigDecimal)obj).toPlainString();
            } else if (obj instanceof Double || obj instanceof Long || obj instanceof Float) {
                obj = new BigDecimal(obj.toString()).toPlainString();
            }
            String key = QueryUtils.displayNameOrAsName(metaData.getColumnLabel(index), metaData.getColumnName(index));
            return new KV(key, obj);
        }
        return null;
    }

    @Override
    public void handle(Object object, ColumnInfo info, Object value, ResultSet rs) throws SQLException {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        Object obj = null;
        DataType type = DataType.getDataType(info.getType());
        if (value != null) {
            switch (type) {
                case BINARY: {
                    Blob blob;
                    if (value instanceof byte[]) {
                        obj = value;
                        break;
                    }
                    if (value instanceof Blob) {
                        blob = (Blob)value;
                        InputStream stream = blob.getBinaryStream();
                        byte[] temp = null;
                        try {
                            temp = new byte[(int)blob.length()];
                            stream.read(temp);
                            stream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        obj = temp;
                        break;
                    }
                    obj = value;
                    break;
                }
                case STRING: {
                    Blob blob;
                    if (value instanceof Clob) {
                        StringBuffer sb = new StringBuffer();
                        Clob clob = (Clob)value;
                        if (clob != null) {
                            Reader reader = clob.getCharacterStream();
                            BufferedReader br = new BufferedReader(reader);
                            String s = null;
                            try {
                                while ((s = br.readLine()) != null) {
                                    sb.append(s);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        obj = sb.toString();
                        break;
                    }
                    if (value instanceof Blob) {
                        blob = (Blob)value;
                        InputStream stream = blob.getBinaryStream();
                        try {
                            byte[] temp = new byte[(int)blob.length()];
                            stream.read(temp);
                            stream.close();
                            String coding = this.decode(clazz, info, value, rs);
                            obj = new String(temp, coding);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    if (value instanceof byte[]) {
                        try {
                            String coding = this.decode(clazz, info, value, rs);
                            obj = new String((byte[])value, coding);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    obj = value;
                    break;
                }
                case DATE: {
                    Comparable<Long> ts;
                    if (value instanceof Long) {
                        ts = (Long)value;
                        if (ts == null || (Long)ts <= 0L) break;
                        obj = new java.util.Date((Long)ts);
                        break;
                    }
                    if (value instanceof Date) {
                        Date tmp = (Date)value;
                        obj = new java.util.Date(tmp.getTime());
                        break;
                    }
                    if (value instanceof Timestamp) {
                        ts = (Timestamp)value;
                        if (ts == null) break;
                        obj = new java.util.Date(((Timestamp)ts).getTime());
                        break;
                    }
                    if (value instanceof BigDecimal) {
                        ts = (BigDecimal)value;
                        if (ts == null) break;
                        obj = new java.util.Date(((BigDecimal)ts).longValue());
                        break;
                    }
                    if (!(value instanceof LocalDateTime)) break;
                    LocalDateTime ldt = (LocalDateTime)value;
                    int hour = TimeZone.getDefault().getRawOffset() / 1000 / 3600;
                    obj = new java.util.Date((long)((double)ldt.toInstant(ZoneOffset.ofHours(hour)).toEpochMilli() * 1.0));
                    break;
                }
                default: {
                    if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).toPlainString();
                    } else if (value instanceof Double || value instanceof Long || value instanceof Short || value instanceof Byte || value instanceof Boolean || value instanceof Float) {
                        value = value.toString();
                    }
                    DataBinder binder = new DataBinder((Object)info.getField(), info.getName());
                    obj = binder.convertIfNecessary((Object)value.toString(), info.getField().getType());
                }
            }
        }
        if (obj != null) {
            try {
                info.getField().setAccessible(true);
                info.getField().set(object, obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

