/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.option;

import com.ursful.framework.orm.annotation.RdColumn;
import com.ursful.framework.orm.annotation.RdForeignKey;
import com.ursful.framework.orm.annotation.RdId;
import com.ursful.framework.orm.annotation.RdTable;
import com.ursful.framework.orm.annotation.RdUniqueKey;
import com.ursful.framework.orm.exception.ORMException;
import com.ursful.framework.orm.option.MySQLOptions;
import com.ursful.framework.orm.support.ColumnInfo;
import com.ursful.framework.orm.support.ColumnType;
import com.ursful.framework.orm.support.DataType;
import com.ursful.framework.orm.support.Pair;
import com.ursful.framework.orm.support.Table;
import com.ursful.framework.orm.support.TableColumn;
import com.ursful.framework.orm.utils.ORMUtils;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class PostgreSQLOptions
extends MySQLOptions {
    @Override
    public String databaseType() {
        return "PostgreSQL";
    }

    @Override
    public boolean preSetParameter(PreparedStatement ps, Connection connection, String databaseType, int i, Pair pair) throws SQLException {
        Object obj = pair.getValue();
        ColumnType columnType = pair.getColumnType();
        DataType type = DataType.getDataType(pair.getType());
        if (type == DataType.STRING && obj != null && (columnType == ColumnType.BLOB || columnType == ColumnType.CLOB)) {
            try {
                ps.setBinaryStream(i + 1, new ByteArrayInputStream(obj.toString().getBytes(this.getCoding(pair))));
                return true;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public String keyword() {
        return "PostgreSQL";
    }

    @Override
    public String nanoTimeSQL() {
        return "SELECT NOW()";
    }

    @Override
    public Table table(Connection connection, RdTable rdTable) throws ORMException {
        String tableName = this.getTableName(rdTable);
        return this.table(connection, tableName, rdTable.name(), rdTable.sensitive() == 0);
    }

    @Override
    public Table table(Connection connection, Table table) {
        String otableName = table.getName();
        String tableName = this.getCaseSensitive(table.getName(), table.getSensitive());
        return this.table(connection, tableName, otableName, false);
    }

    private Table table(Connection connection, String tableName, String originalTableName, boolean sensitive) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Table table = null;
        try {
            String sql = "select relname as TABLE_NAME,cast(obj_description(relfilenode,'pg_class') as varchar) as COMMENT from pg_class c where relname = ? ";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                table = new Table();
                if (sensitive) {
                    table.setName(originalTableName);
                } else {
                    table.setName(tableName);
                }
                table.setComment(rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return table;
    }

    @Override
    public List<Table> tables(Connection connection, String keyword) {
        ArrayList<Table> temp = new ArrayList<Table>();
        Statement ps = null;
        ResultSet rs = null;
        Object table = null;
        try {
            String sql = "select relname,cast(obj_description(relfilenode,'pg_class') as varchar) as COMMENT from pg_class c ";
            if (!ORMUtils.isEmpty(keyword)) {
                sql = sql + "where relname like ? ";
            }
            ps = connection.prepareStatement(sql);
            if (!ORMUtils.isEmpty(keyword)) {
                ps.setString(1, "%" + keyword + "%");
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                temp.add(new Table(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return temp;
    }

    @Override
    public boolean tableExists(Connection connection, String tableName) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "select relname as TABLE_NAME,cast(obj_description(relfilenode,'pg_class') as varchar) as COMMENT from pg_class c where  relname = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public List<TableColumn> columns(Connection connection, RdTable rdTable) throws ORMException {
        String tableName = this.getTableName(rdTable);
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        Statement ps = null;
        ResultSet rs = null;
        String primaryKey = null;
        try {
            String sql = String.format("select a.attname from pg_constraint ct inner join pg_class c on ct.conrelid = c.oid inner join pg_attribute a on a.attrelid = c.oid and a.attnum = ct.conkey[1] inner join pg_type t on t.oid = a.atttypid where  ct.contype='p' and c.relname = '%s'", tableName);
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                primaryKey = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            String dbName = connection.getCatalog();
            String schemaName = connection.getSchema();
            String sql = "select c.relname, ad.adsrc, a.attnum,a.attname,t.typname,SUBSTRING(format_type(a.atttypid,a.atttypmod) from '\\(.*\\)') as data_type, format_type(a.atttypid,a.atttypmod),d.description, a.attnotnull, a.*  from pg_attribute a left join pg_type t on a.atttypid=t.oid left join pg_class c on a.attrelid=c.oid left join pg_description d on d.objsubid=a.attnum and d.objoid=a.attrelid left join pg_attrdef  ad  on ad.adrelid = a.attrelid and ad.adnum = a.attnum where   a.attnum>0  and c.relname = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            rs = ps.executeQuery();
            while (rs.next()) {
                String cname = rs.getString("ATTNAME");
                if (cname.contains(".pg.dropped.")) continue;
                TableColumn tableColumn = new TableColumn(tableName, cname);
                tableColumn.setType(rs.getString("TYPNAME"));
                String type = rs.getString("DATA_TYPE");
                if (type != null && type.startsWith("(") && type.endsWith(")")) {
                    String[] stype = type.substring(1, type.length() - 1).split(",");
                    if (stype.length == 1) {
                        tableColumn.setLength(Long.parseLong(stype[0]));
                    } else if (stype.length == 2) {
                        tableColumn.setPrecision(Integer.parseInt(stype[0]));
                        tableColumn.setScale(Integer.parseInt(stype[1]));
                    }
                }
                tableColumn.setNullable("f".equalsIgnoreCase(rs.getString("ATTNOTNULL")));
                tableColumn.setOrder(rs.getInt("ATTNUM"));
                tableColumn.setDefaultValue(rs.getString("ADSRC"));
                tableColumn.setComment(rs.getString("DESCRIPTION"));
                tableColumn.setIsPrimaryKey(tableColumn.getColumn().equalsIgnoreCase(primaryKey));
                columns.add(tableColumn);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return columns;
    }

    @Override
    public List<TableColumn> columns(Connection connection, String tableName) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        Statement ps = null;
        ResultSet rs = null;
        String primaryKey = null;
        try {
            String sql = String.format("select a.attname from pg_constraint ct inner join pg_class c on ct.conrelid = c.oid inner join pg_attribute a on a.attrelid = c.oid and a.attnum = ct.conkey[1] inner join pg_type t on t.oid = a.atttypid where  ct.contype='p' and (c.relname = '%s' or c.relname = '%s')", tableName.toLowerCase(Locale.ROOT), tableName.toUpperCase(Locale.ROOT));
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                primaryKey = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            String dbName = connection.getCatalog();
            String schemaName = connection.getSchema();
            String sql = "select c.relname, ad.adsrc, a.attnum,a.attname,t.typname,SUBSTRING(format_type(a.atttypid,a.atttypmod) from '\\(.*\\)') as data_type, format_type(a.atttypid,a.atttypmod),d.description, a.attnotnull, a.*  from pg_attribute a left join pg_type t on a.atttypid=t.oid left join pg_class c on a.attrelid=c.oid left join pg_description d on d.objsubid=a.attnum and d.objoid=a.attrelid left join pg_attrdef  ad  on ad.adrelid = a.attrelid and ad.adnum = a.attnum where   a.attnum>0  and (c.relname = ? or c.relname = ?)";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName.toUpperCase(Locale.ROOT));
            ps.setString(2, tableName.toLowerCase(Locale.ROOT));
            rs = ps.executeQuery();
            while (rs.next()) {
                String cname = rs.getString("ATTNAME");
                if (cname.contains(".pg.dropped.")) continue;
                TableColumn tableColumn = new TableColumn(tableName, cname);
                tableColumn.setType(rs.getString("TYPNAME"));
                String type = rs.getString("DATA_TYPE");
                if (type != null && type.startsWith("(") && type.endsWith(")")) {
                    String[] stype = type.substring(1, type.length() - 1).split(",");
                    if (stype.length == 1) {
                        tableColumn.setLength(Long.parseLong(stype[0]));
                    } else if (stype.length == 2) {
                        tableColumn.setPrecision(Integer.parseInt(stype[0]));
                        tableColumn.setScale(Integer.parseInt(stype[1]));
                    }
                }
                tableColumn.setNullable("f".equalsIgnoreCase(rs.getString("ATTNOTNULL")));
                tableColumn.setOrder(rs.getInt("ATTNUM"));
                tableColumn.setDefaultValue(rs.getString("ADSRC"));
                tableColumn.setComment(rs.getString("DESCRIPTION"));
                tableColumn.setIsPrimaryKey(tableColumn.getColumn().equalsIgnoreCase(primaryKey));
                columns.add(tableColumn);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return columns;
    }

    private List<String> tableConstraints(Connection connection) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            String sql = "SELECT CONNAME AS INDEX_NAME FROM PG_CONSTRAINT WHERE CONTYPE = 'f' OR CONTYPE= 'u' OR CONTYPE= 'p'";
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null) continue;
                names.add(indexName.toUpperCase(Locale.ROOT));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return names;
    }

    @Override
    public String getCaseSensitive(String name, int sensitive) {
        if (name == null) {
            return name;
        }
        if (2 == sensitive) {
            return name.toLowerCase(Locale.ROOT);
        }
        if (1 == sensitive) {
            return name.toUpperCase(Locale.ROOT);
        }
        if (3 == sensitive) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    @Override
    public List<String> createOrUpdateSqls(Connection connection, RdTable table, List<ColumnInfo> infos, boolean tableExisted, List<TableColumn> tableColumns) {
        ArrayList<String> sqls = new ArrayList<String>();
        String tableName = this.getCaseSensitive(table.name(), table.sensitive());
        List<String> constraints = this.tableConstraints(connection);
        if (table.dropped()) {
            if (tableExisted) {
                if (table.sensitive() == 0) {
                    sqls.add(String.format("DROP TABLE %s", tableName));
                } else {
                    sqls.add(String.format("DROP TABLE \"%s\"", tableName));
                }
            }
        } else if (tableExisted) {
            HashMap<String, TableColumn> columnMap = new HashMap<String, TableColumn>();
            for (TableColumn column : tableColumns) {
                columnMap.put(column.getColumn(), column);
            }
            for (ColumnInfo info : infos) {
                String foreignSQL;
                String uniqueSQL;
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                String columnName = this.getCaseSensitive(rdColumn.name(), table.sensitive());
                TableColumn tableColumn = (TableColumn)columnMap.get(columnName);
                String comment = this.columnComment(rdColumn);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                if (tableColumn != null) {
                    if (rdColumn.dropped()) {
                        if (table.sensitive() == 0) {
                            sqls.add(String.format("ALTER TABLE %s DROP COLUMN %s ", tableName, columnName));
                        } else {
                            sqls.add(String.format("ALTER TABLE \"%s\" DROP COLUMN \"%s\" ", tableName, columnName));
                        }
                    } else {
                        String defaultValue;
                        boolean needUpdate = false;
                        if ("NVARCHAR".equalsIgnoreCase(tableColumn.getType()) || "NCHAR".equalsIgnoreCase(tableColumn.getType())) {
                            if (tableColumn.getLength() == null) continue;
                            if (tableColumn.getLength().intValue() != rdColumn.length()) {
                                needUpdate = true;
                            }
                        } else if ("DECIMAL".equalsIgnoreCase(tableColumn.getType())) {
                            if (tableColumn.getPrecision() == null || tableColumn.getScale() == null) continue;
                            if ("Date".equalsIgnoreCase(info.getType())) {
                                if (tableColumn.getPrecision().intValue() != rdColumn.datePrecision() || tableColumn.getScale() != 0) {
                                    needUpdate = true;
                                }
                            } else if (tableColumn.getPrecision().intValue() != rdColumn.precision() || tableColumn.getScale().intValue() != rdColumn.scale()) {
                                needUpdate = true;
                            }
                        } else {
                            String type = this.getColumnType(info, rdColumn).toUpperCase(Locale.ROOT);
                            if (!type.startsWith(tableColumn.getType().toUpperCase(Locale.ROOT))) {
                                needUpdate = true;
                                String typeString = this.getColumnType(info, rdColumn);
                                if (table.sensitive() == 0) {
                                    sqls.add(String.format(" ALTER TABLE %s ALTER COLUMN %s TYPE %s", tableName, columnName, typeString));
                                } else {
                                    sqls.add(String.format(" ALTER TABLE \"%s\" ALTER COLUMN \"%s\" TYPE %s", tableName, columnName, typeString));
                                }
                            }
                        }
                        if (!(ORMUtils.isEmpty(defaultValue = tableColumn.getDefaultValue()) || ORMUtils.isEmpty(rdColumn.defaultValue()) || defaultValue.equals(rdColumn.defaultValue()))) {
                            if (table.sensitive() == 0) {
                                sqls.add(String.format(" ALTER TABLE %s ALTER COLUMN %s SET DEFAULT '%s'", tableName, columnName, rdColumn.defaultValue()));
                            } else {
                                sqls.add(String.format(" ALTER TABLE \"%s\" ALTER COLUMN \"%s\" SET DEFAULT '%s'", tableName, columnName, rdColumn.defaultValue()));
                            }
                        }
                        RdId rdId = info.getField().getAnnotation(RdId.class);
                        if (!needUpdate && tableColumn.isNullable() != rdColumn.nullable() && !tableColumn.isPrimaryKey() && rdId == null) {
                            needUpdate = true;
                        }
                        if (needUpdate) {
                            if (!rdColumn.nullable()) {
                                if (table.sensitive() == 0) {
                                    sqls.add(String.format("ALTER TABLE %s ALTER COLUMN %s SET NOT NULL", tableName, columnName));
                                } else {
                                    sqls.add(String.format("ALTER TABLE \"%s\" ALTER COLUMN \"%s\" SET NOT NULL", tableName, columnName));
                                }
                            } else if (table.sensitive() == 0) {
                                sqls.add(String.format("ALTER TABLE %s ALTER COLUMN %s DROP NOT NULL", tableName, columnName));
                            } else {
                                sqls.add(String.format("ALTER TABLE \"%s\" ALTER COLUMN \"%s\" DROP NOT NULL", tableName, columnName));
                            }
                            if (!ORMUtils.isEmpty(comment) && !comment.equals(tableColumn.getComment())) {
                                if (table.sensitive() == 0) {
                                    sqls.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                                } else {
                                    sqls.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                                }
                            }
                        }
                    }
                } else if (!rdColumn.dropped()) {
                    String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                    if (table.sensitive() == 0) {
                        sqls.add(String.format("ALTER TABLE %s ADD %s", tableName, temp));
                    } else {
                        sqls.add(String.format("ALTER TABLE \"%s\" ADD %s", tableName, temp));
                    }
                    if (!ORMUtils.isEmpty(comment)) {
                        if (table.sensitive() == 0) {
                            sqls.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                        } else {
                            sqls.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                        }
                    }
                }
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    if (table.sensitive() == 0) {
                        sqls.add("ALTER TABLE " + tableName + " ADD " + uniqueSQL);
                    } else {
                        sqls.add("ALTER TABLE \"" + tableName + "\" ADD " + uniqueSQL);
                    }
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                if (table.sensitive() == 0) {
                    sqls.add("ALTER TABLE " + tableName + " ADD " + foreignSQL);
                    continue;
                }
                sqls.add("ALTER TABLE \"" + tableName + "\" ADD " + foreignSQL);
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE ");
            if (table.sensitive() == 0) {
                sql.append(tableName);
            } else {
                sql.append(String.format("\"%s\" ", tableName));
            }
            sql.append(" (");
            ArrayList<String> columnSQL = new ArrayList<String>();
            ArrayList<String> comments = new ArrayList<String>();
            for (int i = 0; i < infos.size(); ++i) {
                String foreignSQL;
                String uniqueSQL;
                ColumnInfo info = infos.get(i);
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                String comment = this.columnComment(rdColumn);
                String columnName = this.getCaseSensitive(rdColumn.name(), table.sensitive());
                if (!ORMUtils.isEmpty(comment)) {
                    if (table.sensitive() == 0) {
                        comments.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                    } else {
                        comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                    }
                }
                columnSQL.add(temp.toString());
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    columnSQL.add(uniqueSQL);
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                columnSQL.add(foreignSQL);
            }
            sql.append(ORMUtils.join(columnSQL, ","));
            sql.append(")");
            sql.append(";");
            sqls.add(sql.toString());
            String comment = table.comment();
            if (ORMUtils.isEmpty(comment)) {
                comment = table.title();
            }
            if (!ORMUtils.isEmpty(comment)) {
                if (table.sensitive() == 0) {
                    sqls.add(String.format("COMMENT ON TABLE %s IS '%s'", tableName, comment));
                } else {
                    sqls.add(String.format("COMMENT ON TABLE \"%s\" IS '%s'", tableName, comment));
                }
            }
            sqls.addAll(comments);
        }
        return sqls;
    }

    @Override
    public String dropTable(Table table) {
        if (table.getSensitive() == 0) {
            return String.format("DROP TABLE %s", table.getName());
        }
        return String.format("DROP TABLE \"%s\"", table.getName());
    }

    @Override
    public List<String> createOrUpdateSqls(Connection connection, Table table, List<TableColumn> columns, List<TableColumn> tableColumns, boolean tableExisted) {
        ArrayList<String> sqls = new ArrayList<String>();
        String tableName = this.getCaseSensitive(table.getName(), table.getSensitive());
        List<String> constraints = this.tableConstraints(connection);
        if (tableExisted) {
            HashMap<String, TableColumn> columnMap = new HashMap<String, TableColumn>();
            for (TableColumn column : tableColumns) {
                columnMap.put(column.getColumn(), column);
            }
            for (TableColumn tc : columns) {
                String columnName = this.getCaseSensitive(tc.getColumn(), table.getSensitive());
                TableColumn tableColumn = (TableColumn)columnMap.get(columnName);
                String comment = tc.getComment();
                if (tableColumn != null) {
                    String defaultValue;
                    if (tc.isDropped()) {
                        if (table.getSensitive() == 0) {
                            sqls.add(String.format("ALTER TABLE %s DROP COLUMN %s ", tableName, columnName));
                            continue;
                        }
                        sqls.add(String.format("ALTER TABLE \"%s\" DROP COLUMN \"%s\" ", tableName, columnName));
                        continue;
                    }
                    boolean needUpdate = false;
                    if ("NVARCHAR".equalsIgnoreCase(tableColumn.getType()) || "NCHAR".equalsIgnoreCase(tableColumn.getType())) {
                        if (tableColumn.getLength() == null) continue;
                        if ((long)tableColumn.getLength().intValue() != tc.getLength()) {
                            needUpdate = true;
                        }
                    } else if ("DECIMAL".equalsIgnoreCase(tableColumn.getType())) {
                        if (tableColumn.getPrecision() == null || tableColumn.getScale() == null) continue;
                        if ("Date".equalsIgnoreCase(tc.getType())) {
                            if (tableColumn.getPrecision().intValue() != tc.getPrecision().intValue() || tableColumn.getScale() != 0) {
                                needUpdate = true;
                            }
                        } else if (tableColumn.getPrecision().intValue() != tc.getPrecision().intValue() || tableColumn.getScale().intValue() != tc.getScale().intValue()) {
                            needUpdate = true;
                        }
                    } else {
                        String type = this.getColumnType(tc).toUpperCase(Locale.ROOT);
                        if (!type.startsWith(tableColumn.getType().toUpperCase(Locale.ROOT))) {
                            needUpdate = true;
                            String typeString = this.getColumnType(tc);
                            if (table.getSensitive() == 0) {
                                sqls.add(String.format(" ALTER TABLE %s ALTER COLUMN %s TYPE %s", tableName, columnName, typeString));
                            } else {
                                sqls.add(String.format(" ALTER TABLE \"%s\" ALTER COLUMN \"%s\" TYPE %s", tableName, columnName, typeString));
                            }
                        }
                    }
                    if (!(ORMUtils.isEmpty(defaultValue = tableColumn.getDefaultValue()) || ORMUtils.isEmpty(tc.getDefaultValue()) || defaultValue.equals(tc.getDefaultValue()))) {
                        if (table.getSensitive() == 0) {
                            sqls.add(String.format(" ALTER TABLE %s ALTER COLUMN %s SET DEFAULT '%s'", tableName, columnName, tc.getDefaultValue()));
                        } else {
                            sqls.add(String.format(" ALTER TABLE \"%s\" ALTER COLUMN \"%s\" SET DEFAULT '%s'", tableName, columnName, tc.getDefaultValue()));
                        }
                    }
                    if (!(needUpdate || tableColumn.isNullable() == tc.isNullable() || tableColumn.isPrimaryKey() || tc.isPrimaryKey())) {
                        needUpdate = true;
                    }
                    if (!needUpdate) continue;
                    if (!tc.isNullable()) {
                        if (table.getSensitive() == 0) {
                            sqls.add(String.format("ALTER TABLE %s ALTER COLUMN %s SET NOT NULL", tableName, columnName));
                        } else {
                            sqls.add(String.format("ALTER TABLE \"%s\" ALTER COLUMN \"%s\" SET NOT NULL", tableName, columnName));
                        }
                    } else if (table.getSensitive() == 0) {
                        sqls.add(String.format("ALTER TABLE %s ALTER COLUMN %s DROP NOT NULL", tableName, columnName));
                    } else {
                        sqls.add(String.format("ALTER TABLE \"%s\" ALTER COLUMN \"%s\" DROP NOT NULL", tableName, columnName));
                    }
                    if (ORMUtils.isEmpty(comment) || comment.equals(tableColumn.getComment())) continue;
                    if (table.getSensitive() == 0) {
                        sqls.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                        continue;
                    }
                    sqls.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                    continue;
                }
                if (tc.isDropped()) continue;
                String temp = this.columnString(tc, table.getSensitive(), true);
                if (table.getSensitive() == 0) {
                    sqls.add(String.format("ALTER TABLE %s ADD %s", tableName, temp));
                } else {
                    sqls.add(String.format("ALTER TABLE \"%s\" ADD %s", tableName, temp));
                }
                if (ORMUtils.isEmpty(comment)) continue;
                if (table.getSensitive() == 0) {
                    sqls.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                    continue;
                }
                sqls.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE ");
            if (table.getSensitive() == 0) {
                sql.append(tableName);
            } else {
                sql.append(String.format("\"%s\" ", tableName));
            }
            sql.append(" (");
            ArrayList<String> columnSQL = new ArrayList<String>();
            ArrayList<String> comments = new ArrayList<String>();
            for (int i = 0; i < columns.size(); ++i) {
                TableColumn tc = columns.get(i);
                String temp = this.columnString(tc, table.getSensitive(), true);
                String comment = tc.getComment();
                String columnName = this.getCaseSensitive(tc.getColumn(), table.getSensitive());
                if (!ORMUtils.isEmpty(comment)) {
                    if (table.getSensitive() == 0) {
                        comments.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                    } else {
                        comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                    }
                }
                columnSQL.add(temp.toString());
            }
            sql.append(ORMUtils.join(columnSQL, ","));
            sql.append(")");
            sql.append(";");
            sqls.add(sql.toString());
            String comment = table.getComment();
            if (!ORMUtils.isEmpty(comment)) {
                if (table.getSensitive() == 0) {
                    sqls.add(String.format("COMMENT ON TABLE %s IS '%s'", tableName, comment));
                } else {
                    sqls.add(String.format("COMMENT ON TABLE \"%s\" IS '%s'", tableName, comment));
                }
            }
            sqls.addAll(comments);
        }
        return sqls;
    }

    @Override
    protected String columnString(ColumnInfo info, int sensitive, RdColumn rdColumn, boolean addKey) {
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(info.getColumnName(), sensitive);
        if (sensitive == 0) {
            temp.append(cname);
        } else {
            temp.append(String.format("\"%s\"", cname));
        }
        RdId rdId = info.getField().getAnnotation(RdId.class);
        if (rdId != null && rdId.autoIncrement() && !ORMUtils.isEmpty(rdId.sequence())) {
            temp.append(" " + rdId.sequence());
        } else {
            String type = this.getColumnType(info, rdColumn);
            temp.append(" " + type);
        }
        if (!ORMUtils.isEmpty(rdColumn.defaultValue())) {
            temp.append(" DEFAULT '" + rdColumn.defaultValue() + "'");
        }
        if (!rdColumn.nullable()) {
            temp.append(" NOT NULL");
        }
        if (info.getPrimaryKey().booleanValue() && addKey) {
            temp.append(" PRIMARY KEY");
        }
        return temp.toString();
    }

    @Override
    protected String columnString(TableColumn tc, int sensitive, boolean addKey) {
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(tc.getColumn(), sensitive);
        if (sensitive == 0) {
            temp.append(cname);
        } else {
            temp.append(String.format("\"%s\"", cname));
        }
        if (tc.isPrimaryKey() && tc.isAutoIncrement() && !ORMUtils.isEmpty(tc.getSequence())) {
            temp.append(" " + tc.getSequence());
        } else {
            String type = this.getColumnType(tc);
            temp.append(" " + type);
        }
        if (!ORMUtils.isEmpty(tc.getDefaultValue())) {
            temp.append(" DEFAULT '" + tc.getDefaultValue() + "'");
        }
        if (!tc.isNullable()) {
            temp.append(" NOT NULL");
        }
        if (tc.isPrimaryKey() && addKey) {
            temp.append(" PRIMARY KEY");
        }
        return temp.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getColumnType(ColumnInfo info, RdColumn rdColumn) {
        String type = "";
        String infoType = info.getField().getType().getName();
        if (String.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.TEXT) {
                return "TEXT";
            }
            if (info.getColumnType() == ColumnType.BLOB) {
                return "BYTEA";
            }
            if (info.getColumnType() == ColumnType.CLOB) {
                return "BYTEA";
            }
            if (info.getColumnType() == ColumnType.BINARY) {
                return "BYTEA";
            }
            if (info.getColumnType() != ColumnType.CHAR) return "VARCHAR(" + rdColumn.length() + ")";
            return "BPCHAR(" + rdColumn.length() + ")";
        }
        if (Integer.class.getName().equals(infoType)) {
            return "INT4";
        }
        if (Date.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.LONG) {
                return "NUMERIC(" + rdColumn.datePrecision() + ", 0)";
            }
            if (info.getColumnType() == ColumnType.TIMESTAMP) {
                return "TIMESTAMP";
            }
            if (info.getColumnType() != ColumnType.DATETIME) throw new RuntimeException("Not support type : " + infoType + "," + info.getColumnType().name());
            return "DATE";
        }
        if (Long.class.getName().equals(infoType)) {
            return "INT8";
        }
        if (Double.class.getName().equals(infoType)) {
            return "NUMERIC(" + rdColumn.precision() + "," + rdColumn.scale() + ")";
        }
        if (Float.class.getName().equals(infoType)) {
            if (info.getColumnType() != ColumnType.REAL) return "FLOAT8";
            return "float4";
        }
        if (BigDecimal.class.getName().equals(infoType)) {
            return "NUMERIC(" + rdColumn.precision() + "," + rdColumn.scale() + ")";
        }
        if (!byte[].class.getName().equals(infoType)) throw new RuntimeException("Not support type : " + infoType + "," + info.getColumnType().name());
        return "BYTEA";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getColumnType(TableColumn column) {
        String type = "";
        String className = column.getColumnClass();
        if (String.class.getName().equals(className)) {
            if (column.getColumnType() == ColumnType.TEXT) {
                return "TEXT";
            }
            if (column.getColumnType() == ColumnType.BLOB) {
                return "BYTEA";
            }
            if (column.getColumnType() == ColumnType.CLOB) {
                return "BYTEA";
            }
            if (column.getColumnType() == ColumnType.BINARY) {
                return "BYTEA";
            }
            if (column.getColumnType() != ColumnType.CHAR) return "VARCHAR(" + column.getLength() + ")";
            return "BPCHAR(" + column.getLength() + ")";
        }
        if (Integer.class.getName().equals(className)) {
            return "INT4";
        }
        if (Date.class.getName().equals(className)) {
            if (column.getColumnType() == ColumnType.LONG) {
                return "NUMERIC(" + column.getPrecision() + ", 0)";
            }
            if (column.getColumnType() == ColumnType.TIMESTAMP) {
                return "TIMESTAMP";
            }
            if (column.getColumnType() != ColumnType.DATETIME) throw new RuntimeException("Not support type : " + className + "," + (Object)((Object)column.getColumnType()));
            return "DATE";
        }
        if (Long.class.getName().equals(className)) {
            return "INT8";
        }
        if (Double.class.getName().equals(className)) {
            return "NUMERIC(" + column.getPrecision() + "," + column.getScale() + ")";
        }
        if (Float.class.getName().equals(className)) {
            if (column.getColumnType() != ColumnType.REAL) return "FLOAT8";
            return "float4";
        }
        if (BigDecimal.class.getName().equals(className)) {
            return "NUMERIC(" + column.getPrecision() + "," + column.getScale() + ")";
        }
        if (!byte[].class.getName().equals(className)) throw new RuntimeException("Not support type : " + className + "," + (Object)((Object)column.getColumnType()));
        return "BYTEA";
    }

    @Override
    public String getClassName(TableColumn column) {
        if ("TEXT".equalsIgnoreCase(column.getType()) || "BYTEA".equalsIgnoreCase(column.getType()) || "BPCHAR".equalsIgnoreCase(column.getType()) || "VARCHAR".equalsIgnoreCase(column.getType())) {
            return String.class.getName();
        }
        if ("INT4".equalsIgnoreCase(column.getType())) {
            return Integer.class.getName();
        }
        if ("INT8".equalsIgnoreCase(column.getType())) {
            return Long.class.getName();
        }
        if ("float4".equalsIgnoreCase(column.getType()) || "FLOAT8".equalsIgnoreCase(column.getType())) {
            return Float.class.getName();
        }
        if ("TIMESTAMP".equalsIgnoreCase(column.getType()) || "DATE".equalsIgnoreCase(column.getType())) {
            return Date.class.getName();
        }
        if ("NUMERIC".equalsIgnoreCase(column.getType())) {
            if (column.getScale() != null && column.getScale() == 0) {
                if (column.getPrecision() != null && column.getPrecision() == 15) {
                    return Date.class.getName();
                }
                if (column.getPrecision() != null && column.getPrecision() < 18 && column.getPrecision() >= 10) {
                    return Long.class.getName();
                }
                if (column.getPrecision() != null && column.getPrecision() <= 9) {
                    return Integer.class.getName();
                }
                return BigDecimal.class.getName();
            }
            return Double.class.getName();
        }
        throw new RuntimeException("Not support type : " + column.getColumn() + "," + column.getType());
    }
}

