/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.option;

import com.ursful.framework.orm.IBaseQuery;
import com.ursful.framework.orm.IMultiQuery;
import com.ursful.framework.orm.IQuery;
import com.ursful.framework.orm.annotation.RdColumn;
import com.ursful.framework.orm.annotation.RdForeignKey;
import com.ursful.framework.orm.annotation.RdSort;
import com.ursful.framework.orm.annotation.RdSortOption;
import com.ursful.framework.orm.annotation.RdTable;
import com.ursful.framework.orm.annotation.RdUniqueKey;
import com.ursful.framework.orm.exception.ORMError;
import com.ursful.framework.orm.exception.ORMException;
import com.ursful.framework.orm.query.QueryUtils;
import com.ursful.framework.orm.support.CaseColumn;
import com.ursful.framework.orm.support.Column;
import com.ursful.framework.orm.support.ColumnInfo;
import com.ursful.framework.orm.support.ColumnType;
import com.ursful.framework.orm.support.Condition;
import com.ursful.framework.orm.support.ConditionObject;
import com.ursful.framework.orm.support.DataType;
import com.ursful.framework.orm.support.DatabaseTypeHolder;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.ExpressionType;
import com.ursful.framework.orm.support.Join;
import com.ursful.framework.orm.support.OperatorType;
import com.ursful.framework.orm.support.Options;
import com.ursful.framework.orm.support.Order;
import com.ursful.framework.orm.support.Pair;
import com.ursful.framework.orm.support.QueryInfo;
import com.ursful.framework.orm.support.SQLPair;
import com.ursful.framework.orm.support.TextTransformType;
import com.ursful.framework.orm.utils.ORMUtils;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.rowset.serial.SerialClob;
import org.springframework.util.StringUtils;

public abstract class AbstractOptions
implements Options {
    @Override
    public QueryInfo doQuery(IQuery query) {
        return this.doQuery(query, null);
    }

    public abstract boolean preSetParameter(PreparedStatement var1, Connection var2, String var3, int var4, Pair var5) throws SQLException;

    @Override
    public boolean tableExists(Connection connection, RdTable rdTable) throws ORMException {
        if (rdTable == null) {
            throw new ORMException(ORMError.TABLE_ANNOTATION_IS_NULL, new String[0]);
        }
        String tableName = this.getCaseSensitive(rdTable.name(), rdTable.sensitive());
        return this.tableExists(connection, tableName);
    }

    protected String getCoding(Pair pair) {
        String defaultCoding = "UTF-8";
        if (pair == null) {
            return defaultCoding;
        }
        Map<String, Object> metadata = pair.getMetadata();
        if (metadata != null && metadata.containsKey("coding")) {
            defaultCoding = (String)metadata.get("coding");
        }
        return defaultCoding;
    }

    @Override
    public void setParameter(PreparedStatement ps, Connection connection, String databaseType, int i, Pair pair) throws SQLException {
        Object obj = pair.getValue();
        ColumnType columnType = pair.getColumnType();
        DataType type = DataType.getDataType(pair.getType());
        boolean hasSet = this.preSetParameter(ps, connection, databaseType, i, pair);
        if (hasSet) {
            return;
        }
        switch (type) {
            case BINARY: {
                if (obj != null) {
                    if (obj instanceof byte[]) {
                        ps.setBinaryStream(i + 1, new ByteArrayInputStream((byte[])obj));
                        break;
                    }
                    try {
                        ps.setBinaryStream(i + 1, new ByteArrayInputStream(obj.toString().getBytes(this.getCoding(pair))));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ps.setBinaryStream(i + 1, null);
                break;
            }
            case STRING: {
                if (columnType == ColumnType.BINARY) {
                    if (obj != null) {
                        try {
                            ps.setBinaryStream(i + 1, new ByteArrayInputStream(obj.toString().getBytes(this.getCoding(pair))));
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    ps.setBinaryStream(i + 1, null);
                    break;
                }
                if (columnType == ColumnType.BLOB) {
                    if (obj != null) {
                        try {
                            ps.setBlob(i + 1, new ByteArrayInputStream(obj.toString().getBytes(this.getCoding(pair))));
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    ps.setBinaryStream(i + 1, null);
                    break;
                }
                if (columnType == ColumnType.CLOB) {
                    SerialClob clob = null;
                    if (obj != null) {
                        clob = new SerialClob(obj.toString().toCharArray());
                    }
                    ps.setClob(i + 1, clob);
                    break;
                }
                if (obj != null && "".equals(obj.toString().trim())) {
                    obj = null;
                }
                ps.setString(i + 1, (String)obj);
                break;
            }
            case DATE: {
                if (obj == null) {
                    ps.setObject(i + 1, null);
                    break;
                }
                if (columnType == ColumnType.LONG) {
                    if (obj instanceof Long) {
                        ps.setLong(i + 1, (Long)obj);
                        break;
                    }
                    ps.setLong(i + 1, ((java.util.Date)obj).getTime());
                    break;
                }
                if (columnType == ColumnType.DATETIME) {
                    java.util.Date date = (java.util.Date)obj;
                    ps.setTimestamp(i + 1, new Timestamp(date.getTime()));
                    break;
                }
                if (columnType == ColumnType.DATE) {
                    java.util.Date date = (java.util.Date)obj;
                    ps.setDate(i + 1, new Date(date.getTime()));
                    break;
                }
                if (columnType == ColumnType.TIME) {
                    java.util.Date date = (java.util.Date)obj;
                    ps.setTime(i + 1, new Time(date.getTime()));
                    break;
                }
                if (columnType == ColumnType.YEAR) {
                    java.util.Date date = (java.util.Date)obj;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    ps.setInt(i + 1, calendar.get(1));
                    break;
                }
                ps.setTimestamp(i + 1, new Timestamp(((java.util.Date)obj).getTime()));
                break;
            }
            case DECIMAL: {
                if (obj == null) {
                    ps.setObject(i + 1, null);
                    break;
                }
                BigDecimal decimal = (BigDecimal)obj;
                Map<String, Object> metadata = pair.getMetadata();
                int runningMode = 7;
                int scale = decimal.scale();
                if (metadata != null) {
                    Integer mode;
                    Integer scaleValue = (Integer)metadata.get("scale");
                    int newScale = scale;
                    if (scaleValue != null) {
                        newScale = scaleValue;
                    }
                    if ((mode = (Integer)metadata.get("runningMode")) != null && mode > -1) {
                        runningMode = mode;
                        scale = newScale;
                    } else if (ORMUtils.getRunningMode() > -1) {
                        runningMode = ORMUtils.getRunningMode();
                        scale = newScale;
                    }
                } else if (ORMUtils.getRunningMode() > -1) {
                    runningMode = ORMUtils.getRunningMode();
                }
                BigDecimal setScale = decimal.setScale(scale, runningMode);
                ps.setBigDecimal(i + 1, setScale);
                break;
            }
            case DOUBLE: {
                ps.setObject(i + 1, obj);
                break;
            }
            default: {
                ps.setObject(i + 1, obj);
            }
        }
    }

    @Override
    public QueryInfo doQueryCount(IQuery query) {
        QueryInfo info = new QueryInfo();
        ArrayList<Pair> values = new ArrayList<Pair>();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        String groups = this.groups(query, null);
        if (query.isDistinct()) {
            sb.append(this.selectColumns(query, null, null, values));
        } else if (!ORMUtils.isEmpty(groups)) {
            List<Column> groupSelect = query.getGroupCountSelectColumns();
            if (groupSelect == null || groupSelect.isEmpty()) {
                sb.append(this.selectColumns(query, null, null, values));
            } else {
                sb.append(this.groupCountSelect(query));
            }
        } else {
            sb.append(this.selectCount());
        }
        sb.append(" FROM ");
        sb.append(this.tables(query, values, null));
        if (query instanceof IMultiQuery) {
            sb.append(this.joins((IMultiQuery)query, values));
        }
        sb.append(this.wheres(query, values, null));
        sb.append(groups);
        sb.append(this.havings(query, values, null));
        info.setClazz(Integer.class);
        if (query.isDistinct()) {
            info.setSql("SELECT COUNT(*) FROM (" + sb.toString() + ")  distinct_table_");
        } else if (ORMUtils.isEmpty(groups)) {
            info.setSql(sb.toString());
        } else {
            info.setSql("SELECT COUNT(*) FROM (" + sb.toString() + ")  group_table_");
        }
        info.setValues(values);
        if (TextTransformType.LOWER == query.textTransformType()) {
            info.setSql(info.getSql().toLowerCase(Locale.ROOT));
        } else if (TextTransformType.UPPER == query.textTransformType()) {
            info.setSql(info.getSql().toUpperCase(Locale.ROOT));
        }
        return info;
    }

    public String selectCount() {
        return " COUNT(*) ";
    }

    public String selectColumns(IQuery query, String alias, Map<String, String> asNames, List<Pair> values) {
        if (asNames == null) {
            asNames = new HashMap<String, String>();
        }
        StringBuffer sb = new StringBuffer();
        if (query.isDistinct()) {
            sb.append(" DISTINCT ");
        }
        List<Column> returnColumns = query.getFinalReturnColumns();
        ArrayList<String> temp = new ArrayList<String>();
        ArrayList<String> allAlias = new ArrayList<String>();
        boolean noAlias = false;
        if (returnColumns.isEmpty()) {
            String all = null;
            if (ORMUtils.isEmpty(alias)) {
                noAlias = true;
                all = "*";
            } else {
                allAlias.add(alias);
                all = alias + "." + "*";
            }
            temp.add(all);
        } else {
            for (Column column : returnColumns) {
                String tempSQL;
                if (column.getQuery() != null) {
                    QueryInfo queryInfo = this.doQuery(column.getQuery());
                    String tempSQL2 = null;
                    tempSQL2 = ORMUtils.isEmpty(column.getAsName()) ? "(" + queryInfo.getSql() + ")" : "(" + queryInfo.getSql() + ") AS " + column.getAsName();
                    if (temp.contains(tempSQL2)) continue;
                    temp.add(tempSQL2);
                    values.addAll(queryInfo.getValues());
                    continue;
                }
                if (column.getAlias() == null && !ORMUtils.isEmpty(alias)) {
                    column.setAlias(alias);
                }
                if (temp.contains(tempSQL = this.parseColumn(column))) continue;
                temp.add(tempSQL);
                String fm = this.parseColumn(column);
                String word = " AS ";
                int index = fm.indexOf(word);
                if (index > -1) {
                    String asName = fm.substring(index + word.length());
                    asNames.put(asName.trim(), fm.substring(0, index));
                }
                if (!"*".equals(column.getName())) continue;
                if (!ORMUtils.isEmpty(column.getAlias()) && !allAlias.contains(column.getAlias())) {
                    allAlias.add(column.getAlias());
                    continue;
                }
                noAlias = true;
            }
        }
        sb.append(ORMUtils.join(temp, ","));
        if (sb.length() == 0) {
            if (ORMUtils.isEmpty(alias)) {
                sb.append("*");
            } else {
                sb.append(alias + "." + "*");
            }
        }
        return sb.toString();
    }

    public String groupCountSelect(IQuery query) {
        List<Column> otherColumns = query.getGroupCountSelectColumns();
        ArrayList<String> temp = new ArrayList<String>();
        for (Column column : otherColumns) {
            String sql = this.parseColumn(column);
            if (temp.contains(sql)) continue;
            temp.add(sql);
        }
        return ORMUtils.join(temp, ",");
    }

    public String orders(IQuery query, String alias, Map<String, String> asNames) {
        if (asNames == null) {
            asNames = new HashMap<String, String>();
        }
        String result = "";
        List<Order> orders = query.getOrders();
        for (Order order : orders) {
            Column column = order.getColumn();
            if (!ORMUtils.isEmpty(column.getAlias())) continue;
            String key = column.getName().toUpperCase(Locale.ROOT);
            if (!asNames.containsKey(key)) {
                QueryUtils.setColumnAlias(order.getColumn(), alias);
                continue;
            }
            column.setName(asNames.get(key));
        }
        HashMap<String, Class> aliasClass = new HashMap<String, Class>();
        if (query instanceof IBaseQuery) {
            aliasClass.put(alias, ((IBaseQuery)query).getTable());
        } else if (query instanceof IMultiQuery) {
            Object aliasObject;
            IMultiQuery multiQuery = (IMultiQuery)query;
            List<Join> joins = multiQuery.getJoins();
            for (Join join : joins) {
                String joinAlias = join.getAlias();
                aliasObject = join.getTable();
                if (!(aliasObject instanceof Class)) continue;
                aliasClass.put(joinAlias, (Class)aliasObject);
            }
            Map<String, Object> table = multiQuery.getAliasTable();
            for (String aliasName : table.keySet()) {
                aliasObject = table.get(aliasName);
                if (!(aliasObject instanceof Class)) continue;
                aliasClass.put(aliasName, (Class)aliasObject);
            }
        }
        String orderString = this.getOrders(orders, aliasClass);
        if (orderString != null && !"".equals(orderString)) {
            result = " ORDER BY " + orderString;
        }
        return result;
    }

    public String tables(IQuery query, List<Pair> values, String tableAlias) {
        if (query instanceof IBaseQuery) {
            String tableName = ORMUtils.getTableName(query.getTable());
            if (tableAlias == null) {
                return tableName;
            }
            return tableName + " " + tableAlias;
        }
        IMultiQuery multiQuery = (IMultiQuery)query;
        ArrayList<String> words = new ArrayList<String>();
        Map<String, Object> aliasMap = multiQuery.getAliasTable();
        List<String> aliasList = multiQuery.getAliasList();
        for (String alias : aliasList) {
            if (!aliasMap.containsKey(alias)) continue;
            Object object = aliasMap.get(alias);
            if (object instanceof Class) {
                String tn = ORMUtils.getTableName((Class)object);
                words.add(tn + " " + alias);
                continue;
            }
            if (object instanceof IQuery) {
                IQuery q = (IQuery)aliasMap.get(alias);
                QueryInfo queryInfo = this.doQuery(q, q.getPageable());
                words.add("(" + queryInfo.getSql() + ") " + alias);
                values.addAll(queryInfo.getValues());
                continue;
            }
            words.add(object.toString() + " " + alias);
        }
        return ORMUtils.join(words, ",");
    }

    public String wheres(IQuery query, List<Pair> values, String tableAlias) {
        String result = "";
        List<Condition> conditions = query.getConditions();
        QueryUtils.setConditionsAlias(conditions, tableAlias);
        String whereCondition = this.getConditions(query, conditions, values);
        if (whereCondition != null && !"".equals(whereCondition)) {
            result = " WHERE " + whereCondition;
        }
        return result;
    }

    public String groups(IQuery query, String alias) {
        String result = "";
        List<Column> columns = query.getGroups();
        QueryUtils.setColumnsAlias(columns, alias);
        String groupString = this.getGroups(columns);
        if (groupString != null && !"".equals(groupString)) {
            result = " GROUP BY " + groupString;
        }
        return result;
    }

    public String havings(IQuery query, List<Pair> values, String alias) {
        String result = "";
        List<Condition> conditions = query.getHavings();
        QueryUtils.setConditionsAlias(conditions, alias);
        String havingString = this.getConditions(query, conditions, values);
        if (havingString != null && !"".equals(havingString)) {
            result = " HAVING " + havingString;
        }
        return result;
    }

    public String joins(IMultiQuery obj, List<Pair> values) {
        List<Join> joins = obj.getJoins();
        StringBuffer sb = new StringBuffer();
        if (joins == null) {
            return sb.toString();
        }
        for (int i = 0; i < joins.size(); ++i) {
            Join join = joins.get(i);
            String tableName = null;
            Object table = join.getTable();
            if (table instanceof Class) {
                tableName = ORMUtils.getTableName((Class)table);
            } else if (table instanceof IQuery) {
                QueryInfo info = this.doQuery((IQuery)table, null);
                tableName = "(" + info.getSql() + ") ";
                values.addAll(info.getValues());
            } else {
                tableName = join.getTable().toString();
            }
            switch (join.getType()) {
                case FULL_JOIN: {
                    sb.append(" FULL JOIN ");
                    break;
                }
                case INNER_JOIN: {
                    sb.append(" INNER JOIN ");
                    break;
                }
                case LEFT_JOIN: {
                    sb.append(" LEFT JOIN ");
                    break;
                }
                case RIGHT_JOIN: {
                    sb.append(" RIGHT JOIN ");
                }
            }
            String alias = join.getAlias();
            sb.append(tableName + " " + alias);
            List<Condition> temp = join.getConditions();
            String cdt = this.getConditions(obj, temp, values);
            if (cdt == null || "".equals(cdt)) continue;
            sb.append(" ON ");
            sb.append(cdt);
        }
        return sb.toString();
    }

    protected String getForeignSQL(RdTable table, RdColumn rdColumn, RdForeignKey foreign) {
        if (foreign == null) {
            return null;
        }
        String foreignKey = foreign.name();
        String foreignTable = ORMUtils.getTableName(foreign.foreignTable());
        String foreignColumn = ORMUtils.join(foreign.foreignColumns(), ",");
        String column = ORMUtils.join(foreign.columns(), ",");
        if (ORMUtils.isEmpty(column)) {
            column = rdColumn.name();
        }
        ORMUtils.whenEmpty(foreignKey, "Foreign Key Name Should Not Be Empty.");
        ORMUtils.whenEmpty(foreignTable, "Foreign Table Should Not Be Empty.");
        ORMUtils.whenEmpty(foreignColumn, "Foreign Column Should Not Be Empty.");
        return String.format("CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s)", foreignKey, column, foreignTable, foreignColumn);
    }

    protected String getUniqueSQL(RdTable table, RdColumn rdColumn, RdUniqueKey uniqueKey) {
        if (uniqueKey == null) {
            return null;
        }
        String uniqueName = uniqueKey.name();
        String[] uniqueKeys = uniqueKey.columns();
        String uniqueKeysStr = ORMUtils.join(uniqueKeys, ",");
        if (ORMUtils.isEmpty(uniqueKeysStr)) {
            uniqueKeysStr = rdColumn.name();
        }
        return String.format("CONSTRAINT %s UNIQUE(%s)", uniqueName, uniqueKeysStr);
    }

    protected String columnComment(RdColumn rdColumn) {
        String comment = null;
        if (!ORMUtils.isEmpty(rdColumn.title())) {
            comment = rdColumn.title();
            if (!ORMUtils.isEmpty(rdColumn.description())) {
                comment = comment + ";" + rdColumn.description();
            }
        }
        return comment;
    }

    abstract String getColumnType(ColumnInfo var1, RdColumn var2);

    public SQLPair parseExpression(Class clazz, Map<String, Object> clazzes, Expression expression) {
        SQLPair sqlPair = null;
        if (expression == null) {
            return sqlPair;
        }
        if (expression.getLeft() == null) {
            if (expression.getValue() instanceof IMultiQuery) {
                IMultiQuery mq = (IMultiQuery)expression.getValue();
                QueryInfo qinfo = mq.doQuery();
                if (expression.getType() == ExpressionType.CDT_EXISTS) {
                    sqlPair = new SQLPair("EXISTS(" + qinfo.getSql() + ")", qinfo.getValues());
                } else if (expression.getType() == ExpressionType.CDT_NOT_EXISTS) {
                    sqlPair = new SQLPair("NOT EXISTS(" + qinfo.getSql() + ")", qinfo.getValues());
                }
            }
            return sqlPair;
        }
        String conditionName = this.parseColumn(expression.getLeft());
        switch (expression.getType()) {
            case CDT_IS_NULL: {
                sqlPair = new SQLPair(" " + conditionName + " IS NULL ");
                break;
            }
            case CDT_IS_NOT_NULL: {
                sqlPair = new SQLPair(" " + conditionName + " IS NOT NULL ");
                break;
            }
            case CDT_IS_EMPTY: {
                sqlPair = new SQLPair(" " + conditionName + " = '' ");
                break;
            }
            case CDT_IS_NOT_EMPTY: {
                sqlPair = new SQLPair(" " + conditionName + " != '' ");
                break;
            }
        }
        if (sqlPair != null) {
            return sqlPair;
        }
        Object conditionValue = expression.getValue();
        boolean isTrim = ORMUtils.isTrim();
        if (isTrim && conditionValue instanceof String) {
            conditionValue = ((String)conditionValue).trim();
        }
        if (conditionValue != null) {
            if (conditionValue instanceof Column) {
                String valueSQL = this.parseColumn((Column)conditionValue);
                if (expression.getType() == null) {
                    sqlPair = new SQLPair(conditionName + " = " + valueSQL);
                } else {
                    switch (expression.getType()) {
                        case CDT_EQUAL: {
                            sqlPair = new SQLPair(" " + conditionName + " = " + valueSQL);
                            break;
                        }
                        case CDT_NOT_EQUAL: {
                            sqlPair = new SQLPair(" " + conditionName + " != " + valueSQL);
                            break;
                        }
                        case CDT_MORE: {
                            sqlPair = new SQLPair(" " + conditionName + " > " + valueSQL);
                            break;
                        }
                        case CDT_MORE_EQUAL: {
                            sqlPair = new SQLPair(" " + conditionName + " >= " + valueSQL);
                            break;
                        }
                        case CDT_LESS: {
                            sqlPair = new SQLPair(" " + conditionName + " < " + valueSQL);
                            break;
                        }
                        case CDT_LESS_EQUAL: {
                            sqlPair = new SQLPair(" " + conditionName + " <= " + valueSQL);
                        }
                    }
                }
                if (sqlPair != null) {
                    return sqlPair;
                }
            } else if (conditionValue instanceof IQuery) {
                QueryInfo newQueryInfo = this.doQuery((IQuery)conditionValue);
                String sql = null;
                sql = ExpressionType.CDT_IN == expression.getType() ? String.format(" %s IN (%s) ", conditionName, newQueryInfo.getSql()) : String.format(" %s NOT IN (%s) ", conditionName, newQueryInfo.getSql());
                if (sql != null) {
                    sqlPair = new SQLPair(sql, newQueryInfo.getValues());
                    return sqlPair;
                }
            }
        }
        if (!ORMUtils.isEmpty(conditionValue)) {
            Object object;
            Column column = expression.getLeft();
            ColumnInfo columnInfo = null;
            if (ORMUtils.isEmpty(column.getAlias()) && clazz != null) {
                Map<String, ColumnInfo> pairMap = ORMUtils.getColumnColumnInfo(clazz);
                columnInfo = pairMap.get(column.getName());
            } else if (clazzes != null && clazzes.containsKey(column.getAlias()) && (object = clazzes.get(column.getAlias())) instanceof Class) {
                Map<String, ColumnInfo> pairMap = ORMUtils.getColumnColumnInfo((Class)object);
                columnInfo = pairMap.get(column.getName());
            }
            switch (expression.getType()) {
                case CDT_EQUAL: {
                    sqlPair = new SQLPair(" " + conditionName + " = ?", new Pair(columnInfo, conditionValue));
                    break;
                }
                case CDT_NOT_EQUAL: {
                    sqlPair = new SQLPair(" " + conditionName + " != ?", new Pair(columnInfo, conditionValue));
                    break;
                }
                case CDT_MORE: {
                    sqlPair = new SQLPair(" " + conditionName + " > ?", new Pair(columnInfo, conditionValue));
                    break;
                }
                case CDT_MORE_EQUAL: {
                    sqlPair = new SQLPair(" " + conditionName + " >= ?", new Pair(columnInfo, conditionValue));
                    break;
                }
                case CDT_LESS: {
                    sqlPair = new SQLPair(" " + conditionName + " < ?", new Pair(columnInfo, conditionValue));
                    break;
                }
                case CDT_LESS_EQUAL: {
                    sqlPair = new SQLPair(" " + conditionName + " <= ?", new Pair(columnInfo, conditionValue));
                    break;
                }
                case CDT_LIKE: {
                    sqlPair = new SQLPair(" " + conditionName + " LIKE ?", new Pair(columnInfo, (Object)("%" + conditionValue + "%")));
                    break;
                }
                case CDT_NOT_LIKE: {
                    sqlPair = new SQLPair(" " + conditionName + " NOT LIKE ?", new Pair(columnInfo, (Object)("%" + conditionValue + "%")));
                    break;
                }
                case CDT_END_WITH: {
                    sqlPair = new SQLPair(" " + conditionName + " LIKE ?", new Pair(columnInfo, (Object)("%" + conditionValue)));
                    break;
                }
                case CDT_START_WITH: {
                    sqlPair = new SQLPair(" " + conditionName + " LIKE ?", new Pair(columnInfo, (Object)(conditionValue + "%")));
                    break;
                }
                case CDT_NOT_END_WITH: {
                    sqlPair = new SQLPair(" " + conditionName + " NOT LIKE ?", new Pair(columnInfo, (Object)("%" + conditionValue)));
                    break;
                }
                case CDT_NOT_START_WITH: {
                    sqlPair = new SQLPair(" " + conditionName + " NOT LIKE ?", new Pair(columnInfo, (Object)(conditionValue + "%")));
                    break;
                }
                case CDT_BETWEEN: {
                    ArrayList<Pair> vs = new ArrayList<Pair>();
                    StringBuffer btSql = new StringBuffer(" (" + conditionName + " BETWEEN ");
                    if (expression.getValue() instanceof Column) {
                        btSql.append(this.parseColumn((Column)expression.getValue()));
                    } else {
                        btSql.append("?");
                        vs.add(new Pair(columnInfo, conditionValue));
                    }
                    btSql.append(" AND ");
                    if (expression.getAndValue() instanceof Column) {
                        btSql.append(this.parseColumn((Column)expression.getAndValue()));
                    } else {
                        btSql.append("?");
                        Object andConditionValue = expression.getAndValue();
                        if (andConditionValue instanceof String && isTrim) {
                            andConditionValue = ((String)andConditionValue).trim();
                        }
                        vs.add(new Pair(columnInfo, andConditionValue));
                    }
                    btSql.append(")");
                    sqlPair = new SQLPair(btSql.toString(), vs);
                    break;
                }
                case CDT_IN: 
                case CDT_NOT_IN: {
                    if (!Collection.class.isAssignableFrom(conditionValue.getClass())) break;
                    ArrayList<String> names = new ArrayList<String>();
                    ArrayList<Pair> values = new ArrayList<Pair>();
                    for (Object obj : (Collection)conditionValue) {
                        if (obj == null) continue;
                        if (isTrim && obj instanceof String) {
                            String obj2 = ((String)obj).trim();
                            if ("".equals(obj2)) continue;
                            names.add("?");
                            values.add(new Pair(columnInfo, obj));
                            continue;
                        }
                        names.add("?");
                        values.add(new Pair(columnInfo, obj));
                    }
                    if (names.isEmpty()) break;
                    if (expression.getType() == ExpressionType.CDT_IN) {
                        sqlPair = new SQLPair(" " + conditionName + " IN (" + ORMUtils.join(names, ",") + ")", values);
                        break;
                    }
                    sqlPair = new SQLPair(" " + conditionName + " NOT IN (" + ORMUtils.join(names, ",") + ")", values);
                    break;
                }
            }
        }
        return sqlPair;
    }

    @Override
    public String parseColumn(Column column) {
        if (column == null) {
            throw new RuntimeException("QUERY_SQL_COLUMN_IS_NULL this column is null");
        }
        StringBuffer sb = new StringBuffer();
        if (column instanceof CaseColumn) {
            CaseColumn caseColumn = (CaseColumn)column;
            StringBuffer caseSql = new StringBuffer();
            Map<Condition, Object> conditionMap = caseColumn.getConditions();
            Set<Condition> conditions = conditionMap.keySet();
            caseSql.append("CASE ");
            for (Condition condition : conditions) {
                Object value = conditionMap.get(condition);
                caseSql.append("WHEN " + this.parseConditions(condition) + " THEN " + this.parseCaseColumnValue(value) + " ");
            }
            Object eObject = caseColumn.getElseValue();
            caseSql.append("ELSE " + this.parseCaseColumnValue(eObject) + " END");
            if (StringUtils.isEmpty((Object)caseColumn.getFunction())) {
                sb.append("(" + caseSql.toString() + ")");
            } else {
                sb.append(caseColumn.getFunction() + "(" + caseSql.toString() + ")");
            }
            if (!StringUtils.isEmpty((Object)column.getAsName())) {
                sb.append(" AS " + column.getAsName());
            }
            return sb.toString();
        }
        if (column.getName() == null && ORMUtils.isEmpty(column.getAlias())) {
            throw new RuntimeException("QUERY_SQL_NAME_IS_NULL this column name is null.");
        }
        if (column.getName() == null && !ORMUtils.isEmpty(column.getAsName())) {
            sb.append("NULL AS " + column.getAsName());
            return sb.toString();
        }
        if (!ORMUtils.isEmpty(column.getFunction())) {
            if (!ORMUtils.isEmpty((Object)column.getType())) {
                String result = this.getColumnWithOperatorAndFunction(column);
                sb.append(result);
            } else {
                sb.append(column.getFunction());
                sb.append("(");
                if (!ORMUtils.isEmpty(column.getAlias())) {
                    sb.append(column.getAlias() + ".");
                }
                sb.append(column.getName());
                sb.append(")");
            }
        } else if (!ORMUtils.isEmpty((Object)column.getType())) {
            String result = this.getColumnWithOperator(column);
            sb.append(result);
        } else {
            String aliasName = column.getName();
            if (!ORMUtils.isEmpty(column.getAlias())) {
                aliasName = column.getAlias() + "." + aliasName;
            }
            if (ORMUtils.isEmpty(column.getFormat())) {
                sb.append(aliasName);
            } else if (column.getValue() != null && column.getValue().getClass().isArray()) {
                Object[] objectList = (Object[])column.getValue();
                ArrayList<Object> objects = new ArrayList<Object>();
                for (Object obj : objectList) {
                    if (obj == column) {
                        objects.add(aliasName);
                        continue;
                    }
                    if (obj instanceof Column) {
                        objects.add(this.parseColumn((Column)obj));
                        continue;
                    }
                    objects.add(obj);
                }
                sb.append(String.format(column.getFormat(), objects.toArray(new Object[objects.size()])));
            } else {
                sb.append(String.format(column.getFormat(), aliasName));
            }
        }
        if (!ORMUtils.isEmpty(column.getAsName())) {
            sb.append(" AS " + column.getAsName());
        }
        return sb.toString();
    }

    protected String getColumnWithOperator(Column column) {
        String name = ORMUtils.isEmpty(column.getAlias()) ? column.getName() : column.getAlias() + "." + column.getName();
        String value = null;
        if (column.getValue() instanceof Column) {
            value = "(" + this.parseColumn((Column)column.getValue()) + ")";
        } else if (column.getValue() != null) {
            value = column.getValue().toString();
        }
        String result = this.getColumnWithOperator(column.getType(), name, value);
        if (result == null) {
            result = name + column.getType().getOperator() + value;
        }
        return result;
    }

    public String getColumnWithOperatorAndFunction(Column column) {
        boolean inFunction = column.getOperatorInFunction();
        String name = ORMUtils.isEmpty(column.getAlias()) ? column.getName() : column.getAlias() + "." + column.getName();
        String value = null;
        if (column.getValue() instanceof Column) {
            value = "(" + this.parseColumn((Column)column.getValue()) + ")";
        } else if (column.getValue() != null) {
            value = column.getValue().toString();
        }
        String type = DatabaseTypeHolder.get();
        String function = column.getFunction();
        OperatorType operatorType = column.getType();
        String result = this.getColumnWithOperatorAndFunction(function, inFunction, operatorType, name, value);
        return result;
    }

    public String getOrders(List<Order> orders, Class<?> clazz) {
        HashMap<String, Class> aliasClass = new HashMap<String, Class>();
        aliasClass.put(null, clazz);
        return this.getOrders(orders, aliasClass);
    }

    private ColumnInfo getColumnInfo(Class<?> clazz, String column) {
        if (clazz == null || ORMUtils.isEmpty(column)) {
            return null;
        }
        List<ColumnInfo> columnInfoList = ORMUtils.getColumnInfo(clazz);
        for (ColumnInfo info : columnInfoList) {
            if (!column.equalsIgnoreCase(info.getColumnName())) continue;
            return info;
        }
        return null;
    }

    private String getSortOptionFormat(ColumnInfo columnInfo) {
        RdSortOption[] options;
        if (columnInfo == null) {
            return null;
        }
        RdSort sort = columnInfo.getField().getAnnotation(RdSort.class);
        if (sort == null) {
            return null;
        }
        for (RdSortOption option : options = sort.value()) {
            if (!this.keyword().equalsIgnoreCase(option.keyword())) continue;
            return option.format();
        }
        return null;
    }

    public String parseCaseColumnValue(Object object) {
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof Column) {
            return this.parseColumn((Column)object);
        }
        if (object == null) {
            return "NULL";
        }
        return "'" + object.toString().replace("'", "") + "'";
    }

    public String getOrders(List<Order> orders, Map<String, Class> aliasClass) {
        ArrayList<String> temp = new ArrayList<String>();
        if (orders != null) {
            for (Order order : orders) {
                if (order.getColumn() instanceof CaseColumn) {
                    CaseColumn caseColumn = (CaseColumn)order.getColumn();
                    StringBuffer caseSql = new StringBuffer();
                    Map<Condition, Object> conditionMap = caseColumn.getConditions();
                    Set<Condition> conditions = conditionMap.keySet();
                    caseSql.append("CASE ");
                    for (Condition condition : conditions) {
                        Object value = conditionMap.get(condition);
                        caseSql.append("WHEN " + this.parseConditions(condition) + " THEN " + this.parseCaseColumnValue(value) + " ");
                    }
                    Object eObject = caseColumn.getElseValue();
                    caseSql.append("ELSE " + this.parseCaseColumnValue(eObject) + " END");
                    temp.add("(" + caseSql.toString() + ") " + order.getOrder());
                    continue;
                }
                if (ORMUtils.isEmpty(order.getColumn().getFormat())) {
                    Class clazz = aliasClass.get(order.getColumn().getAlias());
                    ColumnInfo columnInfo = this.getColumnInfo(clazz, order.getColumn().getName());
                    String format = this.getSortOptionFormat(columnInfo);
                    if (ORMUtils.isEmpty(format)) {
                        temp.add(this.parseColumn(order.getColumn()) + " " + order.getOrder());
                        continue;
                    }
                    temp.add(String.format(format, this.parseColumn(order.getColumn())) + " " + order.getOrder());
                    continue;
                }
                temp.add(this.parseColumn(order.getColumn()) + " " + order.getOrder());
            }
        }
        String result = ORMUtils.join(temp, ",");
        return result;
    }

    public String getGroups(List<Column> columns) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Column column : columns) {
            temp.add(this.parseColumn(column));
        }
        String result = ORMUtils.join(temp, ",");
        return result;
    }

    public static String parseColumn(Options options, Column column) {
        return options.parseColumn(column);
    }

    @Override
    public String getConditions(Object queryOrClass, List<Condition> cds, List<Pair> values) {
        StringBuffer sql = new StringBuffer();
        if (cds != null) {
            SQLPair sqlPair = null;
            for (Condition condition : cds) {
                if (condition == null) continue;
                List<ConditionObject> exts = condition.getConditions();
                for (ConditionObject ext : exts) {
                    boolean group = false;
                    Object extObject = ext.getObject();
                    switch (ext.getType()) {
                        case AND: {
                            String sqlCondition;
                            ArrayList<Pair> pairList;
                            if (extObject instanceof Expression) {
                                Expression and = (Expression)extObject;
                                sqlPair = this.parseExpression(queryOrClass, and);
                            } else if (extObject instanceof SQLPair) {
                                sqlPair = (SQLPair)extObject;
                            } else if (extObject instanceof Condition) {
                                pairList = new ArrayList<Pair>();
                                sqlCondition = this.getConditions(queryOrClass, ORMUtils.newList((Condition)extObject), pairList);
                                sqlPair = new SQLPair(sqlCondition, pairList);
                                group = true;
                            }
                            if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) break;
                            if (group) {
                                if (sql.length() == 0) {
                                    sql.append("(" + sqlPair.getSql() + ")");
                                } else {
                                    sql.append(" AND (" + sqlPair.getSql() + ")");
                                }
                            } else if (sql.length() == 0) {
                                sql.append(sqlPair.getSql());
                            } else {
                                sql.append(" AND " + sqlPair.getSql());
                            }
                            if (sqlPair.getPairs() == null) break;
                            values.addAll(sqlPair.getPairs());
                            break;
                        }
                        case OR: {
                            String sqlCondition;
                            ArrayList<Pair> pairList;
                            if (extObject instanceof Expression) {
                                Expression or = (Expression)extObject;
                                sqlPair = this.parseExpression(queryOrClass, or);
                            } else if (extObject instanceof SQLPair) {
                                sqlPair = (SQLPair)extObject;
                            } else if (extObject instanceof Condition) {
                                pairList = new ArrayList();
                                sqlCondition = this.getConditions(queryOrClass, ORMUtils.newList((Condition)extObject), pairList);
                                sqlPair = new SQLPair(sqlCondition, pairList);
                                group = true;
                            }
                            if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) break;
                            if (group) {
                                if (sql.length() == 0) {
                                    sql.append("(" + sqlPair.getSql() + ")");
                                } else {
                                    sql.append(" OR (" + sqlPair.getSql() + ")");
                                }
                            } else if (sql.length() == 0) {
                                sql.append(sqlPair.getSql());
                            } else {
                                sql.append(" OR " + sqlPair.getSql());
                            }
                            if (sqlPair.getPairs() == null) break;
                            values.addAll(sqlPair.getPairs());
                            break;
                        }
                        case AND_OR: {
                            Expression[] aor = (Expression[])extObject;
                            ArrayList<String> aorStr = new ArrayList<String>();
                            for (Expression orOr : aor) {
                                sqlPair = this.parseExpression(queryOrClass, orOr);
                                if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) continue;
                                aorStr.add(sqlPair.getSql());
                                if (sqlPair.getPairs() == null) continue;
                                values.addAll(sqlPair.getPairs());
                            }
                            if (aorStr.size() <= 0) break;
                            if (sql.length() == 0) {
                                sql.append(" (" + ORMUtils.join(aorStr, " OR ") + ") ");
                                break;
                            }
                            sql.append(" AND (" + ORMUtils.join(aorStr, " OR ") + ") ");
                            break;
                        }
                        case OR_AND: {
                            Expression[] ands = (Expression[])extObject;
                            ArrayList<String> andStr = new ArrayList<String>();
                            for (Expression orAnd : ands) {
                                sqlPair = this.parseExpression(queryOrClass, orAnd);
                                if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) continue;
                                andStr.add(sqlPair.getSql());
                                if (sqlPair.getPairs() == null) continue;
                                values.addAll(sqlPair.getPairs());
                            }
                            if (andStr.size() <= 0) break;
                            if (sql.length() == 0) {
                                sql.append(" (" + ORMUtils.join(andStr, " AND ") + ") ");
                                break;
                            }
                            sql.append(" OR (" + ORMUtils.join(andStr, " AND ") + ") ");
                            break;
                        }
                        case OR_OR: {
                            Expression[] ors = (Expression[])extObject;
                            ArrayList<String> orStr = new ArrayList<String>();
                            for (Expression orOr : ors) {
                                sqlPair = this.parseExpression(queryOrClass, orOr);
                                if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) continue;
                                orStr.add(sqlPair.getSql());
                                if (sqlPair.getPairs() == null) continue;
                                values.addAll(sqlPair.getPairs());
                            }
                            if (orStr.size() <= 0) break;
                            if (sql.length() == 0) {
                                sql.append(" (" + ORMUtils.join(orStr, " OR ") + ") ");
                                break;
                            }
                            sql.append(" OR (" + ORMUtils.join(orStr, " OR ") + ") ");
                        }
                    }
                }
            }
        }
        return sql.toString();
    }

    public String parseConditions(Condition condition) {
        StringBuffer sql = new StringBuffer();
        if (condition == null) {
            return sql.toString();
        }
        SQLPair sqlPair = null;
        List<ConditionObject> exts = condition.getConditions();
        ArrayList<Pair> values = new ArrayList<Pair>();
        for (ConditionObject ext : exts) {
            boolean group = false;
            Object extObject = ext.getObject();
            switch (ext.getType()) {
                case AND: {
                    String sqlCondition;
                    ArrayList<Pair> pairList;
                    if (extObject instanceof Expression) {
                        Expression and = (Expression)extObject;
                        sqlPair = this.parseExpression(null, and);
                    } else if (extObject instanceof SQLPair) {
                        sqlPair = (SQLPair)extObject;
                    } else if (extObject instanceof Condition) {
                        pairList = new ArrayList<Pair>();
                        sqlCondition = this.getConditions(null, ORMUtils.newList((Condition)extObject), pairList);
                        sqlPair = new SQLPair(sqlCondition, pairList);
                        group = true;
                    }
                    if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) break;
                    if (group) {
                        if (sql.length() == 0) {
                            sql.append("(" + sqlPair.getSql() + ")");
                        } else {
                            sql.append(" AND (" + sqlPair.getSql() + ")");
                        }
                    } else if (sql.length() == 0) {
                        sql.append(sqlPair.getSql());
                    } else {
                        sql.append(" AND " + sqlPair.getSql());
                    }
                    if (sqlPair.getPairs() == null) break;
                    values.addAll(sqlPair.getPairs());
                    break;
                }
                case OR: {
                    String sqlCondition;
                    ArrayList<Pair> pairList;
                    if (extObject instanceof Expression) {
                        Expression or = (Expression)extObject;
                        sqlPair = this.parseExpression(null, or);
                    } else if (extObject instanceof SQLPair) {
                        sqlPair = (SQLPair)extObject;
                    } else if (extObject instanceof Condition) {
                        pairList = new ArrayList();
                        sqlCondition = this.getConditions(null, ORMUtils.newList((Condition)extObject), pairList);
                        sqlPair = new SQLPair(sqlCondition, pairList);
                        group = true;
                    }
                    if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) break;
                    if (group) {
                        if (sql.length() == 0) {
                            sql.append("(" + sqlPair.getSql() + ")");
                        } else {
                            sql.append(" OR (" + sqlPair.getSql() + ")");
                        }
                    } else if (sql.length() == 0) {
                        sql.append(sqlPair.getSql());
                    } else {
                        sql.append(" OR " + sqlPair.getSql());
                    }
                    if (sqlPair.getPairs() == null) break;
                    values.addAll(sqlPair.getPairs());
                    break;
                }
                case AND_OR: {
                    Expression[] aor = (Expression[])extObject;
                    ArrayList<String> aorStr = new ArrayList<String>();
                    for (Expression orOr : aor) {
                        sqlPair = this.parseExpression(null, orOr);
                        if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) continue;
                        aorStr.add(sqlPair.getSql());
                        if (sqlPair.getPairs() == null) continue;
                        values.addAll(sqlPair.getPairs());
                    }
                    if (aorStr.size() <= 0) break;
                    if (sql.length() == 0) {
                        sql.append(" (" + ORMUtils.join(aorStr, " OR ") + ") ");
                        break;
                    }
                    sql.append(" AND (" + ORMUtils.join(aorStr, " OR ") + ") ");
                    break;
                }
                case OR_AND: {
                    Expression[] ands = (Expression[])extObject;
                    ArrayList<String> andStr = new ArrayList<String>();
                    for (Expression orAnd : ands) {
                        sqlPair = this.parseExpression(null, orAnd);
                        if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) continue;
                        andStr.add(sqlPair.getSql());
                        if (sqlPair.getPairs() == null) continue;
                        values.addAll(sqlPair.getPairs());
                    }
                    if (andStr.size() <= 0) break;
                    if (sql.length() == 0) {
                        sql.append(" (" + ORMUtils.join(andStr, " AND ") + ") ");
                        break;
                    }
                    sql.append(" OR (" + ORMUtils.join(andStr, " AND ") + ") ");
                    break;
                }
                case OR_OR: {
                    Expression[] ors = (Expression[])extObject;
                    ArrayList<String> orStr = new ArrayList<String>();
                    for (Expression orOr : ors) {
                        sqlPair = this.parseExpression(null, orOr);
                        if (sqlPair == null || ORMUtils.isEmpty(sqlPair.getSql())) continue;
                        orStr.add(sqlPair.getSql());
                        if (sqlPair.getPairs() == null) continue;
                        values.addAll(sqlPair.getPairs());
                    }
                    if (orStr.size() <= 0) break;
                    if (sql.length() == 0) {
                        sql.append(" (" + ORMUtils.join(orStr, " OR ") + ") ");
                        break;
                    }
                    sql.append(" OR (" + ORMUtils.join(orStr, " OR ") + ") ");
                }
            }
        }
        String finalSql = sql.toString();
        if (finalSql.length() > 0 && values.size() > 0) {
            for (Pair pair : values) {
                Object value = pair.getValue();
                if (value instanceof Number) {
                    finalSql = finalSql.replaceFirst("\\?", value.toString());
                    continue;
                }
                finalSql = finalSql.replaceFirst("\\?", "'" + value.toString() + "'");
            }
        }
        return finalSql;
    }

    @Override
    public String getConditions(Class clazz, Expression[] expressions, List<Pair> values) {
        ArrayList<String> ands = new ArrayList<String>();
        if (expressions != null) {
            for (int i = 0; i < expressions.length; ++i) {
                SQLPair sqlPair;
                Expression expression = expressions[i];
                if (expression == null || (sqlPair = this.parseExpression(clazz, expression)) == null) continue;
                ands.add(sqlPair.getSql());
                if (sqlPair.getPairs() == null) continue;
                values.addAll(sqlPair.getPairs());
            }
        }
        return ORMUtils.join(ands, " AND ");
    }

    @Override
    public SQLPair parseExpression(Object clazz, Expression expression) {
        if (clazz instanceof Class) {
            return this.parseExpression((Class)clazz, null, expression);
        }
        if (clazz instanceof IQuery) {
            if (clazz instanceof IBaseQuery) {
                return this.parseExpression(((IBaseQuery)clazz).getTable(), null, expression);
            }
            IMultiQuery multiQuery = (IMultiQuery)clazz;
            Map<String, Object> tables = multiQuery.getAliasTable();
            return this.parseExpression(null, tables, expression);
        }
        return this.parseExpression(null, null, expression);
    }

    @Override
    public abstract String getCaseSensitive(String var1, int var2);

    @Override
    public String getTableName(RdTable rdTable) throws ORMException {
        if (rdTable == null) {
            throw new ORMException(ORMError.TABLE_ANNOTATION_IS_NULL, new String[0]);
        }
        String tableName = this.getCaseSensitive(rdTable.name(), rdTable.sensitive());
        if (ORMUtils.isEmpty(tableName)) {
            throw new ORMException(ORMError.TABLE_NAME_IS_EMPTY, new String[0]);
        }
        return tableName;
    }
}

