/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.support;

import com.ursful.framework.orm.support.ConditionObject;
import com.ursful.framework.orm.support.ConditionType;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.SQLPair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Condition
implements Serializable {
    private List<ConditionObject> conditions = new ArrayList<ConditionObject>();

    public List<ConditionObject> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ConditionObject> conditions) {
        this.conditions = conditions;
    }

    public Condition and(Expression ... expressions) {
        if (expressions != null) {
            for (Expression expression : expressions) {
                if (expression == null) continue;
                this.conditions.add(new ConditionObject(expression, ConditionType.AND));
            }
        }
        return this;
    }

    public Condition or(Expression ... expressions) {
        if (expressions != null) {
            for (Expression expression : expressions) {
                if (expression == null) continue;
                this.conditions.add(new ConditionObject(expression, ConditionType.OR));
            }
        }
        return this;
    }

    public Condition or(Condition condition) {
        if (condition != null) {
            this.conditions.add(new ConditionObject(condition, ConditionType.OR));
        }
        return this;
    }

    public Condition and(Condition condition) {
        if (condition != null) {
            this.conditions.add(new ConditionObject(condition, ConditionType.AND));
        }
        return this;
    }

    public Condition orOr(Expression ... expressions) {
        if (expressions != null) {
            this.conditions.add(new ConditionObject(expressions, ConditionType.OR_OR));
        }
        return this;
    }

    public Condition orAnd(Expression ... expressions) {
        if (expressions != null) {
            this.conditions.add(new ConditionObject(expressions, ConditionType.OR_AND));
        }
        return this;
    }

    public Condition andOr(Expression ... expressions) {
        if (expressions != null) {
            this.conditions.add(new ConditionObject(expressions, ConditionType.AND_OR));
        }
        return this;
    }

    public Condition and(SQLPair pair) {
        if (pair != null) {
            this.conditions.add(new ConditionObject(pair, ConditionType.AND));
        }
        return this;
    }

    public Condition or(SQLPair pair) {
        if (pair != null) {
            this.conditions.add(new ConditionObject(pair, ConditionType.OR));
        }
        return this;
    }

    public static Condition create() {
        return new Condition();
    }
}

