/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.support;

import com.ursful.framework.orm.support.ColumnInfo;
import com.ursful.framework.orm.utils.ORMUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ORMOption
implements Serializable {
    private Object original;
    private Object current;
    private boolean updateNull;
    private String[] updateNullColumns;

    public Object getOriginal() {
        return this.original;
    }

    public void setOriginal(Object original) {
        this.original = original;
    }

    public Object getCurrent() {
        return this.current;
    }

    public void setCurrent(Object current) {
        this.current = current;
    }

    public ORMOption() {
    }

    public ORMOption(boolean updateNull, String[] updateNullColumns, Object original, Object current) {
        this.updateNull = updateNull;
        this.updateNullColumns = updateNullColumns;
        this.original = original;
        this.current = current;
    }

    public List<String> getColumnsWhenEmptyValueInNullColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        List<ColumnInfo> infos = this.getColumnsInfoWhenEmptyValueInNullColumns();
        for (ColumnInfo info : infos) {
            columns.add(info.getColumnName());
        }
        return columns;
    }

    public List<ColumnInfo> getColumnsInfoWhenEmptyValueInNullColumns() {
        ArrayList<String> nullColumns = new ArrayList<String>();
        if (this.updateNullColumns != null) {
            nullColumns.addAll(Arrays.asList(this.updateNullColumns));
        }
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>();
        List<ColumnInfo> infos = ORMUtils.getColumnInfo(this.current.getClass());
        if (infos != null) {
            for (ColumnInfo info : infos) {
                Object object;
                if (info.getPrimaryKey().booleanValue() || (object = ORMUtils.getFieldValue(this.current, info)) != null || !this.updateNull && !nullColumns.contains(info.getColumnName())) continue;
                result.add(info);
            }
        }
        return result;
    }

    public boolean isUpdateNull() {
        return this.updateNull;
    }

    public void setUpdateNull(boolean updateNull) {
        this.updateNull = updateNull;
    }

    public String[] getUpdateNullColumns() {
        return this.updateNullColumns;
    }

    public void setUpdateNullColumns(String[] updateNullColumns) {
        this.updateNullColumns = updateNullColumns;
    }
}

