/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.generator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.JsonSerializable;
import com.vaadin.flow.component.NotSupported;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import com.vaadin.generator.ComponentGeneratorUtils;
import com.vaadin.generator.FunctionParameterVariantCombinator;
import com.vaadin.generator.JavaDocFormatter;
import com.vaadin.generator.NestedClassGenerator;
import com.vaadin.generator.exception.ComponentGenerationException;
import com.vaadin.generator.metadata.ComponentBasicType;
import com.vaadin.generator.metadata.ComponentEventData;
import com.vaadin.generator.metadata.ComponentFunctionData;
import com.vaadin.generator.metadata.ComponentMetadata;
import com.vaadin.generator.metadata.ComponentObjectType;
import com.vaadin.generator.metadata.ComponentPropertyBaseData;
import com.vaadin.generator.metadata.ComponentPropertyData;
import com.vaadin.generator.metadata.ComponentType;
import com.vaadin.generator.registry.BehaviorRegistry;
import com.vaadin.generator.registry.ExclusionRegistry;
import com.vaadin.generator.registry.PropertyNameRemapRegistry;
import com.vaadin.generator.registry.ValuePropertyRegistry;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.source.TypeVariableSource;
import org.slf4j.LoggerFactory;

public class ComponentGenerator {
    private static final String JAVADOC_THROWS = "@throws";
    private static final String JAVADOC_SEE = "@see";
    private static final String JAVADOC_PARAM = "@param";
    private static final String JAVADOC_RETURN = "@return";
    private static final String GENERIC_TYPE = "R";
    private static final String GENERIC_TYPE_DECLARATION = "<R>";
    private static final String GENERIC_VAL = "T";
    private static final String GENERIC_VAL_DECLARATION = "<R, T>";
    private static final String PROPERTY_CHANGE_EVENT_POSTFIX = "-changed";
    private ObjectMapper mapper;
    private File jsonFile;
    private File targetPath;
    private String basePackage;
    private String classNamePrefix;
    private String licenseNote;
    private String frontendDirectory = "bower_components/";
    private boolean fluentMethod;
    private boolean protectedMethods;
    private boolean abstractClass;
    private final JavaDocFormatter javaDocFormatter = new JavaDocFormatter();

    protected ComponentMetadata toMetadata(File jsonFile) {
        try {
            return (ComponentMetadata)this.getObjectMapper().readValue(jsonFile, ComponentMetadata.class);
        }
        catch (IOException e) {
            throw new ComponentGenerationException("Error reading JSON file \"" + jsonFile + "\"", e);
        }
    }

    private synchronized ObjectMapper getObjectMapper() {
        if (this.mapper == null) {
            JsonFactory factory = new JsonFactory();
            factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
            this.mapper = new ObjectMapper(factory);
        }
        return this.mapper;
    }

    public ComponentGenerator withFluentMethods(boolean fluentMethods) {
        this.fluentMethod = fluentMethods;
        return this;
    }

    public ComponentGenerator withJsonFile(File jsonFile) {
        this.jsonFile = jsonFile;
        return this;
    }

    public ComponentGenerator withTargetPath(File targetPath) {
        this.targetPath = targetPath;
        return this;
    }

    public ComponentGenerator withBasePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    public ComponentGenerator withLicenseNote(String licenseNote) {
        this.licenseNote = licenseNote;
        return this;
    }

    public ComponentGenerator withFrontendDirectory(String frontendDirectory) {
        if (frontendDirectory == null) {
            return this;
        }
        this.frontendDirectory = !frontendDirectory.endsWith("/") ? frontendDirectory + "/" : frontendDirectory;
        return this;
    }

    public ComponentGenerator withProtectedMethods(boolean protectedMethods) {
        this.protectedMethods = protectedMethods;
        return this;
    }

    public ComponentGenerator withAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
        return this;
    }

    public ComponentGenerator withClassNamePrefix(String classNamePrefix) {
        this.classNamePrefix = classNamePrefix;
        return this;
    }

    public void build() {
        this.generateClass(this.jsonFile, this.targetPath, this.basePackage, this.licenseNote);
    }

    public void generateClass(File jsonFile, File targetPath, String basePackage, String licenseNote) {
        this.generateClass(this.toMetadata(jsonFile), targetPath, basePackage, licenseNote);
    }

    public String generateClass(ComponentMetadata metadata, String basePackage, String licenseNote) {
        JavaClassSource javaClass = this.generateClassSource(metadata, basePackage);
        return this.addLicenseHeaderIfAvailable(javaClass.toString(), licenseNote);
    }

    public String generateClass(File jsonFile, String basePackage, String licenseNote) {
        return this.generateClass(this.toMetadata(jsonFile), basePackage, licenseNote);
    }

    private JavaClassSource generateClassSource(ComponentMetadata metadata, String basePackage) {
        String targetPackage = basePackage;
        String baseUrl = metadata.getBaseUrl();
        if (StringUtils.isNotBlank((CharSequence)baseUrl)) {
            String subPackage;
            if (baseUrl.contains("/src/")) {
                baseUrl = baseUrl.replace("/src/", "/");
            }
            if (StringUtils.isNotBlank((CharSequence)(subPackage = ComponentGeneratorUtils.convertFilePathToPackage(baseUrl)))) {
                int firstDot = subPackage.indexOf(46);
                if (firstDot > 0) {
                    String firstSegment = subPackage.substring(0, firstDot);
                    String lastSegment = subPackage.substring(firstDot + 1);
                    subPackage = lastSegment.replace(".", "");
                    if (!"vaadin".equals(firstSegment)) {
                        subPackage = firstSegment + "." + subPackage;
                    }
                }
                targetPackage = targetPackage + "." + subPackage;
            }
        }
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        ((JavaClassSource)((JavaClassSource)((JavaClassSource)javaClass.setPackage(targetPackage)).setPublic()).setAbstract(this.abstractClass)).setName(this.getGeneratedClassName(metadata.getTag()));
        this.addClassAnnotations(metadata, javaClass);
        this.addInterfaces(metadata, javaClass);
        HashMap<String, MethodSource<JavaClassSource>> propertyToGetterMap = new HashMap<String, MethodSource<JavaClassSource>>();
        if (metadata.getProperties() != null) {
            this.generateEventsForPropertiesWithNotify(metadata);
            this.generateGettersAndSetters(metadata, javaClass, propertyToGetterMap);
        }
        if (metadata.getMethods() != null) {
            metadata.getMethods().stream().filter(function -> !ExclusionRegistry.isMethodExcluded(metadata.getTag(), function.getName())).forEach(function -> this.generateMethodFor(javaClass, (ComponentFunctionData)function));
        }
        if (metadata.getEvents() != null) {
            metadata.getEvents().stream().filter(event -> !ExclusionRegistry.isEventExcluded(metadata.getTag(), event.getName())).forEach(event -> this.generateEventListenerFor(javaClass, metadata, (ComponentEventData)event, (Map<String, MethodSource<JavaClassSource>>)propertyToGetterMap));
        }
        if (metadata.getSlots() != null && !metadata.getSlots().isEmpty()) {
            this.generateAdders(metadata, javaClass);
        }
        if (StringUtils.isNotEmpty((CharSequence)metadata.getDescription())) {
            this.addMarkdownJavaDoc(metadata.getDescription(), javaClass.getJavaDoc());
        }
        boolean hasParent = metadata.getParentTagName() != null;
        boolean hasValue = this.shouldImplementHasValue(metadata, javaClass);
        this.generateConstructors(metadata, javaClass, hasValue, hasParent);
        if (hasValue) {
            ((TypeVariableSource)javaClass.addTypeVariable().setName(GENERIC_TYPE)).setBounds(new String[]{javaClass.getName() + GENERIC_VAL_DECLARATION});
            javaClass.addTypeVariable().setName(GENERIC_VAL);
            if (hasParent) {
                javaClass.setSuperType(this.getGeneratedClassName(metadata.getParentTagName()) + GENERIC_VAL_DECLARATION);
            } else {
                javaClass.setSuperType(AbstractSinglePropertyField.class.getName() + GENERIC_VAL_DECLARATION);
            }
        } else {
            ((TypeVariableSource)javaClass.addTypeVariable().setName(GENERIC_TYPE)).setBounds(new String[]{javaClass.getName() + GENERIC_TYPE_DECLARATION});
            if (hasParent) {
                javaClass.setSuperType(this.getGeneratedClassName(metadata.getParentTagName()) + GENERIC_TYPE_DECLARATION);
            } else {
                javaClass.setSuperType(Component.class);
            }
        }
        for (String s : javaClass.getInterfaces()) {
            if (!s.contains(HasValue.class.getName())) continue;
            javaClass.removeInterface(s);
        }
        return javaClass;
    }

    private void generateEventsForPropertiesWithNotify(ComponentMetadata metadata) {
        metadata.getProperties().stream().filter(property -> !ExclusionRegistry.isPropertyExcluded(metadata.getTag(), property.getName())).filter(ComponentPropertyData::isNotify).forEachOrdered(property -> this.generateEventForPropertyWithNotify(metadata, (ComponentPropertyData)property));
    }

    private void generateEventForPropertyWithNotify(ComponentMetadata metadata, ComponentPropertyData property) {
        String eventName = ComponentGeneratorUtils.convertCamelCaseToHyphens(property.getName()) + PROPERTY_CHANGE_EVENT_POSTFIX;
        List<ComponentEventData> events = metadata.getEvents();
        if (events == null) {
            events = new ArrayList<ComponentEventData>();
            metadata.setEvents(events);
        }
        if (events.stream().anyMatch(event -> event.getName().equals(eventName))) {
            return;
        }
        ComponentEventData event2 = new ComponentEventData();
        event2.setName(eventName);
        event2.setDescription(String.format("Event fired every time the `%s` property is changed.", property.getName()));
        event2.setProperties(Collections.singletonList(property));
        events.add(event2);
    }

    private String getGeneratedClassName(String tagName) {
        return ComponentGeneratorUtils.generateValidJavaClassName((this.classNamePrefix == null ? "" : this.classNamePrefix + "-") + tagName);
    }

    private void generateConstructors(ComponentMetadata metadata, JavaClassSource javaClass, boolean hasValue, boolean hasParent) {
        boolean generateDefaultConstructor = false;
        if (javaClass.hasInterface(HasText.class)) {
            generateDefaultConstructor = true;
            MethodSource constructor = ((MethodSource)javaClass.addMethod().setConstructor(true).setPublic()).setBody("setText(text);");
            constructor.addParameter(String.class.getSimpleName(), "text");
            constructor.getJavaDoc().setText("Sets the given string as the content of this component.").addTagValue(JAVADOC_PARAM, "text the text content to set").addTagValue(JAVADOC_SEE, "HasText#setText(String)");
        } else if (javaClass.hasInterface(HasComponents.class)) {
            generateDefaultConstructor = true;
            MethodSource constructor = ((MethodSource)javaClass.addMethod().setConstructor(true).setPublic()).setBody("add(components);");
            ComponentGeneratorUtils.addMethodParameter(javaClass, (MethodSource<JavaClassSource>)constructor, Component.class, "components").setVarArgs(true);
            constructor.getJavaDoc().setText("Adds the given components as children of this component.").addTagValue(JAVADOC_PARAM, "components the components to add").addTagValue(JAVADOC_SEE, "HasComponents#add(Component...)");
        }
        if (hasValue) {
            generateDefaultConstructor = true;
            this.generateConstructorsForHasValue(metadata, javaClass, hasParent);
        }
        if (generateDefaultConstructor) {
            ((MethodSource)javaClass.addMethod().setConstructor(true).setPublic()).setBody(hasValue ? "this(null, null, null, (SerializableFunction) null, (SerializableFunction) null);" : "").getJavaDoc().setText("Default constructor.");
        }
    }

    private void generateConstructorsForHasValue(ComponentMetadata metadata, JavaClassSource javaClass, boolean hasParent) {
        String propName = ValuePropertyRegistry.valueName(metadata.getTag());
        javaClass.addImport(SerializableFunction.class);
        javaClass.addImport(SerializableBiFunction.class);
        MethodSource ctor = (MethodSource)javaClass.addMethod().setConstructor(true).setPublic();
        String initialValue = "initialValue";
        String defaultValue = "defaultValue";
        String constructorJavadocHeader = "Constructs a new " + this.getGeneratedClassName(metadata.getTag()) + " component with the given arguments.\n@param initialValue the initial value to set to the value\n@param defaultValue the default value to use if the value isn't defined";
        String bodyTemplate = "super(\"%s\",%s);if (initialValue != null) {setModelValue(initialValue, false);setPresentationValue(initialValue);}";
        ctor.addParameter(GENERIC_VAL, "initialValue");
        ctor.addParameter(GENERIC_VAL, "defaultValue");
        ctor.addTypeVariable("P");
        ctor.addParameter("Class<P>", "elementPropertyType");
        ctor.addParameter("SerializableFunction<P, T>", "presentationToModel");
        ctor.addParameter("SerializableFunction<T, P>", "modelToPresentation");
        if (hasParent) {
            ctor.setBody("super(initialValue, defaultValue, elementPropertyType, presentationToModel, modelToPresentation);");
        } else {
            ctor.setBody(String.format("super(\"%s\",%s);if (initialValue != null) {setModelValue(initialValue, false);setPresentationValue(initialValue);}", propName, "defaultValue, elementPropertyType, presentationToModel, modelToPresentation"));
        }
        ctor.getJavaDoc().setText(constructorJavadocHeader + "\n@param elementPropertyType the type of the element property\n@param presentationToModel a function that converts a string value to a model value\n@param modelToPresentation a function that converts a model value to a string value\n@param <P> the property type");
        ctor = (MethodSource)javaClass.addMethod().setConstructor(true).setPublic();
        ctor.addParameter(GENERIC_VAL, "initialValue");
        ctor.addParameter(GENERIC_VAL, "defaultValue");
        ctor.addParameter("boolean", "acceptNullValues");
        if (hasParent) {
            ctor.setBody("super(initialValue, defaultValue, acceptNullValues);");
        } else {
            ctor.setBody(String.format("super(\"%s\",%s);if (initialValue != null) {setModelValue(initialValue, false);setPresentationValue(initialValue);}", propName, "defaultValue, acceptNullValues"));
        }
        ctor.getJavaDoc().setText(constructorJavadocHeader + "\n@param acceptNullValues whether <code>null</code> is accepted as a model value");
        ctor = (MethodSource)javaClass.addMethod().setConstructor(true).setPublic();
        ctor.addParameter(GENERIC_VAL, "initialValue");
        ctor.addParameter(GENERIC_VAL, "defaultValue");
        ctor.addTypeVariable("P");
        ctor.addParameter("Class<P>", "elementPropertyType");
        ctor.addParameter("SerializableBiFunction<R, P, T>", "presentationToModel");
        ctor.addParameter("SerializableBiFunction<R, T, P>", "modelToPresentation");
        if (hasParent) {
            ctor.setBody("super(initialValue, defaultValue, elementPropertyType, presentationToModel, modelToPresentation);");
        } else {
            ctor.setBody(String.format("super(\"%s\",%s);if (initialValue != null) {setModelValue(initialValue, false);setPresentationValue(initialValue);}", propName, "defaultValue, elementPropertyType, presentationToModel, modelToPresentation"));
        }
        ctor.getJavaDoc().setText(constructorJavadocHeader + "\n@param elementPropertyType the type of the element property\n@param presentationToModel a function that accepts this component and a property value and returns a model value\n@param modelToPresentation a function that accepts this component and a model value and returns a property value\n@param <P> the property type");
    }

    private void addInterfaces(ComponentMetadata metadata, JavaClassSource javaClass) {
        if (!ExclusionRegistry.isInterfaceExcluded(metadata.getTag(), HasStyle.class)) {
            javaClass.addInterface(HasStyle.class);
        }
        ArrayList<String> classBehaviorsAndMixins = new ArrayList<String>();
        classBehaviorsAndMixins.add(metadata.getTag());
        if (metadata.getBehaviors() != null) {
            metadata.getBehaviors().stream().filter(behavior -> !ExclusionRegistry.isBehaviorOrMixinExcluded(metadata.getTag(), behavior)).forEach(classBehaviorsAndMixins::add);
        }
        if (metadata.getMixins() != null) {
            metadata.getMixins().stream().filter(mixin -> !ExclusionRegistry.isBehaviorOrMixinExcluded(metadata.getTag(), mixin)).forEach(classBehaviorsAndMixins::add);
        }
        Set<Class<?>> interfaces = BehaviorRegistry.getClassesForBehaviors(classBehaviorsAndMixins);
        interfaces.forEach(clazz -> {
            if (clazz.getTypeParameters().length > 0) {
                javaClass.addInterface(clazz.getName() + GENERIC_TYPE_DECLARATION);
            } else {
                javaClass.addInterface(clazz);
            }
        });
    }

    private void generateGettersAndSetters(ComponentMetadata metadata, JavaClassSource javaClass, Map<String, MethodSource<JavaClassSource>> propertyToGetterMap) {
        boolean hasValue = this.shouldImplementHasValue(metadata, javaClass);
        metadata.getProperties().stream().filter(property -> !ExclusionRegistry.isPropertyExcluded(metadata.getTag(), property.getName())).forEachOrdered(property -> {
            boolean isValue;
            boolean bl = isValue = hasValue && ("value".equals(property.getName()) || ValuePropertyRegistry.valueName(metadata.getTag()).equals(property.getName()));
            if (!isValue) {
                this.generateGetterFor(javaClass, metadata, (ComponentPropertyData)property, metadata.getEvents(), propertyToGetterMap);
                if (!property.isReadOnly()) {
                    this.generateSetterFor(javaClass, metadata, (ComponentPropertyData)property);
                }
            }
        });
    }

    private void generateAdders(ComponentMetadata metadata, JavaClassSource javaClass) {
        boolean shouldImplementHasComponents;
        boolean hasDefaultSlot = false;
        boolean hasNamedSlot = false;
        for (String slot : metadata.getSlots()) {
            if (StringUtils.isEmpty((CharSequence)slot)) {
                hasDefaultSlot = true;
                continue;
            }
            hasNamedSlot = true;
            this.generateAdder(slot, javaClass);
        }
        boolean bl = shouldImplementHasComponents = hasDefaultSlot && !this.protectedMethods;
        if (shouldImplementHasComponents) {
            javaClass.addInterface(HasComponents.class);
        }
        if (hasNamedSlot) {
            this.generateRemovers(javaClass, shouldImplementHasComponents);
        }
    }

    private void generateAdder(String slot, JavaClassSource javaClass) {
        String methodName = ComponentGeneratorUtils.generateMethodNameForProperty("addTo", slot);
        MethodSource method = (MethodSource)javaClass.addMethod().setName(methodName);
        this.setMethodVisibility((MethodSource<JavaClassSource>)method);
        ComponentGeneratorUtils.addMethodParameter(javaClass, (MethodSource<JavaClassSource>)method, Component.class, "components").setVarArgs(true);
        method.setBody(String.format("for (Component component : components) {%n component.getElement().setAttribute(\"slot\", \"%s\");%n getElement().appendChild(component.getElement());%n }", slot));
        method.getJavaDoc().setText(String.format("Adds the given components as children of this component at the slot '%s'.", slot)).addTagValue(JAVADOC_PARAM, "components The components to add.").addTagValue(JAVADOC_SEE, "<a href=\"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/slot\">MDN page about slots</a>").addTagValue(JAVADOC_SEE, "<a href=\"https://html.spec.whatwg.org/multipage/scripting.html#the-slot-element\">Spec website about slots</a>");
        if (this.fluentMethod) {
            this.addFluentReturnToMethod((MethodSource<JavaClassSource>)method);
        }
    }

    private void generateRemovers(JavaClassSource javaClass, boolean useOverrideAnnotation) {
        MethodSource removeMethod = (MethodSource)javaClass.addMethod().setReturnTypeVoid().setName("remove");
        this.setMethodVisibility((MethodSource<JavaClassSource>)removeMethod);
        ComponentGeneratorUtils.addMethodParameter(javaClass, (MethodSource<JavaClassSource>)removeMethod, Component.class, "components").setVarArgs(true);
        removeMethod.setBody(String.format("for (Component component : components) {%nif (getElement().equals(component.getElement().getParent())) {%ncomponent.getElement().removeAttribute(\"slot\");%ngetElement().removeChild(component.getElement());%n }%nelse {%nthrow new IllegalArgumentException(\"The given component (\" + component + \") is not a child of this component\");%n}%n }", new Object[0]));
        if (useOverrideAnnotation) {
            removeMethod.addAnnotation(Override.class);
        } else {
            removeMethod.getJavaDoc().setText(String.format("Removes the given child components from this component.", new Object[0])).addTagValue(JAVADOC_PARAM, "components The components to remove.").addTagValue(JAVADOC_THROWS, "IllegalArgumentException if any of the components is not a child of this component.");
        }
        MethodSource removeAllMethod = (MethodSource)javaClass.addMethod().setReturnTypeVoid().setName("removeAll");
        this.setMethodVisibility((MethodSource<JavaClassSource>)removeAllMethod);
        removeAllMethod.setBody(String.format("getElement().getChildren().forEach(child -> child.removeAttribute(\"slot\"));%ngetElement().removeAllChildren();", new Object[0]));
        if (useOverrideAnnotation) {
            removeAllMethod.addAnnotation(Override.class);
        } else {
            javaClass.addImport(Element.class);
            removeAllMethod.getJavaDoc().setText(String.format("Removes all contents from this component, this includes child components, text content as well as child elements that have been added directly to this component using the {@link Element} API.", new Object[0]));
        }
    }

    private String addLicenseHeaderIfAvailable(String source, String licenseNote) {
        if (StringUtils.isBlank((CharSequence)licenseNote)) {
            return source;
        }
        return ComponentGeneratorUtils.formatStringToJavaComment(licenseNote) + source;
    }

    private void addClassAnnotations(ComponentMetadata metadata, JavaClassSource javaClass) {
        Properties properties = this.getProperties("version.prop");
        String generator = String.format("Generator: %s#%s", ComponentGenerator.class.getName(), properties.getProperty("generator.version"));
        String webComponent = String.format("WebComponent: %s#%s", metadata.getName(), metadata.getVersion());
        String flow = String.format("Flow#%s", properties.getProperty("flow.version"));
        String[] generatedValue = new String[]{generator, webComponent, flow};
        javaClass.addAnnotation(Generated.class).setStringArrayValue(generatedValue);
        javaClass.addAnnotation(Tag.class).setStringValue(metadata.getTag());
        String importPath = metadata.getBaseUrl().replace("\\", "/");
        if (importPath.startsWith("/")) {
            importPath = importPath.substring(1);
        }
        String htmlImport = String.format("frontend://%s%s", this.frontendDirectory, importPath);
        javaClass.addAnnotation(HtmlImport.class).setStringValue(htmlImport);
    }

    public void generateClass(ComponentMetadata metadata, File targetPath, String basePackage, String licenseNote) {
        JavaClassSource javaClass = this.generateClassSource(metadata, basePackage);
        String source = this.addLicenseHeaderIfAvailable(javaClass.toString(), licenseNote);
        String fileName = ComponentGeneratorUtils.generateValidJavaClassName(javaClass.getName()) + ".java";
        if (!targetPath.isDirectory() && !targetPath.mkdirs()) {
            throw new ComponentGenerationException("Could not create target directory \"" + targetPath + "\"");
        }
        try {
            Files.write(new File(ComponentGeneratorUtils.convertPackageToDirectory(targetPath, javaClass.getPackage(), true), fileName).toPath(), source.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new ComponentGenerationException("Error writing the generated Java source file \"" + fileName + "\" at \"" + targetPath + "\" for component \"" + metadata.getName() + "\"", ex);
        }
    }

    private void generateGetterFor(JavaClassSource javaClass, ComponentMetadata metadata, ComponentPropertyData property, List<ComponentEventData> events, Map<String, MethodSource<JavaClassSource>> propertyToGetterMap) {
        String propertyJavaName = this.getJavaNameForProperty(metadata, property.getName());
        MethodSource method = javaClass.addMethod();
        propertyToGetterMap.put(propertyJavaName, (MethodSource<JavaClassSource>)method);
        if (this.containsObjectType(property)) {
            JavaClassSource nestedClass = this.generateNestedPojo(javaClass, property.getObjectType().get(0), propertyJavaName + "-property", String.format("Class that encapsulates the data of the '%s' property in the {@link %s} component.", property.getName(), javaClass.getName()));
            method.setReturnType((JavaType)nestedClass);
            this.setMethodVisibility((MethodSource<JavaClassSource>)method, property.getObjectType());
            method.setName(ComponentGeneratorUtils.generateMethodNameForProperty("get", propertyJavaName));
            method.setBody(String.format("return new %s().readJson((JsonObject) getElement().getPropertyRaw(\"%s\"));", nestedClass.getName(), property.getName()));
            if (method.getVisibility() == Visibility.PROTECTED) {
                method.setName(method.getName() + StringUtils.capitalize((String)nestedClass.getName()));
            }
            this.addSynchronizeAnnotationAndJavadocToGetter((MethodSource<JavaClassSource>)method, property, events);
        } else {
            boolean postfixWithVariableType;
            boolean bl = postfixWithVariableType = property.getType().size() > 1;
            if (postfixWithVariableType) {
                property.setType(new TreeSet<ComponentBasicType>(property.getType()));
            }
            for (ComponentBasicType basicType : property.getType()) {
                Class<?> javaType = ComponentGeneratorUtils.toJavaType(basicType);
                method.setReturnType(javaType);
                this.setMethodVisibility((MethodSource<JavaClassSource>)method, basicType);
                if (basicType == ComponentBasicType.BOOLEAN) {
                    if (!(propertyJavaName.startsWith("is") || propertyJavaName.startsWith("has") || propertyJavaName.startsWith("have"))) {
                        method.setName(ComponentGeneratorUtils.generateMethodNameForProperty("is", propertyJavaName));
                    } else {
                        method.setName(ComponentGeneratorUtils.formatStringToValidJavaIdentifier(propertyJavaName));
                    }
                } else {
                    method.setName(ComponentGeneratorUtils.generateMethodNameForProperty("get", propertyJavaName) + (postfixWithVariableType ? StringUtils.capitalize((String)basicType.name().toLowerCase()) : ""));
                }
                if (method.getVisibility() == Visibility.PROTECTED) {
                    method.setName(method.getName() + StringUtils.capitalize((String)javaType.getSimpleName()));
                }
                this.addSynchronizeAnnotationAndJavadocToGetter((MethodSource<JavaClassSource>)method, property, events);
                method.setBody(ComponentGeneratorUtils.generateElementApiGetterForType(basicType, property.getName()));
            }
        }
    }

    private void setMethodVisibility(MethodSource<JavaClassSource> method, ComponentType type) {
        this.setMethodVisibility(method, Collections.singleton(type));
    }

    private void setMethodVisibility(MethodSource<JavaClassSource> method, Collection<? extends ComponentType> types) {
        if (types.stream().allMatch(this::isSupportedObjectType)) {
            this.setMethodVisibility(method);
        } else {
            method.setProtected();
        }
    }

    private void setMethodVisibility(MethodSource<JavaClassSource> method) {
        if (this.protectedMethods) {
            method.setProtected();
        } else {
            method.setPublic();
        }
    }

    private boolean isSupportedObjectType(ComponentType type) {
        if (!type.isBasicType()) {
            return true;
        }
        ComponentBasicType basicType = (ComponentBasicType)type;
        switch (basicType) {
            case NUMBER: 
            case STRING: 
            case BOOLEAN: 
            case DATE: {
                return true;
            }
        }
        return false;
    }

    private void addSynchronizeAnnotationAndJavadocToGetter(MethodSource<JavaClassSource> method, ComponentPropertyData property, List<ComponentEventData> events) {
        String synchronizationDescription = "";
        String eventName = ComponentGeneratorUtils.convertCamelCaseToHyphens(property.getName()) + PROPERTY_CHANGE_EVENT_POSTFIX;
        if (this.containsEvent(eventName, events)) {
            method.addAnnotation(Synchronize.class).setStringValue("property", property.getName()).setStringValue(eventName);
            synchronizationDescription = "This property is synchronized automatically from client side when a '" + eventName + "' event happens.";
        } else {
            synchronizationDescription = "This property is not synchronized automatically from the client side, so the returned value may not be the same as in client side.";
        }
        if (StringUtils.isNotEmpty((CharSequence)property.getDescription())) {
            this.addMarkdownJavaDoc(property.getDescription() + "<p>" + synchronizationDescription, method.getJavaDoc());
        } else {
            method.getJavaDoc().setFullText(synchronizationDescription);
        }
        method.getJavaDoc().addTagValue(JAVADOC_RETURN, "the {@code " + property.getName() + "} property from the webcomponent");
    }

    private boolean containsEvent(String eventName, List<ComponentEventData> events) {
        if (events == null) {
            return false;
        }
        return events.stream().map(ComponentEventData::getName).anyMatch(name -> name.equals(eventName));
    }

    private boolean shouldImplementHasValue(ComponentMetadata metadata, JavaClassSource javaClass) {
        if (javaClass.getInterfaces().contains("com.vaadin.flow.component.HasValue<R>")) {
            return true;
        }
        if (metadata.getProperties() == null || metadata.getEvents() == null) {
            return false;
        }
        String propertyName = ValuePropertyRegistry.valueName(metadata.getTag());
        String propertyEvent = propertyName + PROPERTY_CHANGE_EVENT_POSTFIX;
        if (metadata.getProperties().stream().anyMatch(property -> propertyName.equals(this.getJavaNameForProperty(metadata, property.getName())) && !property.isReadOnly() && (this.containsObjectType((ComponentPropertyBaseData)property) || property.getType().size() == 1))) {
            return metadata.getEvents().stream().anyMatch(event -> propertyEvent.equals(this.getJavaNameForPropertyChangeEvent(metadata, event.getName())));
        }
        return false;
    }

    private void addMarkdownJavaDoc(String documentation, JavaDocSource<?> javaDoc) {
        javaDoc.setFullText(this.javaDocFormatter.formatJavaDoc(documentation));
    }

    private void generateSetterFor(JavaClassSource javaClass, ComponentMetadata metadata, ComponentPropertyData property) {
        boolean isValue;
        String propertyJavaName = this.getJavaNameForProperty(metadata, property.getName());
        boolean bl = isValue = ValuePropertyRegistry.valueName(metadata.getTag()).equals(propertyJavaName) && this.shouldImplementHasValue(metadata, javaClass);
        if (this.containsObjectType(property)) {
            String nestedClassName = ComponentGeneratorUtils.generateValidJavaClassName(propertyJavaName + "-property");
            MethodSource method = (MethodSource)javaClass.addMethod().setName(ComponentGeneratorUtils.generateMethodNameForProperty("set", propertyJavaName));
            this.setMethodVisibility((MethodSource<JavaClassSource>)method, property.getObjectType());
            method.addParameter(nestedClassName, "property");
            method.setBody(String.format("getElement().setPropertyJson(\"%s\", property.toJson());", property.getName()));
            if (StringUtils.isNotEmpty((CharSequence)property.getDescription())) {
                this.addMarkdownJavaDoc(property.getDescription(), method.getJavaDoc());
            }
            method.getJavaDoc().addTagValue(JAVADOC_PARAM, "property the property to set");
            if (this.fluentMethod) {
                this.addFluentReturnToMethod((MethodSource<JavaClassSource>)method);
            }
            if (isValue) {
                method.addAnnotation(Override.class);
                this.preventSettingTheSameValue(javaClass, "property", (MethodSource<JavaClassSource>)method);
            }
        } else {
            for (ComponentBasicType basicType : property.getType()) {
                MethodSource method = (MethodSource)javaClass.addMethod().setName(ComponentGeneratorUtils.generateMethodNameForProperty("set", propertyJavaName));
                this.setMethodVisibility((MethodSource<JavaClassSource>)method, basicType);
                Class<?> setterType = ComponentGeneratorUtils.toJavaType(basicType);
                String parameterName = ComponentGeneratorUtils.formatStringToValidJavaIdentifier(propertyJavaName);
                ComponentGeneratorUtils.addMethodParameter(javaClass, (MethodSource<JavaClassSource>)method, setterType, parameterName);
                boolean nullable = !isValue || String.class != setterType;
                method.setBody(ComponentGeneratorUtils.generateElementApiSetterForType(basicType, property.getName(), parameterName, nullable));
                if (StringUtils.isNotEmpty((CharSequence)property.getDescription())) {
                    this.addMarkdownJavaDoc(property.getDescription(), method.getJavaDoc());
                }
                method.getJavaDoc().addTagValue(JAVADOC_PARAM, String.format("%s the %s value to set", parameterName, setterType.getSimpleName()));
                if (this.fluentMethod) {
                    this.addFluentReturnToMethod((MethodSource<JavaClassSource>)method);
                }
                if (!isValue) continue;
                method.addAnnotation(Override.class);
                this.preventSettingTheSameValue(javaClass, parameterName, (MethodSource<JavaClassSource>)method);
                if (setterType.isPrimitive()) {
                    this.implementHasValueSetterWithPrimitiveType(javaClass, property, (MethodSource<JavaClassSource>)method, setterType, parameterName);
                    continue;
                }
                if (nullable) continue;
                method.setBody(String.format("Objects.requireNonNull(%s, \"%s cannot be null\");", parameterName, parameterName) + method.getBody());
            }
        }
    }

    private void implementHasValueSetterWithPrimitiveType(JavaClassSource javaClass, ComponentPropertyData property, MethodSource<JavaClassSource> method, Class<?> setterType, String parameterName) {
        method.removeParameter(setterType, parameterName);
        setterType = ClassUtils.primitiveToWrapper(setterType);
        ComponentGeneratorUtils.addMethodParameter(javaClass, method, setterType, parameterName);
        this.preventNullArgument(javaClass, parameterName, method);
        if (setterType.equals(Double.class)) {
            MethodSource overloadMethod = (MethodSource)((MethodSource)javaClass.addMethod().setName(method.getName())).setPublic();
            ComponentGeneratorUtils.addMethodParameter(javaClass, (MethodSource<JavaClassSource>)overloadMethod, Number.class, parameterName);
            overloadMethod.setBody(String.format("setValue(%s.doubleValue());", parameterName));
            if (StringUtils.isNotEmpty((CharSequence)property.getDescription())) {
                this.addMarkdownJavaDoc(property.getDescription(), overloadMethod.getJavaDoc());
            }
            overloadMethod.getJavaDoc().addTagValue(JAVADOC_PARAM, String.format("%s the %s value to set", parameterName, Number.class.getSimpleName()));
            overloadMethod.getJavaDoc().addTagValue(JAVADOC_SEE, "#setValue(Double)");
            this.preventSettingTheSameValue(javaClass, parameterName, (MethodSource<JavaClassSource>)overloadMethod);
            this.preventNullArgument(javaClass, parameterName, (MethodSource<JavaClassSource>)overloadMethod);
            if (this.fluentMethod) {
                this.addFluentReturnToMethod((MethodSource<JavaClassSource>)overloadMethod);
            }
        }
    }

    private void preventSettingTheSameValue(JavaClassSource javaClass, String parameterName, MethodSource<JavaClassSource> method) {
        javaClass.addImport(Objects.class);
        method.setBody(String.format("if (!Objects.equals(%s, getValue())) {", parameterName) + method.getBody() + "}");
    }

    private void preventNullArgument(JavaClassSource javaClass, String parameterName, MethodSource<JavaClassSource> method) {
        javaClass.addImport(Objects.class);
        method.setBody(String.format("Objects.requireNonNull(%s, \"%s\");", parameterName, javaClass.getName() + " value must not be null") + method.getBody());
    }

    private void addFluentReturnToMethod(MethodSource<JavaClassSource> method) {
        method.setReturnType(GENERIC_TYPE);
        method.setBody(method.getBody() + "return (R) this;");
        method.getJavaDoc().addTagValue(JAVADOC_RETURN, "this instance, for method chaining");
    }

    private void generateMethodFor(JavaClassSource javaClass, ComponentFunctionData function) {
        Set<List<ComponentType>> typeVariants = FunctionParameterVariantCombinator.generateVariants(function);
        HashMap<ComponentObjectType, JavaClassSource> nestedClassesMap = new HashMap<ComponentObjectType, JavaClassSource>();
        for (List<ComponentType> typeVariant : typeVariants) {
            MethodSource method = ((MethodSource)javaClass.addMethod().setName(StringUtils.uncapitalize((String)ComponentGeneratorUtils.formatStringToValidJavaIdentifier(function.getName())))).setReturnTypeVoid();
            if (StringUtils.isNotEmpty((CharSequence)function.getDescription())) {
                this.addMarkdownJavaDoc(function.getDescription(), method.getJavaDoc());
            }
            String parameterString = this.generateMethodParameters(javaClass, (MethodSource<JavaClassSource>)method, function, typeVariant, nestedClassesMap);
            if (function.getReturns() != null && function.getReturns() != ComponentBasicType.UNDEFINED) {
                method.setProtected();
                method.addAnnotation(NotSupported.class);
                method.getJavaDoc().setText(method.getJavaDoc().getText() + "<p>This function is not supported by Flow because it returns a <code>" + ComponentGeneratorUtils.toJavaType(function.getReturns()).getName() + "</code>. Functions with return types different than void are not supported at this moment.");
                method.setBody("");
                continue;
            }
            this.setMethodVisibility((MethodSource<JavaClassSource>)method, typeVariant);
            method.setBody(String.format("getElement().callFunction(\"%s\"%s);", function.getName(), parameterString));
        }
    }

    private String generateMethodParameters(JavaClassSource javaClass, MethodSource<JavaClassSource> method, ComponentFunctionData function, List<ComponentType> typeVariant, Map<ComponentObjectType, JavaClassSource> nestedClassesMap) {
        int paramIndex = 0;
        StringBuilder sb = new StringBuilder();
        for (ComponentType paramType : typeVariant) {
            String paramName = function.getParameters().get(paramIndex).getName();
            String paramDescription = function.getParameters().get(paramIndex).getDescription();
            String formattedName = StringUtils.uncapitalize((String)ComponentGeneratorUtils.formatStringToValidJavaIdentifier(function.getParameters().get(paramIndex).getName()));
            ++paramIndex;
            if (paramType.isBasicType()) {
                ComponentBasicType bt = (ComponentBasicType)paramType;
                ComponentGeneratorUtils.addMethodParameter(javaClass, method, ComponentGeneratorUtils.toJavaType(bt), formattedName);
                sb.append(", ").append(formattedName);
            } else {
                ComponentObjectType ot = (ComponentObjectType)paramType;
                String nameHint = function.getName() + "-" + paramName;
                JavaClassSource nestedClass = nestedClassesMap.computeIfAbsent(ot, objectType -> this.generateNestedPojo(javaClass, (ComponentObjectType)objectType, nameHint, String.format("Class that encapsulates the data to be sent to the {@link %s#%s(%s)} method.", javaClass.getName(), method.getName(), ComponentGeneratorUtils.generateValidJavaClassName(nameHint))));
                sb.append(", ").append(formattedName).append(".toJson()");
                method.getJavaDoc().addTagValue(JAVADOC_SEE, nestedClass.getName());
                method.addParameter((JavaType)nestedClass, formattedName);
            }
            method.getJavaDoc().addTagValue(JAVADOC_PARAM, String.format("%s %s", formattedName, paramDescription));
        }
        return sb.toString();
    }

    private void generateEventListenerFor(JavaClassSource javaClass, ComponentMetadata metadata, ComponentEventData event, Map<String, MethodSource<JavaClassSource>> propertyToGetterMap) {
        String eventJavaApiName = this.getJavaNameForPropertyChangeEvent(metadata, event.getName());
        boolean hasValue = this.shouldImplementHasValue(metadata, javaClass);
        if ("value-changed".equals(eventJavaApiName) && hasValue) {
            return;
        }
        eventJavaApiName = ComponentGeneratorUtils.formatStringToValidJavaIdentifier(eventJavaApiName);
        String propertyNameCamelCase = null;
        boolean isPropertyChange = eventJavaApiName.endsWith("Changed");
        if (isPropertyChange) {
            eventJavaApiName = eventJavaApiName.substring(0, eventJavaApiName.length() - 1);
            propertyNameCamelCase = eventJavaApiName.substring(0, eventJavaApiName.length() - "Change".length());
        }
        JavaClassSource eventClass = this.createEventListenerEventClass(javaClass, hasValue, event, eventJavaApiName, propertyNameCamelCase, propertyToGetterMap);
        javaClass.addNestedType((JavaSource)eventClass);
        MethodSource method = ((MethodSource)javaClass.addMethod().setName("add" + StringUtils.capitalize((String)(eventJavaApiName + "Listener")))).setReturnType(Registration.class);
        this.setMethodVisibility((MethodSource<JavaClassSource>)method);
        method.addParameter("ComponentEventListener<" + eventClass.getName() + GENERIC_TYPE_DECLARATION + ">", "listener");
        method.getJavaDoc().setText(String.format("Adds a listener for {@code %s} events fired by the webcomponent.", event.getName())).addTagValue(JAVADOC_PARAM, "listener the listener").addTagValue(JAVADOC_RETURN, "a {@link Registration} for removing the event listener");
        if (isPropertyChange) {
            String propertyNameBeforeRenaming = ComponentGeneratorUtils.formatStringToValidJavaIdentifier(event.getName().replace(PROPERTY_CHANGE_EVENT_POSTFIX, ""));
            method.setBody(String.format("return getElement().addPropertyChangeListener(\"%s\", event -> listener.onComponentEvent(new %s<%s>((R) this, event.isUserOriginated())));", propertyNameBeforeRenaming, eventClass.getName(), ((TypeVariableSource)eventClass.getTypeVariables().get(0)).getName()));
        } else {
            method.setBody(String.format("return addListener(%s.class, (ComponentEventListener) listener);", eventClass.getName()));
            method.addAnnotation(SuppressWarnings.class).setStringArrayValue(new String[]{"rawtypes", "unchecked"});
        }
    }

    private JavaClassSource createEventListenerEventClass(JavaClassSource javaClass, boolean isValue, ComponentEventData event, String javaEventName, String propertyNameCamelCase, Map<String, MethodSource<JavaClassSource>> propertyToGetterMap) {
        boolean isPropertyChange = propertyNameCamelCase != null;
        String eventClassName = StringUtils.capitalize((String)javaEventName);
        String eventClassString = String.format("public static class %sEvent<%s extends %s<%s>> extends ComponentEvent<%s> {}", eventClassName, GENERIC_TYPE, javaClass.getName(), GENERIC_TYPE + (isValue ? ", ?" : ""), GENERIC_TYPE);
        JavaClassSource eventClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)eventClassString);
        MethodSource eventConstructor = ((MethodSource)eventClass.addMethod().setConstructor(true).setPublic()).setBody("super(source, fromClient);");
        eventConstructor.addParameter(GENERIC_TYPE, "source");
        eventConstructor.addParameter("boolean", "fromClient");
        if (isPropertyChange) {
            this.addFieldAndGetterToPropertyChangeEvent(propertyNameCamelCase, propertyToGetterMap, eventClass, (MethodSource<JavaClassSource>)eventConstructor);
        } else {
            this.addEventDataParameters(javaClass, event, eventClassName, eventClass, (MethodSource<JavaClassSource>)eventConstructor);
            eventClass.addAnnotation(DomEvent.class).setStringValue(event.getName());
            javaClass.addImport(DomEvent.class);
        }
        javaClass.addImport(ComponentEvent.class);
        javaClass.addImport(ComponentEventListener.class);
        return eventClass;
    }

    private void addFieldAndGetterToPropertyChangeEvent(String propertyNameCamelCase, Map<String, MethodSource<JavaClassSource>> propertyToGetterMap, JavaClassSource eventClass, MethodSource<JavaClassSource> eventConstructor) {
        MethodSource<JavaClassSource> getterInComponent = propertyToGetterMap.get(propertyNameCamelCase);
        if (getterInComponent != null) {
            eventConstructor.setBody(eventConstructor.getBody() + String.format("this.%s = source.%s();", propertyNameCamelCase, getterInComponent.getName()));
            ((FieldSource)((FieldSource)eventClass.addField().setPrivate()).setFinal(true)).setType(getterInComponent.getReturnType().getName()).setName(propertyNameCamelCase);
            String getterNameInEvent = getterInComponent.getName().substring(0, getterInComponent.getName().lastIndexOf(StringUtils.capitalize((String)propertyNameCamelCase)) + propertyNameCamelCase.length());
            ((MethodSource)((MethodSource)eventClass.addMethod().setPublic()).setReturnType(getterInComponent.getReturnType()).setName(getterNameInEvent)).setBody(String.format("return %s;", propertyNameCamelCase));
        }
    }

    private void addEventDataParameters(JavaClassSource javaClass, ComponentEventData event, String eventClassName, JavaClassSource eventClass, MethodSource<JavaClassSource> eventConstructor) {
        for (ComponentPropertyBaseData property : event.getProperties()) {
            Class propertyJavaType;
            String propertyName = property.getName();
            String normalizedProperty = ComponentGeneratorUtils.formatStringToValidJavaIdentifier(propertyName);
            if (this.containsObjectType(property)) {
                JavaClassSource nestedClass = this.generateNestedPojo(javaClass, property.getObjectType().get(0), eventClassName + "-" + propertyName, String.format("Class that encapsulates the data received on the '%s' property of @{link %s} events, from the @{link %s} component.", propertyName, eventClass.getName(), javaClass.getName()));
                propertyJavaType = JsonObject.class;
                ((FieldSource)((FieldSource)eventClass.addField().setType(propertyJavaType).setPrivate()).setFinal(true)).setName(normalizedProperty);
                ((MethodSource)((MethodSource)eventClass.addMethod().setName(ComponentGeneratorUtils.generateMethodNameForProperty("get", propertyName))).setPublic()).setReturnType((JavaType)nestedClass).setBody(String.format("return new %s().readJson(%s);", nestedClass.getName(), normalizedProperty));
            } else {
                propertyJavaType = !property.getType().isEmpty() ? ComponentGeneratorUtils.toJavaType(property.getType().iterator().next()) : JsonObject.class;
                eventClass.addProperty(propertyJavaType, normalizedProperty).setAccessible(true).setMutable(false);
            }
            ParameterSource<JavaClassSource> parameter = ComponentGeneratorUtils.addMethodParameter(javaClass, eventConstructor, propertyJavaType, normalizedProperty);
            parameter.addAnnotation(EventData.class).setStringValue(String.format("event.%s", propertyName));
            eventConstructor.setBody(String.format("%s%nthis.%s = %s;", eventConstructor.getBody(), normalizedProperty, normalizedProperty));
            javaClass.addImport(EventData.class);
        }
    }

    private boolean containsObjectType(ComponentPropertyBaseData property) {
        return property.getObjectType() != null && !property.getObjectType().isEmpty();
    }

    private JavaClassSource generateNestedPojo(JavaClassSource javaClass, ComponentObjectType type, String nameHint, String description) {
        JavaClassSource nestedClass = new NestedClassGenerator().withType(type).withFluentSetters(this.fluentMethod).withNameHint(nameHint).build();
        if (javaClass.getNestedType(nestedClass.getName()) != null) {
            throw new ComponentGenerationException("Duplicated nested class: \"" + nestedClass.getName() + "\". Please make sure your webcomponent definition contains unique properties, events and method names.");
        }
        nestedClass.getJavaDoc().setText(description);
        javaClass.addNestedType((JavaSource)nestedClass);
        javaClass.addImport(JsonObject.class);
        javaClass.addImport(JsonSerializable.class);
        return nestedClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getProperties(String fileName) {
        Properties config = new Properties();
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + fileName);){
            config.load(resourceAsStream);
            Properties properties = config;
            return properties;
        }
        catch (IOException e) {
            LoggerFactory.getLogger((String)this.getClass().getSimpleName()).warn("Failed to load properties file '{}'", (Object)fileName, (Object)e);
            return config;
        }
    }

    private String getJavaNameForProperty(ComponentMetadata metadata, String propertyName) {
        String javaApiName = propertyName;
        Optional<String> nameRemapping = PropertyNameRemapRegistry.getOptionalMappingFor(metadata.getTag(), propertyName);
        if (nameRemapping.isPresent()) {
            javaApiName = nameRemapping.get();
        }
        return javaApiName;
    }

    private String getJavaNameForPropertyChangeEvent(ComponentMetadata metadata, String propertyChangeEventName) {
        if (!propertyChangeEventName.endsWith(PROPERTY_CHANGE_EVENT_POSTFIX)) {
            return propertyChangeEventName;
        }
        return this.getJavaNameForProperty(metadata, propertyChangeEventName.replace(PROPERTY_CHANGE_EVENT_POSTFIX, "")) + PROPERTY_CHANGE_EVENT_POSTFIX;
    }
}

