/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.generator;

import com.vaadin.generator.exception.ComponentGenerationException;
import com.vaadin.generator.metadata.ComponentBasicType;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;

public final class ComponentGeneratorUtils {
    private static final Set<String> JAVA_RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "continue"));

    private ComponentGeneratorUtils() {
    }

    public static String generateValidJavaClassName(String webcomponentClassName) {
        return StringUtils.capitalize((String)ComponentGeneratorUtils.formatStringToValidJavaIdentifier(webcomponentClassName));
    }

    public static String generateMethodNameForProperty(String prefix, String propertyName) {
        assert (prefix != null) : "prefix should not be null";
        return prefix + StringUtils.capitalize((String)ComponentGeneratorUtils.formatStringToValidJavaIdentifier(propertyName, true));
    }

    public static String formatStringToValidJavaIdentifier(String name) {
        return ComponentGeneratorUtils.formatStringToValidJavaIdentifier(name, false);
    }

    public static String formatStringToValidJavaIdentifier(String name, boolean ignoreReservedWords) {
        String trimmed = name.trim();
        StringBuilder sb = new StringBuilder();
        if (!Character.isJavaIdentifierStart(trimmed.charAt(0))) {
            sb.append('_');
        }
        boolean toTitleCase = false;
        for (char character : trimmed.toCharArray()) {
            if (!Character.isJavaIdentifierPart(character) || Character.getType(character) == 23 || Character.getType(character) == 22) {
                toTitleCase = true;
                continue;
            }
            if (toTitleCase) {
                sb.append(Character.toTitleCase(character));
                toTitleCase = false;
                continue;
            }
            sb.append(character);
        }
        String identifier = sb.toString();
        if (!ignoreReservedWords && JAVA_RESERVED_WORDS.contains(identifier)) {
            return '_' + identifier;
        }
        return identifier;
    }

    public static File convertPackageToDirectory(File basePath, String packageName, boolean createDirectories) throws IOException {
        File directory = new File(basePath, packageName.replace('.', File.separatorChar));
        if (createDirectories && !directory.isDirectory() && !directory.mkdirs()) {
            throw new IOException("Directory \"" + directory + "\" could not be created.");
        }
        return directory;
    }

    public static String convertFilePathToPackage(String path) {
        assert (path != null) : "Path should not be null";
        String normalized = path.replace('\\', '/');
        int idx = normalized.lastIndexOf(47);
        if (idx <= 0) {
            return "";
        }
        normalized = normalized.substring(0, idx);
        normalized = normalized.replaceAll("[\\W+_]", "/");
        String[] split = normalized.split("/");
        return Arrays.stream(split).filter(StringUtils::isNotBlank).map(ComponentGeneratorUtils::formatStringToValidJavaIdentifier).map(String::toLowerCase).collect(Collectors.joining("."));
    }

    public static String formatStringToJavaComment(String input) {
        assert (input != null);
        StringBuilder builder = new StringBuilder("/*\n * ");
        builder.append(input.replace("\n", "\n * "));
        builder.append("\n */\n");
        return builder.toString();
    }

    public static String generateElementApiGetterForType(ComponentBasicType basicType, String propertyName) {
        switch (basicType) {
            case STRING: {
                return String.format("return getElement().getProperty(\"%s\");", propertyName);
            }
            case BOOLEAN: {
                return String.format("return getElement().getProperty(\"%s\", false);", propertyName);
            }
            case NUMBER: {
                return String.format("return getElement().getProperty(\"%s\", 0.0);", propertyName);
            }
            case DATE: {
                return String.format("return getElement().getProperty(\"%s\");", propertyName);
            }
            case ARRAY: {
                return String.format("return (JsonArray) getElement().getPropertyRaw(\"%s\");", propertyName);
            }
            case OBJECT: {
                return String.format("return (JsonObject) getElement().getPropertyRaw(\"%s\");", propertyName);
            }
            case UNDEFINED: {
                return String.format("return (JsonValue) getElement().getPropertyRaw(\"%s\");", propertyName);
            }
        }
        throw new ComponentGenerationException("Not a supported type for getters: " + basicType);
    }

    public static String generateElementApiValueGetterForType(ComponentBasicType basicType, String propertyName) {
        Objects.requireNonNull(propertyName);
        if (propertyName.isEmpty()) {
            throw new IllegalArgumentException("propertyName can not be empty");
        }
        String variableName = StringUtils.uncapitalize((String)ComponentGeneratorUtils.formatStringToValidJavaIdentifier(propertyName));
        switch (basicType) {
            case STRING: 
            case DATE: {
                return String.format("String %s = getElement().getProperty(\"%s\");return %s == null ? getEmptyValue() : %s;", variableName, propertyName, variableName, variableName);
            }
            case ARRAY: {
                return ComponentGeneratorUtils.generateElementApiValueGetterForTypeRaw("JsonArray", propertyName, variableName);
            }
            case OBJECT: {
                return ComponentGeneratorUtils.generateElementApiValueGetterForTypeRaw("JsonObject", propertyName, variableName);
            }
            case UNDEFINED: {
                return ComponentGeneratorUtils.generateElementApiValueGetterForTypeRaw("JsonValue", propertyName, variableName);
            }
            case BOOLEAN: 
            case NUMBER: {
                return ComponentGeneratorUtils.generateElementApiGetterForType(basicType, propertyName);
            }
        }
        throw new ComponentGenerationException("Not a supported type for getters: " + basicType);
    }

    private static String generateElementApiValueGetterForTypeRaw(String returnType, String propertyName, String variableName) {
        return String.format("Object %s = getElement().getPropertyRaw(\"%s\");return (%s) (%s == null ? getEmptyValue() : %s);", variableName, propertyName, returnType, variableName, variableName);
    }

    public static String generateElementApiSetterForType(ComponentBasicType basicType, String propertyName, String parameterName, boolean nullable) {
        switch (basicType) {
            case ARRAY: 
            case OBJECT: 
            case UNDEFINED: {
                return String.format("getElement().setPropertyJson(\"%s\", %s);", propertyName, parameterName);
            }
            case STRING: {
                return String.format(nullable ? "getElement().setProperty(\"%s\", %s == null ? \"\" : %s);" : "getElement().setProperty(\"%s\", %s);", propertyName, parameterName, parameterName);
            }
        }
        return String.format("getElement().setProperty(\"%s\", %s);", propertyName, parameterName);
    }

    public static Class<?> toJavaType(ComponentBasicType type) {
        switch (type) {
            case STRING: {
                return String.class;
            }
            case NUMBER: {
                return Double.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case ARRAY: {
                return JsonArray.class;
            }
            case DATE: {
                return Date.class;
            }
            case OBJECT: {
                return JsonObject.class;
            }
            case UNDEFINED: {
                return JsonValue.class;
            }
        }
        throw new ComponentGenerationException("Not a supported type: " + type);
    }

    public static String convertCamelCaseToHyphens(String text) {
        char[] charArray;
        if (text == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (char character : charArray = text.toCharArray()) {
            if (Character.isUpperCase(character)) {
                if (builder.length() > 0) {
                    builder.append("-");
                }
                builder.append(Character.toLowerCase(character));
                continue;
            }
            builder.append(character);
        }
        return builder.toString();
    }

    public static ParameterSource<JavaClassSource> addMethodParameter(JavaClassSource javaClass, MethodSource<JavaClassSource> method, Class<?> type, String name) {
        if (!type.isPrimitive() && !"java.lang".equals(type.getPackage().getName())) {
            javaClass.addImport(type);
        }
        return method.addParameter(type.getSimpleName(), name);
    }
}

