/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.generator;

import com.vaadin.flow.component.JsonSerializable;
import com.vaadin.flow.component.NotSupported;
import com.vaadin.generator.ComponentGeneratorUtils;
import com.vaadin.generator.exception.ComponentGenerationException;
import com.vaadin.generator.metadata.ComponentBasicType;
import com.vaadin.generator.metadata.ComponentObjectType;
import elemental.json.JsonObject;
import java.util.List;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class NestedClassGenerator {
    private ComponentObjectType type;
    private String nameHint;
    private boolean fluentSetters = true;

    public NestedClassGenerator withType(ComponentObjectType type) {
        this.type = type;
        return this;
    }

    public NestedClassGenerator withNameHint(String nameHint) {
        this.nameHint = nameHint;
        return this;
    }

    public NestedClassGenerator withFluentSetters(boolean fluentSetters) {
        this.fluentSetters = fluentSetters;
        return this;
    }

    public JavaClassSource build() {
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        ((JavaClassSource)((JavaClassSource)((JavaClassSource)javaClass.addInterface(JsonSerializable.class)).setPublic()).setStatic(true)).setName(ComponentGeneratorUtils.generateValidJavaClassName(this.nameHint));
        ((FieldSource)javaClass.addField().setType(JsonObject.class).setPrivate()).setName("internalObject");
        for (ComponentObjectType.ComponentObjectTypeInnerType object : this.type.getInnerTypes()) {
            ComponentBasicType simpleType = this.getSimpleBasicType(object.getType());
            this.generateGetter(javaClass, object, simpleType);
            this.generateSetter(javaClass, object, simpleType);
        }
        this.generateToJson(javaClass);
        this.generateReadJson(javaClass);
        return javaClass;
    }

    private void generateGetter(JavaClassSource javaClass, ComponentObjectType.ComponentObjectTypeInnerType object, ComponentBasicType simpleType) {
        String body;
        MethodSource method = (MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnType(ComponentGeneratorUtils.toJavaType(simpleType)).setName(ComponentGeneratorUtils.generateMethodNameForProperty(simpleType == ComponentBasicType.BOOLEAN ? "is" : "get", object.getName()));
        switch (simpleType) {
            case STRING: {
                body = "return internalObject.getString(\"%s\");";
                break;
            }
            case BOOLEAN: {
                body = "return internalObject.getBoolean(\"%s\");";
                break;
            }
            case NUMBER: {
                body = "return internalObject.getNumber(\"%s\");";
                break;
            }
            case OBJECT: {
                body = "return internalObject.getObject(\"%s\");";
                break;
            }
            case ARRAY: {
                body = "return internalObject.getArray(\"%s\");";
                break;
            }
            case UNDEFINED: {
                body = "return internalObject.get(\"%s\");";
                break;
            }
            case DATE: {
                method.addAnnotation(NotSupported.class);
                method.setBody("return null;");
                return;
            }
            default: {
                throw new ComponentGenerationException("Unrecognized type: " + simpleType);
            }
        }
        method.setBody(String.format(body, object.getName()));
    }

    private void generateSetter(JavaClassSource javaClass, ComponentObjectType.ComponentObjectTypeInnerType object, ComponentBasicType simpleType) {
        Class<?> javaType = ComponentGeneratorUtils.toJavaType(simpleType);
        MethodSource method = (MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnTypeVoid().setName(ComponentGeneratorUtils.generateMethodNameForProperty("set", object.getName()));
        String formattedName = ComponentGeneratorUtils.formatStringToValidJavaIdentifier(object.getName());
        ComponentGeneratorUtils.addMethodParameter(javaClass, (MethodSource<JavaClassSource>)method, javaType, formattedName);
        method.setBody(String.format("this.internalObject.put(\"%s\", %s);", object.getName(), formattedName));
        if (this.fluentSetters) {
            method.setReturnType((JavaType)javaClass);
            method.setBody(method.getBody() + "return this;");
        }
    }

    private void generateToJson(JavaClassSource javaClass) {
        MethodSource method = (MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnType(JsonObject.class).setName("toJson");
        method.addAnnotation(Override.class);
        method.setBody("return internalObject;");
    }

    private void generateReadJson(JavaClassSource javaClass) {
        MethodSource method = (MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnType((JavaType)javaClass).setName("readJson");
        method.addAnnotation(Override.class);
        ComponentGeneratorUtils.addMethodParameter(javaClass, (MethodSource<JavaClassSource>)method, JsonObject.class, "value");
        method.setBody("internalObject = value; return this;");
    }

    private ComponentBasicType getSimpleBasicType(List<ComponentBasicType> types) {
        return types.stream().distinct().reduce((type1, type2) -> {
            if (type1 == ComponentBasicType.OBJECT || type2 == ComponentBasicType.OBJECT) {
                return ComponentBasicType.OBJECT;
            }
            return ComponentBasicType.UNDEFINED;
        }).orElse(ComponentBasicType.UNDEFINED);
    }
}

