/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.generator.registry;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BehaviorRegistry {
    private static final Map<String, List<Class<?>>> REGISTRY = new LinkedHashMap();

    private BehaviorRegistry() {
    }

    private static void put(Class<?> clazz, String ... behaviors) {
        assert (clazz.isInterface()) : "Only interfaces are allowed in the registry.";
        for (String behavior : behaviors) {
            List listOfClasses = REGISTRY.getOrDefault(behavior, new ArrayList());
            listOfClasses.add(clazz);
            REGISTRY.putIfAbsent(behavior, listOfClasses);
        }
    }

    public static Set<Class<?>> getClassesForBehaviors(Iterable<String> behaviors) {
        LinkedHashSet setOfClasses = new LinkedHashSet();
        if (behaviors != null) {
            for (String behavior : behaviors) {
                setOfClasses.addAll(REGISTRY.getOrDefault(behavior, Collections.emptyList()));
            }
        }
        return setOfClasses;
    }

    static {
        BehaviorRegistry.put(ClickNotifier.class, "Polymer.PaperButtonBehavior", "Polymer.GestureEventListeners", "vaadin-button", "vaadin-form-item");
        BehaviorRegistry.put(HasText.class, "vaadin-button", "paper-button");
        BehaviorRegistry.put(HasValue.class, "vaadin-password-field");
        BehaviorRegistry.put(HasValue.class, "vaadin-combo-box");
        BehaviorRegistry.put(Focusable.class, "paper-button", "Vaadin.FormElementMixin", "Vaadin.ControlStateMixin");
    }
}

