/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.generator.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class PropertyNameRemapRegistry {
    private static final Map<String, Map<String, String>> REGISTRY = new HashMap<String, Map<String, String>>();

    private PropertyNameRemapRegistry() {
    }

    private static void put(String elementIdentifier, String propertyNameToMap, String mappedValue) {
        Objects.requireNonNull(elementIdentifier, "elementIdentifier cannot be null.");
        Objects.requireNonNull(propertyNameToMap, "propertyNameToMap cannot be null.");
        Objects.requireNonNull(mappedValue, "mappedValue cannot be null.");
        Map map = REGISTRY.getOrDefault(elementIdentifier, new HashMap());
        map.put(propertyNameToMap, mappedValue);
        REGISTRY.put(elementIdentifier, map);
    }

    public static Optional<String> getOptionalMappingFor(String elementIdentifier, String propertyName) {
        if (!REGISTRY.containsKey(elementIdentifier)) {
            return Optional.empty();
        }
        return Optional.ofNullable(REGISTRY.get(elementIdentifier).get(propertyName));
    }

    static {
        PropertyNameRemapRegistry.put("vaadin-date-picker", "min", "minAsString");
        PropertyNameRemapRegistry.put("vaadin-date-picker", "max", "maxAsString");
    }
}

