/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.Entity;
import com.versionone.om.V1Instance;
import java.util.AbstractCollection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCollection<D extends Entity>
extends AbstractCollection<D> {
    private final V1Instance instance;
    private final Entity entity;
    private final String readAttributeName;
    private final String writeAttributeName;

    public EntityCollection(V1Instance instance, Entity entity, String readAttributeName, String writeAttributeName) {
        this.instance = instance;
        this.entity = entity;
        this.readAttributeName = readAttributeName;
        this.writeAttributeName = writeAttributeName;
    }

    @Override
    public boolean add(D item) throws UnsupportedOperationException {
        this.readOnlyGuardCondition();
        this.instance.addRelation(this.entity, this.writeAttributeName, item);
        this.entity.save();
        return true;
    }

    @Override
    public void clear() {
        this.readOnlyGuardCondition();
        for (Entity item : this) {
            this.instance.removeRelation(this.entity, this.writeAttributeName, item);
        }
        this.entity.save();
    }

    @Override
    public boolean contains(Object item) throws IllegalArgumentException {
        if (!(item instanceof Entity)) {
            throw new IllegalArgumentException();
        }
        return this.instance.multiRelationContains(this.entity, this.readAttributeName, (Entity)item);
    }

    public void copyTo(D[] array, int arrayIndex) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (arrayIndex < 0) {
            throw new IndexOutOfBoundsException("arrayIndex cannot be less than 0: " + arrayIndex);
        }
        if (array == null) {
            throw new IllegalArgumentException("array must not be null");
        }
        if (array.length < arrayIndex) {
            throw new IllegalArgumentException("arrayIndex is greater than the length of the array.");
        }
        if (arrayIndex + this.size() > array.length) {
            throw new IllegalArgumentException("The number of elements is greater than the length of the array. Array length:" + array.length + "; arrayIndex:" + arrayIndex + "; Count:" + this.size() + ".");
        }
        for (Entity entity : this) {
            array[arrayIndex++] = entity;
        }
    }

    @Override
    public boolean remove(Object item) throws UnsupportedOperationException {
        this.readOnlyGuardCondition();
        if (this.contains(item)) {
            this.instance.removeRelation(this.entity, this.writeAttributeName, (Entity)item);
            this.entity.save();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.instance.getMultiRelationCount(this.entity, this.readAttributeName);
    }

    public boolean isReadOnly() {
        return this.instance.isMultiRelationIsReadOnly(this.entity, this.writeAttributeName);
    }

    @Override
    public Iterator<D> iterator() {
        return this.instance.internalGetMultiRelation(this.entity, this.readAttributeName, null).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.instance.internalGetMultiRelation(this.entity, this.readAttributeName, null).toArray();
    }

    private void readOnlyGuardCondition() throws UnsupportedOperationException {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("The collection is Read-only");
        }
    }

    public EntityCollection<D> asReadOnly() {
        return new ReadOnly(this.instance, this.entity, this.readAttributeName, this.writeAttributeName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReadOnly<T extends Entity>
    extends EntityCollection<T> {
        public ReadOnly(V1Instance instance, Entity entity, String readAttributeName, String writeAttributeName) {
            super(instance, entity, readAttributeName, writeAttributeName);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

