/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis;

import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.api.FilesApi;
import com.vertexvis.model.CreateFileRequest;
import com.vertexvis.model.CreateFileRequestData;
import com.vertexvis.model.CreateFileRequestDataAttributes;
import java.util.HashMap;

public class Example {
    public static void main(String[] args) {
        String id = System.getenv("VERTEX_CLIENT_ID");
        String secret = System.getenv("VERTEX_CLIENT_SECRET");
        if (Example.isNullOrEmpty(id) || Example.isNullOrEmpty(secret)) {
            throw new RuntimeException("Environment variables containing your Vertex client ID and secret are required.");
        }
        ApiClient client = new ApiClient("https://platform.vertexvis.com", id, secret, new HashMap<String, String>());
        FilesApi files = new FilesApi(client);
        try {
            System.out.println(files.createFile(Example.buildCreateFileReq("my-file.jt")));
            System.out.println(files.getFiles(null, 2, null));
        }
        catch (ApiException e) {
            Throwable cause = e.getCause();
            System.err.printf("Exception calling Vertex API.\ncode=%d\nmessage=%s\nbody=%s%n", e.getCode(), cause == null ? e.getMessage() : cause.getMessage(), e.getResponseBody());
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static CreateFileRequest buildCreateFileReq(String fileName) {
        return new CreateFileRequest().data(new CreateFileRequestData().type("file").attributes(new CreateFileRequestDataAttributes().name(fileName)));
    }
}

