/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OAuth2Token {
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "token_type";
    @SerializedName(value="token_type")
    private String tokenType;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_EXPIRES_IN = "expires_in";
    @SerializedName(value="expires_in")
    private Integer expiresIn;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private List<String> scopes = new ArrayList<String>();

    public OAuth2Token accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(example="HnkQzHpk4iTaPfssu3zpI.PTbAxKdDIfrNcgrmsxQqg", required=true, value="")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuth2Token tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(example="bearer", required=true, value="")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public OAuth2Token accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="7b3f55e2-60f3-4bf3-82bc-f8afbce843b0", required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OAuth2Token expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @ApiModelProperty(example="3600", required=true, value="")
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public OAuth2Token scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuth2Token addScopesItem(String scopesItem) {
        this.scopes.add(scopesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Token oauth2Token = (OAuth2Token)o;
        return Objects.equals(this.accessToken, oauth2Token.accessToken) && Objects.equals(this.tokenType, oauth2Token.tokenType) && Objects.equals(this.accountId, oauth2Token.accountId) && Objects.equals(this.expiresIn, oauth2Token.expiresIn) && Objects.equals(this.scopes, oauth2Token.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.accountId, this.expiresIn, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2Token {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

