/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateTranslationInspectionRequest;
import com.vertexvis.model.QueuedJob;
import com.vertexvis.model.TranslationInspectionJob;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class TranslationInspectionsApi {
    private ApiClient localVarApiClient;

    public TranslationInspectionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TranslationInspectionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createTranslationInspectionCall(CreateTranslationInspectionRequest createTranslationInspectionRequest, ApiCallback _callback) throws ApiException {
        CreateTranslationInspectionRequest localVarPostBody = createTranslationInspectionRequest;
        String localVarPath = "/translation-inspections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTranslationInspectionValidateBeforeCall(CreateTranslationInspectionRequest createTranslationInspectionRequest, ApiCallback _callback) throws ApiException {
        if (createTranslationInspectionRequest == null) {
            throw new ApiException("Missing the required parameter 'createTranslationInspectionRequest' when calling createTranslationInspection(Async)");
        }
        Call localVarCall = this.createTranslationInspectionCall(createTranslationInspectionRequest, _callback);
        return localVarCall;
    }

    public TranslationInspectionJob createTranslationInspection(CreateTranslationInspectionRequest createTranslationInspectionRequest) throws ApiException {
        ApiResponse<TranslationInspectionJob> localVarResp = this.createTranslationInspectionWithHttpInfo(createTranslationInspectionRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TranslationInspectionJob> createTranslationInspectionWithHttpInfo(CreateTranslationInspectionRequest createTranslationInspectionRequest) throws ApiException {
        Call localVarCall = this.createTranslationInspectionValidateBeforeCall(createTranslationInspectionRequest, null);
        Type localVarReturnType = new TypeToken<TranslationInspectionJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTranslationInspectionAsync(CreateTranslationInspectionRequest createTranslationInspectionRequest, ApiCallback<TranslationInspectionJob> _callback) throws ApiException {
        Call localVarCall = this.createTranslationInspectionValidateBeforeCall(createTranslationInspectionRequest, _callback);
        Type localVarReturnType = new TypeToken<TranslationInspectionJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInspectionJobCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/translation-inspections/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInspectionJobValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getInspectionJob(Async)");
        }
        Call localVarCall = this.getInspectionJobCall(id, _callback);
        return localVarCall;
    }

    public TranslationInspectionJob getInspectionJob(UUID id) throws ApiException {
        ApiResponse<TranslationInspectionJob> localVarResp = this.getInspectionJobWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<TranslationInspectionJob> getInspectionJobWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getInspectionJobValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<TranslationInspectionJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInspectionJobAsync(UUID id, ApiCallback<TranslationInspectionJob> _callback) throws ApiException {
        Call localVarCall = this.getInspectionJobValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<TranslationInspectionJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getQueuedTranslationCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/queued-translations/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedTranslationValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedTranslation(Async)");
        }
        Call localVarCall = this.getQueuedTranslationCall(id, _callback);
        return localVarCall;
    }

    public QueuedJob getQueuedTranslation(UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedTranslationWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedTranslationWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getQueuedTranslationValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedTranslationAsync(UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedTranslationValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

