/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import com.vertexvis.model.Link;
import com.vertexvis.model.SceneViewDataRelationships;
import com.vertexvis.model.StreamKeyDataAttributes;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

public class StreamKeyData {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private StreamKeyDataAttributes attributes;
    public static final String SERIALIZED_NAME_RELATIONSHIPS = "relationships";
    @SerializedName(value="relationships")
    private SceneViewDataRelationships relationships;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private Map<String, Link> links = null;

    public StreamKeyData type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="stream-key", required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public StreamKeyData id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="f79d4760-0b71-44e4-ad0b-22743fdd4ca3", required=true, value="ID of the resource.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public StreamKeyData attributes(StreamKeyDataAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public StreamKeyDataAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(StreamKeyDataAttributes attributes) {
        this.attributes = attributes;
    }

    public StreamKeyData relationships(SceneViewDataRelationships relationships) {
        this.relationships = relationships;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SceneViewDataRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(SceneViewDataRelationships relationships) {
        this.relationships = relationships;
    }

    public StreamKeyData links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public StreamKeyData putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamKeyData streamKeyData = (StreamKeyData)o;
        return Objects.equals(this.type, streamKeyData.type) && Objects.equals(this.id, streamKeyData.id) && Objects.equals(this.attributes, streamKeyData.attributes) && Objects.equals(this.relationships, streamKeyData.relationships) && Objects.equals(this.links, streamKeyData.links);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, this.relationships, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StreamKeyData {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

