/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import com.vertexvis.model.Color3;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Color properties describing how a material looks.")
public class ColorMaterial {
    public static final String SERIALIZED_NAME_OPACITY = "opacity";
    @SerializedName(value="opacity")
    private Integer opacity;
    public static final String SERIALIZED_NAME_GLOSSINESS = "glossiness";
    @SerializedName(value="glossiness")
    private Integer glossiness;
    public static final String SERIALIZED_NAME_AMBIENT = "ambient";
    @SerializedName(value="ambient")
    private Color3 ambient;
    public static final String SERIALIZED_NAME_DIFFUSE = "diffuse";
    @SerializedName(value="diffuse")
    private Color3 diffuse;
    public static final String SERIALIZED_NAME_SPECULAR = "specular";
    @SerializedName(value="specular")
    private Color3 specular;
    public static final String SERIALIZED_NAME_EMISSIVE = "emissive";
    @SerializedName(value="emissive")
    private Color3 emissive;

    public ColorMaterial opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Opacity from 0 to 100.")
    public Integer getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public ColorMaterial glossiness(Integer glossiness) {
        this.glossiness = glossiness;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Glossiness from 0 to 128.")
    public Integer getGlossiness() {
        return this.glossiness;
    }

    public void setGlossiness(Integer glossiness) {
        this.glossiness = glossiness;
    }

    public ColorMaterial ambient(Color3 ambient) {
        this.ambient = ambient;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Color3 getAmbient() {
        return this.ambient;
    }

    public void setAmbient(Color3 ambient) {
        this.ambient = ambient;
    }

    public ColorMaterial diffuse(Color3 diffuse) {
        this.diffuse = diffuse;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Color3 getDiffuse() {
        return this.diffuse;
    }

    public void setDiffuse(Color3 diffuse) {
        this.diffuse = diffuse;
    }

    public ColorMaterial specular(Color3 specular) {
        this.specular = specular;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Color3 getSpecular() {
        return this.specular;
    }

    public void setSpecular(Color3 specular) {
        this.specular = specular;
    }

    public ColorMaterial emissive(Color3 emissive) {
        this.emissive = emissive;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Color3 getEmissive() {
        return this.emissive;
    }

    public void setEmissive(Color3 emissive) {
        this.emissive = emissive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorMaterial colorMaterial = (ColorMaterial)o;
        return Objects.equals(this.opacity, colorMaterial.opacity) && Objects.equals(this.glossiness, colorMaterial.glossiness) && Objects.equals(this.ambient, colorMaterial.ambient) && Objects.equals(this.diffuse, colorMaterial.diffuse) && Objects.equals(this.specular, colorMaterial.specular) && Objects.equals(this.emissive, colorMaterial.emissive);
    }

    public int hashCode() {
        return Objects.hash(this.opacity, this.glossiness, this.ambient, this.diffuse, this.specular, this.emissive);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColorMaterial {\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    glossiness: ").append(this.toIndentedString(this.glossiness)).append("\n");
        sb.append("    ambient: ").append(this.toIndentedString(this.ambient)).append("\n");
        sb.append("    diffuse: ").append(this.toIndentedString(this.diffuse)).append("\n");
        sb.append("    specular: ").append(this.toIndentedString(this.specular)).append("\n");
        sb.append("    emissive: ").append(this.toIndentedString(this.emissive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

