/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateExportRequest;
import com.vertexvis.model.Export;
import com.vertexvis.model.QueuedJob;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import okhttp3.Call;

public class ExportsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExportsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createExportCall(@Nonnull CreateExportRequest createExportRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateExportRequest localVarPostBody = createExportRequest;
        String localVarPath = "/exports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createExportValidateBeforeCall(@Nonnull CreateExportRequest createExportRequest, ApiCallback _callback) throws ApiException {
        if (createExportRequest == null) {
            throw new ApiException("Missing the required parameter 'createExportRequest' when calling createExport(Async)");
        }
        return this.createExportCall(createExportRequest, _callback);
    }

    public QueuedJob createExport(@Nonnull CreateExportRequest createExportRequest) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.createExportWithHttpInfo(createExportRequest);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> createExportWithHttpInfo(@Nonnull CreateExportRequest createExportRequest) throws ApiException {
        Call localVarCall = this.createExportValidateBeforeCall(createExportRequest, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createExportAsync(@Nonnull CreateExportRequest createExportRequest, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.createExportValidateBeforeCall(createExportRequest, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExportCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/exports/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExportValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getExport(Async)");
        }
        return this.getExportCall(id, _callback);
    }

    public Export getExport(@Nonnull UUID id) throws ApiException {
        ApiResponse<Export> localVarResp = this.getExportWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Export> getExportWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getExportValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExportAsync(@Nonnull UUID id, ApiCallback<Export> _callback) throws ApiException {
        Call localVarCall = this.getExportValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getQueuedExportCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/queued-exports/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedExportValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedExport(Async)");
        }
        return this.getQueuedExportCall(id, _callback);
    }

    public QueuedJob getQueuedExport(@Nonnull UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedExportWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedExportWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getQueuedExportValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedExportAsync(@Nonnull UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedExportValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

