/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreatePartRequest;
import com.vertexvis.model.Part;
import com.vertexvis.model.PartList;
import com.vertexvis.model.QueuedJob;
import com.vertexvis.model.UpdatePartRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class PartsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PartsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PartsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createPartCall(@Nonnull CreatePartRequest createPartRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePartRequest localVarPostBody = createPartRequest;
        String localVarPath = "/parts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPartValidateBeforeCall(@Nonnull CreatePartRequest createPartRequest, ApiCallback _callback) throws ApiException {
        if (createPartRequest == null) {
            throw new ApiException("Missing the required parameter 'createPartRequest' when calling createPart(Async)");
        }
        return this.createPartCall(createPartRequest, _callback);
    }

    public Part createPart(@Nonnull CreatePartRequest createPartRequest) throws ApiException {
        ApiResponse<Part> localVarResp = this.createPartWithHttpInfo(createPartRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Part> createPartWithHttpInfo(@Nonnull CreatePartRequest createPartRequest) throws ApiException {
        Call localVarCall = this.createPartValidateBeforeCall(createPartRequest, null);
        Type localVarReturnType = new TypeToken<Part>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createPartAsync(@Nonnull CreatePartRequest createPartRequest, ApiCallback<Part> _callback) throws ApiException {
        Call localVarCall = this.createPartValidateBeforeCall(createPartRequest, _callback);
        Type localVarReturnType = new TypeToken<Part>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deletePartCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/parts/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePartValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deletePart(Async)");
        }
        return this.deletePartCall(id, _callback);
    }

    public QueuedJob deletePart(@Nonnull UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.deletePartWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> deletePartWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.deletePartValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deletePartAsync(@Nonnull UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.deletePartValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPartCall(@Nonnull UUID id, @Nullable String include, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/parts/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (include != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include", include));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPartValidateBeforeCall(@Nonnull UUID id, @Nullable String include, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getPart(Async)");
        }
        return this.getPartCall(id, include, _callback);
    }

    public Part getPart(@Nonnull UUID id, @Nullable String include) throws ApiException {
        ApiResponse<Part> localVarResp = this.getPartWithHttpInfo(id, include);
        return localVarResp.getData();
    }

    public ApiResponse<Part> getPartWithHttpInfo(@Nonnull UUID id, @Nullable String include) throws ApiException {
        Call localVarCall = this.getPartValidateBeforeCall(id, include, null);
        Type localVarReturnType = new TypeToken<Part>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPartAsync(@Nonnull UUID id, @Nullable String include, ApiCallback<Part> _callback) throws ApiException {
        Call localVarCall = this.getPartValidateBeforeCall(id, include, _callback);
        Type localVarReturnType = new TypeToken<Part>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPartsCall(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSuppliedId, @Nullable UUID filterOwnerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/parts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if (filterSuppliedId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[suppliedId]", filterSuppliedId));
        }
        if (filterOwnerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[ownerId]", filterOwnerId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPartsValidateBeforeCall(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSuppliedId, @Nullable UUID filterOwnerId, ApiCallback _callback) throws ApiException {
        return this.getPartsCall(pageCursor, pageSize, filterSuppliedId, filterOwnerId, _callback);
    }

    public PartList getParts(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSuppliedId, @Nullable UUID filterOwnerId) throws ApiException {
        ApiResponse<PartList> localVarResp = this.getPartsWithHttpInfo(pageCursor, pageSize, filterSuppliedId, filterOwnerId);
        return localVarResp.getData();
    }

    public ApiResponse<PartList> getPartsWithHttpInfo(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSuppliedId, @Nullable UUID filterOwnerId) throws ApiException {
        Call localVarCall = this.getPartsValidateBeforeCall(pageCursor, pageSize, filterSuppliedId, filterOwnerId, null);
        Type localVarReturnType = new TypeToken<PartList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPartsAsync(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSuppliedId, @Nullable UUID filterOwnerId, ApiCallback<PartList> _callback) throws ApiException {
        Call localVarCall = this.getPartsValidateBeforeCall(pageCursor, pageSize, filterSuppliedId, filterOwnerId, _callback);
        Type localVarReturnType = new TypeToken<PartList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getQueuedPartDeletionCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/queued-part-deletions/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedPartDeletionValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedPartDeletion(Async)");
        }
        return this.getQueuedPartDeletionCall(id, _callback);
    }

    public QueuedJob getQueuedPartDeletion(@Nonnull UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedPartDeletionWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedPartDeletionWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getQueuedPartDeletionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedPartDeletionAsync(@Nonnull UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedPartDeletionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updatePartCall(@Nonnull UUID id, @Nonnull UpdatePartRequest updatePartRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdatePartRequest localVarPostBody = updatePartRequest;
        String localVarPath = "/parts/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePartValidateBeforeCall(@Nonnull UUID id, @Nonnull UpdatePartRequest updatePartRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updatePart(Async)");
        }
        if (updatePartRequest == null) {
            throw new ApiException("Missing the required parameter 'updatePartRequest' when calling updatePart(Async)");
        }
        return this.updatePartCall(id, updatePartRequest, _callback);
    }

    public void updatePart(@Nonnull UUID id, @Nonnull UpdatePartRequest updatePartRequest) throws ApiException {
        this.updatePartWithHttpInfo(id, updatePartRequest);
    }

    public ApiResponse<Void> updatePartWithHttpInfo(@Nonnull UUID id, @Nonnull UpdatePartRequest updatePartRequest) throws ApiException {
        Call localVarCall = this.updatePartValidateBeforeCall(id, updatePartRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updatePartAsync(@Nonnull UUID id, @Nonnull UpdatePartRequest updatePartRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updatePartValidateBeforeCall(id, updatePartRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

