/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateSceneViewRequest;
import com.vertexvis.model.SceneView;
import com.vertexvis.model.SceneViewItem;
import com.vertexvis.model.SceneViewList;
import com.vertexvis.model.UpdateSceneViewRequest;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class SceneViewsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SceneViewsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SceneViewsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSceneViewCall(@Nonnull UUID id, @Nonnull CreateSceneViewRequest createSceneViewRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateSceneViewRequest localVarPostBody = createSceneViewRequest;
        String localVarPath = "/scenes/{id}/scene-views".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSceneViewValidateBeforeCall(@Nonnull UUID id, @Nonnull CreateSceneViewRequest createSceneViewRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createSceneView(Async)");
        }
        if (createSceneViewRequest == null) {
            throw new ApiException("Missing the required parameter 'createSceneViewRequest' when calling createSceneView(Async)");
        }
        return this.createSceneViewCall(id, createSceneViewRequest, _callback);
    }

    public SceneView createSceneView(@Nonnull UUID id, @Nonnull CreateSceneViewRequest createSceneViewRequest) throws ApiException {
        ApiResponse<SceneView> localVarResp = this.createSceneViewWithHttpInfo(id, createSceneViewRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SceneView> createSceneViewWithHttpInfo(@Nonnull UUID id, @Nonnull CreateSceneViewRequest createSceneViewRequest) throws ApiException {
        Call localVarCall = this.createSceneViewValidateBeforeCall(id, createSceneViewRequest, null);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSceneViewAsync(@Nonnull UUID id, @Nonnull CreateSceneViewRequest createSceneViewRequest, ApiCallback<SceneView> _callback) throws ApiException {
        Call localVarCall = this.createSceneViewValidateBeforeCall(id, createSceneViewRequest, _callback);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSceneViewCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scene-views/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSceneViewValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteSceneView(Async)");
        }
        return this.deleteSceneViewCall(id, _callback);
    }

    public void deleteSceneView(@Nonnull UUID id) throws ApiException {
        this.deleteSceneViewWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteSceneViewWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.deleteSceneViewValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSceneViewAsync(@Nonnull UUID id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSceneViewValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getSceneViewCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scene-views/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSceneViewValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSceneView(Async)");
        }
        return this.getSceneViewCall(id, _callback);
    }

    public SceneView getSceneView(@Nonnull UUID id) throws ApiException {
        ApiResponse<SceneView> localVarResp = this.getSceneViewWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<SceneView> getSceneViewWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getSceneViewValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSceneViewAsync(@Nonnull UUID id, ApiCallback<SceneView> _callback) throws ApiException {
        Call localVarCall = this.getSceneViewValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSceneViewsCall(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scenes/{id}/scene-views".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSceneViewsValidateBeforeCall(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSceneViews(Async)");
        }
        return this.getSceneViewsCall(id, pageCursor, pageSize, _callback);
    }

    public SceneViewList getSceneViews(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize) throws ApiException {
        ApiResponse<SceneViewList> localVarResp = this.getSceneViewsWithHttpInfo(id, pageCursor, pageSize);
        return localVarResp.getData();
    }

    public ApiResponse<SceneViewList> getSceneViewsWithHttpInfo(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize) throws ApiException {
        Call localVarCall = this.getSceneViewsValidateBeforeCall(id, pageCursor, pageSize, null);
        Type localVarReturnType = new TypeToken<SceneViewList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSceneViewsAsync(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize, ApiCallback<SceneViewList> _callback) throws ApiException {
        Call localVarCall = this.getSceneViewsValidateBeforeCall(id, pageCursor, pageSize, _callback);
        Type localVarReturnType = new TypeToken<SceneViewList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getViewSceneItemCall(@Nonnull UUID id, @Nonnull UUID itemId, @Nullable String fieldsSceneItem, @Nullable String include, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scene-views/{id}/scene-items/{itemId}".replace("{id}", this.localVarApiClient.escapeString(id.toString())).replace("{itemId}", this.localVarApiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fieldsSceneItem != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields[scene-item]", fieldsSceneItem));
        }
        if (include != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include", include));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getViewSceneItemValidateBeforeCall(@Nonnull UUID id, @Nonnull UUID itemId, @Nullable String fieldsSceneItem, @Nullable String include, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getViewSceneItem(Async)");
        }
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling getViewSceneItem(Async)");
        }
        return this.getViewSceneItemCall(id, itemId, fieldsSceneItem, include, _callback);
    }

    public SceneViewItem getViewSceneItem(@Nonnull UUID id, @Nonnull UUID itemId, @Nullable String fieldsSceneItem, @Nullable String include) throws ApiException {
        ApiResponse<SceneViewItem> localVarResp = this.getViewSceneItemWithHttpInfo(id, itemId, fieldsSceneItem, include);
        return localVarResp.getData();
    }

    public ApiResponse<SceneViewItem> getViewSceneItemWithHttpInfo(@Nonnull UUID id, @Nonnull UUID itemId, @Nullable String fieldsSceneItem, @Nullable String include) throws ApiException {
        Call localVarCall = this.getViewSceneItemValidateBeforeCall(id, itemId, fieldsSceneItem, include, null);
        Type localVarReturnType = new TypeToken<SceneViewItem>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getViewSceneItemAsync(@Nonnull UUID id, @Nonnull UUID itemId, @Nullable String fieldsSceneItem, @Nullable String include, ApiCallback<SceneViewItem> _callback) throws ApiException {
        Call localVarCall = this.getViewSceneItemValidateBeforeCall(id, itemId, fieldsSceneItem, include, _callback);
        Type localVarReturnType = new TypeToken<SceneViewItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call renderSceneViewCall(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scene-views/{id}/image".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (height != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("height", height));
        }
        if (width != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("width", width));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"image/jpeg", "image/png", "application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call renderSceneViewValidateBeforeCall(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling renderSceneView(Async)");
        }
        return this.renderSceneViewCall(id, height, width, _callback);
    }

    public File renderSceneView(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width) throws ApiException {
        ApiResponse<File> localVarResp = this.renderSceneViewWithHttpInfo(id, height, width);
        return localVarResp.getData();
    }

    public ApiResponse<File> renderSceneViewWithHttpInfo(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width) throws ApiException {
        Call localVarCall = this.renderSceneViewValidateBeforeCall(id, height, width, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call renderSceneViewAsync(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.renderSceneViewValidateBeforeCall(id, height, width, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSceneViewCall(@Nonnull UUID id, @Nonnull UpdateSceneViewRequest updateSceneViewRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateSceneViewRequest localVarPostBody = updateSceneViewRequest;
        String localVarPath = "/scene-views/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSceneViewValidateBeforeCall(@Nonnull UUID id, @Nonnull UpdateSceneViewRequest updateSceneViewRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSceneView(Async)");
        }
        if (updateSceneViewRequest == null) {
            throw new ApiException("Missing the required parameter 'updateSceneViewRequest' when calling updateSceneView(Async)");
        }
        return this.updateSceneViewCall(id, updateSceneViewRequest, _callback);
    }

    public SceneView updateSceneView(@Nonnull UUID id, @Nonnull UpdateSceneViewRequest updateSceneViewRequest) throws ApiException {
        ApiResponse<SceneView> localVarResp = this.updateSceneViewWithHttpInfo(id, updateSceneViewRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SceneView> updateSceneViewWithHttpInfo(@Nonnull UUID id, @Nonnull UpdateSceneViewRequest updateSceneViewRequest) throws ApiException {
        Call localVarCall = this.updateSceneViewValidateBeforeCall(id, updateSceneViewRequest, null);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSceneViewAsync(@Nonnull UUID id, @Nonnull UpdateSceneViewRequest updateSceneViewRequest, ApiCallback<SceneView> _callback) throws ApiException {
        Call localVarCall = this.updateSceneViewValidateBeforeCall(id, updateSceneViewRequest, _callback);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

