/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.JSON;
import com.vertexvis.model.AbstractOpenApiSchema;
import com.vertexvis.model.ApiError;
import com.vertexvis.model.RelationshipData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchVertexvisBatchResultsInner
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(BatchVertexvisBatchResultsInner.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public BatchVertexvisBatchResultsInner() {
        super("anyOf", Boolean.FALSE);
    }

    public BatchVertexvisBatchResultsInner(Object o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof RelationshipData) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof ApiError) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be ApiError, RelationshipData");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public RelationshipData getRelationshipData() throws ClassCastException {
        return (RelationshipData)super.getActualInstance();
    }

    public ApiError getApiError() throws ClassCastException {
        return (ApiError)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            RelationshipData.validateJsonElement(jsonElement);
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for RelationshipData failed with `%s`.", e.getMessage()));
            try {
                ApiError.validateJsonElement(jsonElement);
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format("Deserialization for ApiError failed with `%s`.", e2.getMessage()));
                throw new IOException(String.format("The JSON string is invalid for BatchVertexvisBatchResultsInner with anyOf schemas: ApiError, RelationshipData. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
            }
        }
    }

    public static BatchVertexvisBatchResultsInner fromJson(String jsonString) throws IOException {
        return (BatchVertexvisBatchResultsInner)JSON.getGson().fromJson(jsonString, BatchVertexvisBatchResultsInner.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("RelationshipData", RelationshipData.class);
        schemas.put("ApiError", ApiError.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BatchVertexvisBatchResultsInner.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterRelationshipData = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RelationshipData.class));
            final TypeAdapter adapterApiError = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ApiError.class));
            return new TypeAdapter<BatchVertexvisBatchResultsInner>(){

                public void write(JsonWriter out, BatchVertexvisBatchResultsInner value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof RelationshipData) {
                        JsonElement element = adapterRelationshipData.toJsonTree((Object)((RelationshipData)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof ApiError) {
                        JsonElement element = adapterApiError.toJsonTree((Object)((ApiError)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemas: ApiError, RelationshipData");
                }

                public BatchVertexvisBatchResultsInner read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        RelationshipData.validateJsonElement(jsonElement);
                        actualAdapter = adapterRelationshipData;
                        BatchVertexvisBatchResultsInner ret = new BatchVertexvisBatchResultsInner();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for RelationshipData failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'RelationshipData'", e);
                        try {
                            ApiError.validateJsonElement(jsonElement);
                            actualAdapter = adapterApiError;
                            BatchVertexvisBatchResultsInner ret = new BatchVertexvisBatchResultsInner();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format("Deserialization for ApiError failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'ApiError'", e2);
                            throw new IOException(String.format("Failed deserialization for BatchVertexvisBatchResultsInner: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

