/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.JSON;
import com.vertexvis.model.HitDataAttributes;
import com.vertexvis.model.Link;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GeometrySetData {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    @Nonnull
    private String type;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nonnull
    private UUID id;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    @Nonnull
    private HitDataAttributes attributes;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    @Nullable
    private Map<String, Link> links = new HashMap<String, Link>();
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("type", "id", "attributes", "links"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("type", "id", "attributes"));

    public GeometrySetData type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public void setType(@Nonnull String type) {
        this.type = type;
    }

    public GeometrySetData id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public GeometrySetData attributes(@Nonnull HitDataAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nonnull
    public HitDataAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nonnull HitDataAttributes attributes) {
        this.attributes = attributes;
    }

    public GeometrySetData links(@Nullable Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public GeometrySetData putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(@Nullable Map<String, Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeometrySetData geometrySetData = (GeometrySetData)o;
        return Objects.equals(this.type, geometrySetData.type) && Objects.equals(this.id, geometrySetData.id) && Objects.equals(this.attributes, geometrySetData.attributes) && Objects.equals(this.links, geometrySetData.links);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeometrySetData {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in GeometrySetData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GeometrySetData` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        HitDataAttributes.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ATTRIBUTES));
    }

    public static GeometrySetData fromJson(String jsonString) throws IOException {
        return (GeometrySetData)JSON.getGson().fromJson(jsonString, GeometrySetData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GeometrySetData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GeometrySetData.class));
            return new TypeAdapter<GeometrySetData>(){

                public void write(JsonWriter out, GeometrySetData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GeometrySetData read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    GeometrySetData.validateJsonElement(jsonElement);
                    return (GeometrySetData)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

