/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.JSON;
import com.vertexvis.model.Vector3;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OrthographicCamera {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    @Nullable
    private String type;
    public static final String SERIALIZED_NAME_VIEW_VECTOR = "viewVector";
    @SerializedName(value="viewVector")
    @Nonnull
    private Vector3 viewVector;
    public static final String SERIALIZED_NAME_LOOK_AT = "lookAt";
    @SerializedName(value="lookAt")
    @Nonnull
    private Vector3 lookAt;
    public static final String SERIALIZED_NAME_UP = "up";
    @SerializedName(value="up")
    @Nonnull
    private Vector3 up;
    public static final String SERIALIZED_NAME_FOV_HEIGHT = "fovHeight";
    @SerializedName(value="fovHeight")
    @Nonnull
    private BigDecimal fovHeight;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("type", "viewVector", "lookAt", "up", "fovHeight"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("viewVector", "lookAt", "up", "fovHeight"));

    public OrthographicCamera type(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    public OrthographicCamera viewVector(@Nonnull Vector3 viewVector) {
        this.viewVector = viewVector;
        return this;
    }

    @Nonnull
    public Vector3 getViewVector() {
        return this.viewVector;
    }

    public void setViewVector(@Nonnull Vector3 viewVector) {
        this.viewVector = viewVector;
    }

    public OrthographicCamera lookAt(@Nonnull Vector3 lookAt) {
        this.lookAt = lookAt;
        return this;
    }

    @Nonnull
    public Vector3 getLookAt() {
        return this.lookAt;
    }

    public void setLookAt(@Nonnull Vector3 lookAt) {
        this.lookAt = lookAt;
    }

    public OrthographicCamera up(@Nonnull Vector3 up) {
        this.up = up;
        return this;
    }

    @Nonnull
    public Vector3 getUp() {
        return this.up;
    }

    public void setUp(@Nonnull Vector3 up) {
        this.up = up;
    }

    public OrthographicCamera fovHeight(@Nonnull BigDecimal fovHeight) {
        this.fovHeight = fovHeight;
        return this;
    }

    @Nonnull
    public BigDecimal getFovHeight() {
        return this.fovHeight;
    }

    public void setFovHeight(@Nonnull BigDecimal fovHeight) {
        this.fovHeight = fovHeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrthographicCamera orthographicCamera = (OrthographicCamera)o;
        return Objects.equals(this.type, orthographicCamera.type) && Objects.equals(this.viewVector, orthographicCamera.viewVector) && Objects.equals(this.lookAt, orthographicCamera.lookAt) && Objects.equals(this.up, orthographicCamera.up) && Objects.equals(this.fovHeight, orthographicCamera.fovHeight);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.viewVector, this.lookAt, this.up, this.fovHeight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrthographicCamera {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    viewVector: ").append(this.toIndentedString(this.viewVector)).append("\n");
        sb.append("    lookAt: ").append(this.toIndentedString(this.lookAt)).append("\n");
        sb.append("    up: ").append(this.toIndentedString(this.up)).append("\n");
        sb.append("    fovHeight: ").append(this.toIndentedString(this.fovHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OrthographicCamera is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OrthographicCamera` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        Vector3.validateJsonElement(jsonObj.get(SERIALIZED_NAME_VIEW_VECTOR));
        Vector3.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LOOK_AT));
        Vector3.validateJsonElement(jsonObj.get(SERIALIZED_NAME_UP));
    }

    public static OrthographicCamera fromJson(String jsonString) throws IOException {
        return (OrthographicCamera)JSON.getGson().fromJson(jsonString, OrthographicCamera.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OrthographicCamera.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OrthographicCamera.class));
            return new TypeAdapter<OrthographicCamera>(){

                public void write(JsonWriter out, OrthographicCamera value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OrthographicCamera read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    OrthographicCamera.validateJsonElement(jsonElement);
                    return (OrthographicCamera)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

