/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum ThreadType {
    COMMENT("comment"),
    ISSUE("issue");

    private String value;

    private ThreadType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThreadType fromValue(String value) {
        for (ThreadType b : ThreadType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        ThreadType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<ThreadType> {
        public void write(JsonWriter jsonWriter, ThreadType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public ThreadType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return ThreadType.fromValue(value);
        }
    }
}

