/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.Batch;
import com.vertexvis.model.CreateBatchRequest;
import com.vertexvis.model.QueuedJob;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import okhttp3.Call;

public class BatchesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BatchesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BatchesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createBatchCall(@Nonnull CreateBatchRequest createBatchRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateBatchRequest localVarPostBody = createBatchRequest;
        String localVarPath = "/batches";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBatchValidateBeforeCall(@Nonnull CreateBatchRequest createBatchRequest, ApiCallback _callback) throws ApiException {
        if (createBatchRequest == null) {
            throw new ApiException("Missing the required parameter 'createBatchRequest' when calling createBatch(Async)");
        }
        return this.createBatchCall(createBatchRequest, _callback);
    }

    public QueuedJob createBatch(@Nonnull CreateBatchRequest createBatchRequest) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.createBatchWithHttpInfo(createBatchRequest);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> createBatchWithHttpInfo(@Nonnull CreateBatchRequest createBatchRequest) throws ApiException {
        Call localVarCall = this.createBatchValidateBeforeCall(createBatchRequest, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createBatchAsync(@Nonnull CreateBatchRequest createBatchRequest, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.createBatchValidateBeforeCall(createBatchRequest, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBatchCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/batches/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBatchValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getBatch(Async)");
        }
        return this.getBatchCall(id, _callback);
    }

    public Batch getBatch(@Nonnull UUID id) throws ApiException {
        ApiResponse<Batch> localVarResp = this.getBatchWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Batch> getBatchWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getBatchValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Batch>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBatchAsync(@Nonnull UUID id, ApiCallback<Batch> _callback) throws ApiException {
        Call localVarCall = this.getBatchValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Batch>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getQueuedBatchCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/queued-batches/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedBatchValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedBatch(Async)");
        }
        return this.getQueuedBatchCall(id, _callback);
    }

    public QueuedJob getQueuedBatch(@Nonnull UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedBatchWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedBatchWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getQueuedBatchValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedBatchAsync(@Nonnull UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedBatchValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

